-- Table structure for table accounting_periods
DROP TABLE IF EXISTS accounting_periods;

CREATE TABLE `accounting_periods` (
  `period` int(11) NOT NULL DEFAULT '0',
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `start_date` date NOT NULL DEFAULT '0000-00-00',
  `end_date` date NOT NULL DEFAULT '0000-00-00',
  `date_added` date NOT NULL DEFAULT '0000-00-00',
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO accounting_periods (`period`,`fiscal_year`,`start_date`,`end_date`,`date_added`,`last_update`) VALUES 
('1', '2025', '2025-01-01', '2025-01-31', '2026-01-02', '2026-01-02 16:52:01'),
('2', '2025', '2025-02-01', '2025-02-28', '2026-01-02', '2026-01-02 16:52:01'),
('3', '2025', '2025-03-01', '2025-03-31', '2026-01-02', '2026-01-02 16:52:01'),
('4', '2025', '2025-04-01', '2025-04-30', '2026-01-02', '2026-01-02 16:52:01'),
('5', '2025', '2025-05-01', '2025-05-31', '2026-01-02', '2026-01-02 16:52:01'),
('6', '2025', '2025-06-01', '2025-06-30', '2026-01-02', '2026-01-02 16:52:01'),
('7', '2025', '2025-07-01', '2025-07-31', '2026-01-02', '2026-01-02 16:52:01'),
('8', '2025', '2025-08-01', '2025-08-31', '2026-01-02', '2026-01-02 16:52:01'),
('9', '2025', '2025-09-01', '2025-09-30', '2026-01-02', '2026-01-02 16:52:01'),
('10', '2025', '2025-10-01', '2025-10-31', '2026-01-02', '2026-01-02 16:52:01'),
('11', '2025', '2025-11-01', '2025-11-30', '2026-01-02', '2026-01-02 16:52:01'),
('12', '2025', '2025-12-01', '2025-12-31', '2026-01-02', '2026-01-02 16:52:01'),
('13', '2026', '2026-01-01', '2026-01-31', '2026-01-02', '2026-01-02 16:52:01'),
('14', '2026', '2026-02-01', '2026-02-28', '2026-01-02', '2026-01-02 16:52:01'),
('15', '2026', '2026-03-01', '2026-03-31', '2026-01-02', '2026-01-02 16:52:01'),
('16', '2026', '2026-04-01', '2026-04-30', '2026-01-02', '2026-01-02 16:52:01'),
('17', '2026', '2026-05-01', '2026-05-31', '2026-01-02', '2026-01-02 16:52:01'),
('18', '2026', '2026-06-01', '2026-06-30', '2026-01-02', '2026-01-02 16:52:01'),
('19', '2026', '2026-07-01', '2026-07-31', '2026-01-02', '2026-01-02 16:52:01'),
('20', '2026', '2026-08-01', '2026-08-31', '2026-01-02', '2026-01-02 16:52:01'),
('21', '2026', '2026-09-01', '2026-09-30', '2026-01-02', '2026-01-02 16:52:01'),
('22', '2026', '2026-10-01', '2026-10-31', '2026-01-02', '2026-01-02 16:52:01'),
('23', '2026', '2026-11-01', '2026-11-30', '2026-01-02', '2026-01-02 16:52:01'),
('24', '2026', '2026-12-01', '2026-12-31', '2026-01-02', '2026-01-02 16:52:01');


-- Table structure for table accounts_history
DROP TABLE IF EXISTS accounts_history;

CREATE TABLE `accounts_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `acct_id` int(11) NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `journal_id` int(2) NOT NULL DEFAULT '0',
  `purchase_invoice_id` char(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `so_po_ref_id` int(11) DEFAULT NULL,
  `post_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `acct_id` (`acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table address_book
DROP TABLE IF EXISTS address_book;

CREATE TABLE `address_book` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `type` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address1` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address2` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `city_town` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `state_province` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `postal_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `telephone1` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `telephone2` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `telephone3` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `telephone4` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `email` varchar(48) COLLATE utf8_unicode_ci DEFAULT '',
  `website` varchar(48) COLLATE utf8_unicode_ci DEFAULT '',
  `notes` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`ref_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table audit_log
DROP TABLE IF EXISTS audit_log;

CREATE TABLE `audit_log` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `action_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `stats` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `reference_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_page_accessed_zen` (`reference_id`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO audit_log (`id`,`action_date`,`user_id`,`ip_address`,`stats`,`reference_id`,`action`,`amount`) VALUES 
('1', '2026-01-02 16:52:03', '1', '::1', '2137565119ms, 3892q 4170ms', '', 'Accounting Period - Change', '0'),
('2', '2026-01-02 17:15:37', '1', '::1', '114ms, 5q 13ms', '', 'User Login -> admin', '0'),
('3', '2026-01-02 17:16:10', '1', '::1', '75ms, 3q 2ms', 'Naira', 'Currencies - Add', '0'),
('4', '2026-01-02 17:19:41', '1', '::1', '196ms, 5q 15ms', '', 'Current Order Status - Update', '0'),
('5', '2026-01-02 17:22:05', '1', '::1', '78ms, 3q 3ms', '6350', 'Chart of Accounts - Update', '0'),
('6', '2026-01-02 17:23:37', '1', '::1', '94ms, 3q 3ms', '1550', 'Chart of Accounts - Add', '0'),
('7', '2026-01-02 18:25:56', '1', '::1', '70753ms, 6q 17ms', '', 'User Login -> admin', '0'),
('8', '2026-01-02 18:33:32', '1', '::1', '96ms, 3q 2ms', '', 'User Logoff -> admin', '0'),
('9', '2026-01-02 18:33:46', '1', '::1', '7368ms, 6q 19ms', '', 'User Login -> admin', '0'),
('10', '2026-01-02 18:36:46', '1', '::1', '107ms, 3q 3ms', '1910', 'Chart of Accounts - Add', '0'),
('11', '2026-01-02 18:37:36', '1', '::1', '127ms, 3q 3ms', '', 'User Logoff -> admin', '0'),
('12', '2026-01-02 18:38:09', '1', '::1', '12857ms, 6q 23ms', '', 'User Login -> admin', '0'),
('13', '2026-01-02 18:38:47', '1', '::1', '96ms, 3q 4ms', '1900', 'Chart of Accounts - Update', '0'),
('14', '2026-01-02 18:39:43', '1', '::1', '95ms, 3q 3ms', '1510', 'Chart of Accounts - Add', '0'),
('15', '2026-01-02 18:40:34', '1', '::1', '116ms, 3q 4ms', '1920', 'Chart of Accounts - Add', '0'),
('16', '2026-01-02 18:41:02', '1', '::1', '135ms, 6q 7ms', '2330', 'Chart of Accounts - Delete', '0'),
('17', '2026-01-02 18:41:50', '1', '::1', '97ms, 3q 3ms', '2310', 'Chart of Accounts - Update', '0'),
('18', '2026-01-02 18:41:51', '1', '::1', '182ms, 6q 4ms', '2330', 'Chart of Accounts - Delete', '0'),
('19', '2026-01-02 18:42:31', '1', '::1', '144ms, 6q 9ms', '2312', 'Chart of Accounts - Delete', '0'),
('20', '2026-01-02 18:43:37', '1', '::1', '187ms, 6q 9ms', '2314', 'Chart of Accounts - Delete', '0'),
('21', '2026-01-02 18:49:08', '1', '::1', '115ms, 3q 5ms', '2350', 'Chart of Accounts - Update', '0'),
('22', '2026-01-02 18:49:38', '1', '::1', '146ms, 6q 10ms', '2370', 'Chart of Accounts - Delete', '0'),
('23', '2026-01-02 18:49:45', '1', '::1', '107ms, 6q 4ms', '2370', 'Chart of Accounts - Delete', '0'),
('24', '2026-01-02 18:51:01', '1', '::1', '139ms, 3q 5ms', '1410', 'Chart of Accounts - Add', '0'),
('25', '2026-01-02 18:51:03', '1', '::1', '199ms, 6q 5ms', '2370', 'Chart of Accounts - Delete', '0'),
('26', '2026-01-02 18:52:34', '1', '::1', '102ms, 3q 4ms', '2410', 'Chart of Accounts - Add', '0'),
('27', '2026-01-02 18:52:36', '1', '::1', '273ms, 6q 5ms', '2370', 'Chart of Accounts - Delete', '0'),
('28', '2026-01-02 18:56:57', '1', '::1', '75ms, 3q 4ms', '5400', 'Chart of Accounts - Update', '0'),
('29', '2026-01-02 18:57:42', '1', '::1', '108ms, 3q 3ms', '6350', 'Chart of Accounts - Update', '0'),
('30', '2026-01-02 18:58:43', '1', '::1', '110ms, 3q 3ms', '6360', 'Chart of Accounts - Add', '0'),
('31', '2026-01-02 18:59:53', '1', '::1', '133ms, 3q 3ms', '6650', 'Chart of Accounts - Update', '0'),
('32', '2026-01-02 19:00:49', '1', '::1', '119ms, 3q 5ms', '6800', 'Chart of Accounts - Update', '0'),
('33', '2026-01-02 19:02:27', '1', '::1', '96ms, 3q 2ms', '6700', 'Chart of Accounts - Update', '0'),
('34', '2026-01-02 19:03:04', '1', '::1', '105ms, 3q 4ms', '6750', 'Chart of Accounts - Update', '0'),
('35', '2026-01-04 20:28:55', '1', '::1', '30935ms, 6q 16ms', '', 'User Login -> admin', '0'),
('36', '2026-01-04 21:15:17', '1', '::1', '32457ms, 6q 18ms', '', 'User Login -> admin', '0'),
('37', '2026-01-04 21:40:27', '1', '::1', '15334ms, 6q 12ms', '', 'User Login -> admin', '0'),
('38', '2026-01-04 21:53:43', '1', '::1', '11349ms, 6q 14ms', '', 'User Login -> admin', '0'),
('39', '2026-01-04 21:57:19', '1', '::1', '94ms, 3q 3ms', 'US Dollar', 'Currencies - Update', '0'),
('40', '2026-01-04 22:01:00', '1', '::1', '77ms, 3q 5ms', '1070', 'Chart of Accounts - Update', '0'),
('41', '2026-01-04 22:02:39', '1', '::1', '72ms, 3q 3ms', '1971', 'Chart of Accounts - Add', '0'),
('42', '2026-01-04 22:04:02', '1', '::1', '82ms, 3q 4ms', '1055', 'Chart of Accounts - Update', '0'),
('43', '2026-01-04 22:04:29', '1', '::1', '80ms, 3q 5ms', '1020', 'Chart of Accounts - Update', '0'),
('44', '2026-01-04 23:11:04', '1', '::1', '150058ms, 6q 15ms', '', 'User Login -> admin', '0'),
('45', '2026-01-04 23:22:28', '1', '::1', '24839ms, 6q 10ms', '', 'User Login -> admin', '0'),
('46', '2026-01-04 23:23:48', '1', '::1', '103ms, 3q 4ms', '1045', 'Chart of Accounts - Update', '0'),
('47', '2026-01-04 23:25:18', '1', '::1', '74ms, 3q 3ms', '1053', 'Chart of Accounts - Update', '0'),
('48', '2026-01-04 23:26:07', '1', '::1', '102ms, 3q 5ms', '1061', 'Chart of Accounts - Update', '0'),
('49', '2026-01-04 23:28:06', '1', '::1', '95ms, 3q 4ms', '1071', 'Chart of Accounts - Add', '0'),
('50', '2026-01-04 23:28:57', '1', '::1', '79ms, 3q 3ms', '1072', 'Chart of Accounts - Add', '0'),
('51', '2026-01-04 23:33:24', '1', '::1', '100ms, 3q 6ms', '1047', 'Chart of Accounts - Update', '0'),
('52', '2026-01-04 23:34:50', '1', '::1', '110ms, 3q 4ms', 'admin', 'User admin (Update)', '0'),
('53', '2026-01-04 23:36:26', '1', '::1', '130ms, 3q 15ms', 'FIRS', 'Tax Authorities - Add', '0'),
('54', '2026-01-04 23:36:57', '1', '::1', '111ms, 3q 5ms', 'FIRS', 'Tax Authorities - Add', '0'),
('55', '2026-01-04 23:37:32', '1', '::1', '84ms, 3q 3ms', 'VAT', 'Tax Rates - Add', '0'),
('56', '2026-01-04 23:37:53', '1', '::1', '96ms, 3q 4ms', 'VAT', 'Tax Rates - Add', '0'),
('57', '2026-01-04 23:38:58', '1', '::1', '73ms, 3q 3ms', 'WHT', 'Tax Rates - Add', '0'),
('58', '2026-01-04 23:39:21', '1', '::1', '74ms, 3q 3ms', 'FIRS', 'Tax Authorities - Add', '0'),
('59', '2026-01-04 23:43:55', '1', '::1', '120ms, 3q 5ms', '1155', 'Chart of Accounts - Add', '0'),
('60', '2026-01-04 23:44:22', '1', '::1', '68ms, 3q 4ms', 'FIRS', 'Tax Authorities - Update', '0'),
('61', '2026-01-04 23:44:49', '1', '::1', '97ms, 3q 5ms', 'WHT', 'Tax Rates - Update', '0'),
('62', '2026-01-04 23:47:28', '1', '::1', '101ms, 3q 4ms', 'FIRS', 'Tax Authorities - Update', '0'),
('63', '2026-01-04 23:51:46', '1', '::1', '81ms, 3q 2ms', 'Euro', 'Currencies - Update', '0');


-- Table structure for table chart_of_accounts
DROP TABLE IF EXISTS chart_of_accounts;

CREATE TABLE `chart_of_accounts` (
  `id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `heading_only` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `primary_acct_id` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_type` tinyint(4) NOT NULL DEFAULT '0',
  `account_inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`account_type`),
  KEY `heading_only` (`heading_only`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO chart_of_accounts (`id`,`description`,`heading_only`,`primary_acct_id`,`account_type`,`account_inactive`) VALUES 
('1000', 'Cash', '0', '', '0', '0'),
('1020', 'Access Bank Limited', '0', '', '0', '1'),
('1021', 'Access Holdings Plc', '0', '', '0', '1'),
('1022', 'Alternative Bank Limited', '0', '', '0', '1'),
('1023', 'Citibank Nigeria Limited', '0', '', '0', '1'),
('1024', 'Coronation Merchant
Bank Limited', '0', '', '0', '1'),
('1025', 'Cowrywise', '0', '', '0', '1'),
('1026', 'Ecobank Nigeria Limited', '0', '', '0', '1'),
('1027', 'Fairmoney', '0', '', '0', '1'),
('1028', 'FBN Holdings Plc', '0', '', '0', '1'),
('1029', 'FBN Merchant Bank Limited', '0', '', '0', '1'),
('1030', 'FCMB Group Plc', '0', '', '0', '1'),
('1031', 'Fidelity Bank Plc', '0', '', '0', '1'),
('1032', 'First Bank Nigeria Limited', '0', '', '0', '1'),
('1033', 'First City Monument Bank  Limited', '0', '', '0', '1'),
('1034', 'FSDH Holding Company Limited', '0', '', '0', '1'),
('1035', 'FSDH Merchant Bank Limited', '0', '', '0', '1'),
('1036', 'Globus Bank Limited', '0', '', '0', '1'),
('1037', 'Greenwich Merchant Bank Limited', '0', '', '0', '1'),
('1038', 'Guaranty Trust Bank Limited', '0', '', '0', '1'),
('1039', 'Guaranty Trust Holding Company Plc', '0', '', '0', '1'),
('1040', 'Heritage Bank Plc', '0', '', '0', '1'),
('1041', 'Jaiz Bank Plc', '0', '', '0', '1'),
('1042', 'Keystone Bank Limited', '0', '', '0', '1'),
('1043', 'Kuda', '0', '', '0', '1'),
('1044', 'Lotus Bank Limited', '0', '', '0', '1'),
('1045', 'Moniepoint (TridalTech - 5073372785)', '0', '', '0', '0'),
('1046', 'Nova Merchant Bank
Limited', '0', '', '0', '1'),
('1047', 'Opay (6141885764)', '0', '', '0', '0'),
('1048', 'Optimus Bank Limited', '0', '', '0', '1'),
('1049', 'Paga', '0', '', '0', '1'),
('1050', 'Palmpay', '0', '', '0', '1'),
('1051', 'Parallex Bank Limited', '0', '', '0', '1'),
('1052', 'Piggyvest', '0', '', '0', '1'),
('1053', 'Polaris Bank Limited (4091817379)', '0', '', '0', '0'),
('1054', 'Premium Trust Bank Limited', '0', '', '0', '1'),
('1055', 'Providus Bank Limited (TridalHub - 1305856219)', '0', '', '0', '0'),
('1056', 'Rand Merchant Bank
Limited', '0', '', '0', '1'),
('1057', 'Signature Bank Limited', '0', '', '0', '1'),
('1058', 'Stanbic IBTC Bank Limited', '0', '', '0', '1'),
('1059', 'Stanbic IBTC Holdings Plc', '0', '', '0', '1'),
('1060', 'Standard Chartered Bank Limited', '0', '', '0', '1'),
('1061', 'Sterling Bank Limited (0505143566)', '0', '', '0', '0'),
('1062', 'Sterling Financial Holdings Limited', '0', '', '0', '1'),
('1063', 'Suntrust Bank Nigeria Limited', '0', '', '0', '1'),
('1064', 'TAJ Bank Limited', '0', '', '0', '1'),
('1065', 'Titan Trust Bank Limited', '0', '', '0', '1'),
('1066', 'Union Bank Of Nigeria Plc', '0', '', '0', '1'),
('1067', 'United Bank Of Africa Plc', '0', '', '0', '0'),
('1068', 'Unity Bank Plc', '0', '', '0', '1'),
('1069', 'Wema Bank Plc', '0', '', '0', '1'),
('1070', 'Zenith Bank Plc (TridalTech - 1016124775)', '0', '', '0', '0'),
('1071', 'Moniepoint (TridalTech - 6173535399)', '0', '', '0', '0'),
('1072', 'Sterling Bank Limited (0122190444)', '0', '', '0', '0'),
('1073', 'Zenith Bank Plc (TridalHub Technology - 1229530828)', '0', '', '0', '0'),
('1100', 'Accounts Receivable', '0', '', '2', '0'),
('1150', 'Allowance for Doubtful Debt', '0', '', '2', '0'),
('1200', 'Inventory', '0', '', '4', '0'),
('1400', 'Prepaid Expenses', '0', '', '6', '0'),
('1410', 'Staff Loans', '0', '', '6', '0'),
('1500', 'Property and Equipment', '0', '', '8', '0'),
('1510', 'Land & Building', '0', '', '8', '0'),
('1550', 'Furniture & Fittings', '0', '', '8', '0'),
('1900', 'Accum. Dep - Property and Equipment', '0', '', '10', '0'),
('1910', 'Accm. Dep - Furniture & Fittings', '0', '', '10', '0'),
('1920', 'Accm. Dep - Land & Building', '0', '', '10', '0'),
('2000', 'Accounts Payable', '0', '', '20', '0'),
('2310', 'VAT Payable', '0', '', '22', '0'),
('2315', 'WHT', '0', '', '22', '0'),
('2350', 'PAYE Taxes Payable', '0', '', '22', '0'),
('2380', 'Income Taxes Payable', '0', '', '22', '0'),
('2400', 'Customer Deposits', '0', '', '22', '0'),
('2410', 'Loans from Banks', '0', '', '22', '0'),
('2500', 'Current Portion Long-Term Debt', '0', '', '22', '0'),
('2700', 'Long Term Debt - Noncurrent', '0', '', '22', '0'),
('3100', 'Owners Contribution', '0', '', '42', '0'),
('3200', 'Owners Draw', '0', '', '42', '0'),
('3800', 'Retained Earnings', '0', '', '44', '0'),
('4000', 'Sales Income', '0', '', '30', '0'),
('4100', 'Interest Income', '0', '', '30', '0'),
('4200', 'Finance Charge Income', '0', '', '30', '0'),
('4300', 'Other Income', '0', '', '30', '0'),
('4900', 'Sales Discounts', '0', '', '30', '0'),
('5000', 'Cost of Sales', '0', '', '32', '0'),
('5100', 'Cost of Sales - Freight', '0', '', '32', '0'),
('5400', 'Cost of Sales - Wage', '0', '', '32', '0'),
('5900', 'Inventory Adjustments', '0', '', '32', '0'),
('6000', 'Wages Expense', '0', '', '34', '0'),
('6050', 'Employee Benefit Programs Expe', '0', '', '34', '0'),
('6100', 'Payroll Tax Expense', '0', '', '34', '0'),
('6150', 'Bad Debt Expense', '0', '', '34', '0'),
('6200', 'Income Tax Expense', '0', '', '34', '0'),
('6250', 'Other Taxes Expense', '0', '', '34', '0'),
('6300', 'Rent or Lease Expense', '0', '', '34', '0'),
('6350', 'Office Maintenance & Repairs Expense', '0', '', '34', '0'),
('6360', 'Vehicle Maintenance & Repairs', '0', '', '34', '0'),
('6400', 'Utilities Expense', '0', '', '34', '0'),
('6450', 'Office Supplies Expense', '0', '', '34', '0'),
('6500', 'Telephone Expense', '0', '', '34', '0'),
('6550', 'Other Office Expense', '0', '', '34', '0'),
('6600', 'Advertising Expense', '0', '', '34', '0'),
('6650', 'Commission Expense', '0', '', '34', '0'),
('6700', 'Audit Fees Expense', '0', '', '34', '0'),
('6750', 'MD Expense', '0', '', '34', '0'),
('6800', 'Accounting Fee Expense', '0', '', '34', '0'),
('6850', 'Service Charge Expense', '0', '', '34', '0'),
('6900', 'Purchase Discount Expense', '0', '', '34', '0'),
('6950', 'Insurance Expense', '0', '', '34', '0'),
('7000', 'Over and Short Expense', '0', '', '34', '0'),
('7050', 'Depreciation Expense', '0', '', '34', '0'),
('7100', 'Gain/Loss - Sale of Assets Exp', '0', '', '34', '0');


-- Table structure for table chart_of_accounts_history
DROP TABLE IF EXISTS chart_of_accounts_history;

CREATE TABLE `chart_of_accounts_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period` int(11) NOT NULL DEFAULT '0',
  `account_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `beginning_balance` double NOT NULL DEFAULT '0',
  `debit_amount` double NOT NULL DEFAULT '0',
  `credit_amount` double NOT NULL DEFAULT '0',
  `budget` double NOT NULL DEFAULT '0',
  `last_update` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `period` (`period`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2881 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1', '1', '1000', '0', '0', '0', '0', '0000-00-00'),
('2', '2', '1000', '0', '0', '0', '0', '0000-00-00'),
('3', '3', '1000', '0', '0', '0', '0', '0000-00-00'),
('4', '4', '1000', '0', '0', '0', '0', '0000-00-00'),
('5', '5', '1000', '0', '0', '0', '0', '0000-00-00'),
('6', '6', '1000', '0', '0', '0', '0', '0000-00-00'),
('7', '7', '1000', '0', '0', '0', '0', '0000-00-00'),
('8', '8', '1000', '0', '0', '0', '0', '0000-00-00'),
('9', '9', '1000', '0', '0', '0', '0', '0000-00-00'),
('10', '10', '1000', '0', '0', '0', '0', '0000-00-00'),
('11', '11', '1000', '0', '0', '0', '0', '0000-00-00'),
('12', '12', '1000', '0', '0', '0', '0', '0000-00-00'),
('13', '13', '1000', '0', '0', '0', '0', '0000-00-00'),
('14', '14', '1000', '0', '0', '0', '0', '0000-00-00'),
('15', '15', '1000', '0', '0', '0', '0', '0000-00-00'),
('16', '16', '1000', '0', '0', '0', '0', '0000-00-00'),
('17', '17', '1000', '0', '0', '0', '0', '0000-00-00'),
('18', '18', '1000', '0', '0', '0', '0', '0000-00-00'),
('19', '19', '1000', '0', '0', '0', '0', '0000-00-00'),
('20', '20', '1000', '0', '0', '0', '0', '0000-00-00'),
('21', '21', '1000', '0', '0', '0', '0', '0000-00-00'),
('22', '22', '1000', '0', '0', '0', '0', '0000-00-00'),
('23', '23', '1000', '0', '0', '0', '0', '0000-00-00'),
('24', '24', '1000', '0', '0', '0', '0', '0000-00-00'),
('25', '1', '1020', '0', '0', '0', '0', '0000-00-00'),
('26', '2', '1020', '0', '0', '0', '0', '0000-00-00'),
('27', '3', '1020', '0', '0', '0', '0', '0000-00-00'),
('28', '4', '1020', '0', '0', '0', '0', '0000-00-00'),
('29', '5', '1020', '0', '0', '0', '0', '0000-00-00'),
('30', '6', '1020', '0', '0', '0', '0', '0000-00-00'),
('31', '7', '1020', '0', '0', '0', '0', '0000-00-00'),
('32', '8', '1020', '0', '0', '0', '0', '0000-00-00'),
('33', '9', '1020', '0', '0', '0', '0', '0000-00-00'),
('34', '10', '1020', '0', '0', '0', '0', '0000-00-00'),
('35', '11', '1020', '0', '0', '0', '0', '0000-00-00'),
('36', '12', '1020', '0', '0', '0', '0', '0000-00-00'),
('37', '13', '1020', '0', '0', '0', '0', '0000-00-00'),
('38', '14', '1020', '0', '0', '0', '0', '0000-00-00'),
('39', '15', '1020', '0', '0', '0', '0', '0000-00-00'),
('40', '16', '1020', '0', '0', '0', '0', '0000-00-00'),
('41', '17', '1020', '0', '0', '0', '0', '0000-00-00'),
('42', '18', '1020', '0', '0', '0', '0', '0000-00-00'),
('43', '19', '1020', '0', '0', '0', '0', '0000-00-00'),
('44', '20', '1020', '0', '0', '0', '0', '0000-00-00'),
('45', '21', '1020', '0', '0', '0', '0', '0000-00-00'),
('46', '22', '1020', '0', '0', '0', '0', '0000-00-00'),
('47', '23', '1020', '0', '0', '0', '0', '0000-00-00'),
('48', '24', '1020', '0', '0', '0', '0', '0000-00-00'),
('49', '1', '1100', '0', '0', '0', '0', '0000-00-00'),
('50', '2', '1100', '0', '0', '0', '0', '0000-00-00'),
('51', '3', '1100', '0', '0', '0', '0', '0000-00-00'),
('52', '4', '1100', '0', '0', '0', '0', '0000-00-00'),
('53', '5', '1100', '0', '0', '0', '0', '0000-00-00'),
('54', '6', '1100', '0', '0', '0', '0', '0000-00-00'),
('55', '7', '1100', '0', '0', '0', '0', '0000-00-00'),
('56', '8', '1100', '0', '0', '0', '0', '0000-00-00'),
('57', '9', '1100', '0', '0', '0', '0', '0000-00-00'),
('58', '10', '1100', '0', '0', '0', '0', '0000-00-00'),
('59', '11', '1100', '0', '0', '0', '0', '0000-00-00'),
('60', '12', '1100', '0', '0', '0', '0', '0000-00-00'),
('61', '13', '1100', '0', '0', '0', '0', '0000-00-00'),
('62', '14', '1100', '0', '0', '0', '0', '0000-00-00'),
('63', '15', '1100', '0', '0', '0', '0', '0000-00-00'),
('64', '16', '1100', '0', '0', '0', '0', '0000-00-00'),
('65', '17', '1100', '0', '0', '0', '0', '0000-00-00'),
('66', '18', '1100', '0', '0', '0', '0', '0000-00-00'),
('67', '19', '1100', '0', '0', '0', '0', '0000-00-00'),
('68', '20', '1100', '0', '0', '0', '0', '0000-00-00'),
('69', '21', '1100', '0', '0', '0', '0', '0000-00-00'),
('70', '22', '1100', '0', '0', '0', '0', '0000-00-00'),
('71', '23', '1100', '0', '0', '0', '0', '0000-00-00'),
('72', '24', '1100', '0', '0', '0', '0', '0000-00-00'),
('73', '1', '1150', '0', '0', '0', '0', '0000-00-00'),
('74', '2', '1150', '0', '0', '0', '0', '0000-00-00'),
('75', '3', '1150', '0', '0', '0', '0', '0000-00-00'),
('76', '4', '1150', '0', '0', '0', '0', '0000-00-00'),
('77', '5', '1150', '0', '0', '0', '0', '0000-00-00'),
('78', '6', '1150', '0', '0', '0', '0', '0000-00-00'),
('79', '7', '1150', '0', '0', '0', '0', '0000-00-00'),
('80', '8', '1150', '0', '0', '0', '0', '0000-00-00'),
('81', '9', '1150', '0', '0', '0', '0', '0000-00-00'),
('82', '10', '1150', '0', '0', '0', '0', '0000-00-00'),
('83', '11', '1150', '0', '0', '0', '0', '0000-00-00'),
('84', '12', '1150', '0', '0', '0', '0', '0000-00-00'),
('85', '13', '1150', '0', '0', '0', '0', '0000-00-00'),
('86', '14', '1150', '0', '0', '0', '0', '0000-00-00'),
('87', '15', '1150', '0', '0', '0', '0', '0000-00-00'),
('88', '16', '1150', '0', '0', '0', '0', '0000-00-00'),
('89', '17', '1150', '0', '0', '0', '0', '0000-00-00'),
('90', '18', '1150', '0', '0', '0', '0', '0000-00-00'),
('91', '19', '1150', '0', '0', '0', '0', '0000-00-00'),
('92', '20', '1150', '0', '0', '0', '0', '0000-00-00'),
('93', '21', '1150', '0', '0', '0', '0', '0000-00-00'),
('94', '22', '1150', '0', '0', '0', '0', '0000-00-00'),
('95', '23', '1150', '0', '0', '0', '0', '0000-00-00'),
('96', '24', '1150', '0', '0', '0', '0', '0000-00-00'),
('97', '1', '1200', '0', '0', '0', '0', '0000-00-00'),
('98', '2', '1200', '0', '0', '0', '0', '0000-00-00'),
('99', '3', '1200', '0', '0', '0', '0', '0000-00-00'),
('100', '4', '1200', '0', '0', '0', '0', '0000-00-00'),
('101', '5', '1200', '0', '0', '0', '0', '0000-00-00'),
('102', '6', '1200', '0', '0', '0', '0', '0000-00-00'),
('103', '7', '1200', '0', '0', '0', '0', '0000-00-00'),
('104', '8', '1200', '0', '0', '0', '0', '0000-00-00'),
('105', '9', '1200', '0', '0', '0', '0', '0000-00-00'),
('106', '10', '1200', '0', '0', '0', '0', '0000-00-00'),
('107', '11', '1200', '0', '0', '0', '0', '0000-00-00'),
('108', '12', '1200', '0', '0', '0', '0', '0000-00-00'),
('109', '13', '1200', '0', '0', '0', '0', '0000-00-00'),
('110', '14', '1200', '0', '0', '0', '0', '0000-00-00'),
('111', '15', '1200', '0', '0', '0', '0', '0000-00-00'),
('112', '16', '1200', '0', '0', '0', '0', '0000-00-00'),
('113', '17', '1200', '0', '0', '0', '0', '0000-00-00'),
('114', '18', '1200', '0', '0', '0', '0', '0000-00-00'),
('115', '19', '1200', '0', '0', '0', '0', '0000-00-00'),
('116', '20', '1200', '0', '0', '0', '0', '0000-00-00'),
('117', '21', '1200', '0', '0', '0', '0', '0000-00-00'),
('118', '22', '1200', '0', '0', '0', '0', '0000-00-00'),
('119', '23', '1200', '0', '0', '0', '0', '0000-00-00'),
('120', '24', '1200', '0', '0', '0', '0', '0000-00-00'),
('121', '1', '1400', '0', '0', '0', '0', '0000-00-00'),
('122', '2', '1400', '0', '0', '0', '0', '0000-00-00'),
('123', '3', '1400', '0', '0', '0', '0', '0000-00-00'),
('124', '4', '1400', '0', '0', '0', '0', '0000-00-00'),
('125', '5', '1400', '0', '0', '0', '0', '0000-00-00'),
('126', '6', '1400', '0', '0', '0', '0', '0000-00-00'),
('127', '7', '1400', '0', '0', '0', '0', '0000-00-00'),
('128', '8', '1400', '0', '0', '0', '0', '0000-00-00'),
('129', '9', '1400', '0', '0', '0', '0', '0000-00-00'),
('130', '10', '1400', '0', '0', '0', '0', '0000-00-00'),
('131', '11', '1400', '0', '0', '0', '0', '0000-00-00'),
('132', '12', '1400', '0', '0', '0', '0', '0000-00-00'),
('133', '13', '1400', '0', '0', '0', '0', '0000-00-00'),
('134', '14', '1400', '0', '0', '0', '0', '0000-00-00'),
('135', '15', '1400', '0', '0', '0', '0', '0000-00-00'),
('136', '16', '1400', '0', '0', '0', '0', '0000-00-00'),
('137', '17', '1400', '0', '0', '0', '0', '0000-00-00'),
('138', '18', '1400', '0', '0', '0', '0', '0000-00-00'),
('139', '19', '1400', '0', '0', '0', '0', '0000-00-00'),
('140', '20', '1400', '0', '0', '0', '0', '0000-00-00'),
('141', '21', '1400', '0', '0', '0', '0', '0000-00-00'),
('142', '22', '1400', '0', '0', '0', '0', '0000-00-00'),
('143', '23', '1400', '0', '0', '0', '0', '0000-00-00'),
('144', '24', '1400', '0', '0', '0', '0', '0000-00-00'),
('145', '1', '1500', '0', '0', '0', '0', '0000-00-00'),
('146', '2', '1500', '0', '0', '0', '0', '0000-00-00'),
('147', '3', '1500', '0', '0', '0', '0', '0000-00-00'),
('148', '4', '1500', '0', '0', '0', '0', '0000-00-00'),
('149', '5', '1500', '0', '0', '0', '0', '0000-00-00'),
('150', '6', '1500', '0', '0', '0', '0', '0000-00-00'),
('151', '7', '1500', '0', '0', '0', '0', '0000-00-00'),
('152', '8', '1500', '0', '0', '0', '0', '0000-00-00'),
('153', '9', '1500', '0', '0', '0', '0', '0000-00-00'),
('154', '10', '1500', '0', '0', '0', '0', '0000-00-00'),
('155', '11', '1500', '0', '0', '0', '0', '0000-00-00'),
('156', '12', '1500', '0', '0', '0', '0', '0000-00-00'),
('157', '13', '1500', '0', '0', '0', '0', '0000-00-00'),
('158', '14', '1500', '0', '0', '0', '0', '0000-00-00'),
('159', '15', '1500', '0', '0', '0', '0', '0000-00-00'),
('160', '16', '1500', '0', '0', '0', '0', '0000-00-00'),
('161', '17', '1500', '0', '0', '0', '0', '0000-00-00'),
('162', '18', '1500', '0', '0', '0', '0', '0000-00-00'),
('163', '19', '1500', '0', '0', '0', '0', '0000-00-00'),
('164', '20', '1500', '0', '0', '0', '0', '0000-00-00'),
('165', '21', '1500', '0', '0', '0', '0', '0000-00-00'),
('166', '22', '1500', '0', '0', '0', '0', '0000-00-00'),
('167', '23', '1500', '0', '0', '0', '0', '0000-00-00'),
('168', '24', '1500', '0', '0', '0', '0', '0000-00-00'),
('169', '1', '1900', '0', '0', '0', '0', '0000-00-00'),
('170', '2', '1900', '0', '0', '0', '0', '0000-00-00'),
('171', '3', '1900', '0', '0', '0', '0', '0000-00-00'),
('172', '4', '1900', '0', '0', '0', '0', '0000-00-00'),
('173', '5', '1900', '0', '0', '0', '0', '0000-00-00'),
('174', '6', '1900', '0', '0', '0', '0', '0000-00-00'),
('175', '7', '1900', '0', '0', '0', '0', '0000-00-00'),
('176', '8', '1900', '0', '0', '0', '0', '0000-00-00'),
('177', '9', '1900', '0', '0', '0', '0', '0000-00-00'),
('178', '10', '1900', '0', '0', '0', '0', '0000-00-00'),
('179', '11', '1900', '0', '0', '0', '0', '0000-00-00'),
('180', '12', '1900', '0', '0', '0', '0', '0000-00-00'),
('181', '13', '1900', '0', '0', '0', '0', '0000-00-00'),
('182', '14', '1900', '0', '0', '0', '0', '0000-00-00'),
('183', '15', '1900', '0', '0', '0', '0', '0000-00-00'),
('184', '16', '1900', '0', '0', '0', '0', '0000-00-00'),
('185', '17', '1900', '0', '0', '0', '0', '0000-00-00'),
('186', '18', '1900', '0', '0', '0', '0', '0000-00-00'),
('187', '19', '1900', '0', '0', '0', '0', '0000-00-00'),
('188', '20', '1900', '0', '0', '0', '0', '0000-00-00'),
('189', '21', '1900', '0', '0', '0', '0', '0000-00-00'),
('190', '22', '1900', '0', '0', '0', '0', '0000-00-00'),
('191', '23', '1900', '0', '0', '0', '0', '0000-00-00'),
('192', '24', '1900', '0', '0', '0', '0', '0000-00-00'),
('193', '1', '2000', '0', '0', '0', '0', '0000-00-00'),
('194', '2', '2000', '0', '0', '0', '0', '0000-00-00'),
('195', '3', '2000', '0', '0', '0', '0', '0000-00-00'),
('196', '4', '2000', '0', '0', '0', '0', '0000-00-00'),
('197', '5', '2000', '0', '0', '0', '0', '0000-00-00'),
('198', '6', '2000', '0', '0', '0', '0', '0000-00-00'),
('199', '7', '2000', '0', '0', '0', '0', '0000-00-00'),
('200', '8', '2000', '0', '0', '0', '0', '0000-00-00'),
('201', '9', '2000', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('202', '10', '2000', '0', '0', '0', '0', '0000-00-00'),
('203', '11', '2000', '0', '0', '0', '0', '0000-00-00'),
('204', '12', '2000', '0', '0', '0', '0', '0000-00-00'),
('205', '13', '2000', '0', '0', '0', '0', '0000-00-00'),
('206', '14', '2000', '0', '0', '0', '0', '0000-00-00'),
('207', '15', '2000', '0', '0', '0', '0', '0000-00-00'),
('208', '16', '2000', '0', '0', '0', '0', '0000-00-00'),
('209', '17', '2000', '0', '0', '0', '0', '0000-00-00'),
('210', '18', '2000', '0', '0', '0', '0', '0000-00-00'),
('211', '19', '2000', '0', '0', '0', '0', '0000-00-00'),
('212', '20', '2000', '0', '0', '0', '0', '0000-00-00'),
('213', '21', '2000', '0', '0', '0', '0', '0000-00-00'),
('214', '22', '2000', '0', '0', '0', '0', '0000-00-00'),
('215', '23', '2000', '0', '0', '0', '0', '0000-00-00'),
('216', '24', '2000', '0', '0', '0', '0', '0000-00-00'),
('217', '1', '2310', '0', '0', '0', '0', '0000-00-00'),
('218', '2', '2310', '0', '0', '0', '0', '0000-00-00'),
('219', '3', '2310', '0', '0', '0', '0', '0000-00-00'),
('220', '4', '2310', '0', '0', '0', '0', '0000-00-00'),
('221', '5', '2310', '0', '0', '0', '0', '0000-00-00'),
('222', '6', '2310', '0', '0', '0', '0', '0000-00-00'),
('223', '7', '2310', '0', '0', '0', '0', '0000-00-00'),
('224', '8', '2310', '0', '0', '0', '0', '0000-00-00'),
('225', '9', '2310', '0', '0', '0', '0', '0000-00-00'),
('226', '10', '2310', '0', '0', '0', '0', '0000-00-00'),
('227', '11', '2310', '0', '0', '0', '0', '0000-00-00'),
('228', '12', '2310', '0', '0', '0', '0', '0000-00-00'),
('229', '13', '2310', '0', '0', '0', '0', '0000-00-00'),
('230', '14', '2310', '0', '0', '0', '0', '0000-00-00'),
('231', '15', '2310', '0', '0', '0', '0', '0000-00-00'),
('232', '16', '2310', '0', '0', '0', '0', '0000-00-00'),
('233', '17', '2310', '0', '0', '0', '0', '0000-00-00'),
('234', '18', '2310', '0', '0', '0', '0', '0000-00-00'),
('235', '19', '2310', '0', '0', '0', '0', '0000-00-00'),
('236', '20', '2310', '0', '0', '0', '0', '0000-00-00'),
('237', '21', '2310', '0', '0', '0', '0', '0000-00-00'),
('238', '22', '2310', '0', '0', '0', '0', '0000-00-00'),
('239', '23', '2310', '0', '0', '0', '0', '0000-00-00'),
('240', '24', '2310', '0', '0', '0', '0', '0000-00-00'),
('289', '1', '2316', '0', '0', '0', '0', '0000-00-00'),
('290', '2', '2316', '0', '0', '0', '0', '0000-00-00'),
('291', '3', '2316', '0', '0', '0', '0', '0000-00-00'),
('292', '4', '2316', '0', '0', '0', '0', '0000-00-00'),
('293', '5', '2316', '0', '0', '0', '0', '0000-00-00'),
('294', '6', '2316', '0', '0', '0', '0', '0000-00-00'),
('295', '7', '2316', '0', '0', '0', '0', '0000-00-00'),
('296', '8', '2316', '0', '0', '0', '0', '0000-00-00'),
('297', '9', '2316', '0', '0', '0', '0', '0000-00-00'),
('298', '10', '2316', '0', '0', '0', '0', '0000-00-00'),
('299', '11', '2316', '0', '0', '0', '0', '0000-00-00'),
('300', '12', '2316', '0', '0', '0', '0', '0000-00-00'),
('301', '13', '2316', '0', '0', '0', '0', '0000-00-00'),
('302', '14', '2316', '0', '0', '0', '0', '0000-00-00'),
('303', '15', '2316', '0', '0', '0', '0', '0000-00-00'),
('304', '16', '2316', '0', '0', '0', '0', '0000-00-00'),
('305', '17', '2316', '0', '0', '0', '0', '0000-00-00'),
('306', '18', '2316', '0', '0', '0', '0', '0000-00-00'),
('307', '19', '2316', '0', '0', '0', '0', '0000-00-00'),
('308', '20', '2316', '0', '0', '0', '0', '0000-00-00'),
('309', '21', '2316', '0', '0', '0', '0', '0000-00-00'),
('310', '22', '2316', '0', '0', '0', '0', '0000-00-00'),
('311', '23', '2316', '0', '0', '0', '0', '0000-00-00'),
('312', '24', '2316', '0', '0', '0', '0', '0000-00-00'),
('313', '1', '2320', '0', '0', '0', '0', '0000-00-00'),
('314', '2', '2320', '0', '0', '0', '0', '0000-00-00'),
('315', '3', '2320', '0', '0', '0', '0', '0000-00-00'),
('316', '4', '2320', '0', '0', '0', '0', '0000-00-00'),
('317', '5', '2320', '0', '0', '0', '0', '0000-00-00'),
('318', '6', '2320', '0', '0', '0', '0', '0000-00-00'),
('319', '7', '2320', '0', '0', '0', '0', '0000-00-00'),
('320', '8', '2320', '0', '0', '0', '0', '0000-00-00'),
('321', '9', '2320', '0', '0', '0', '0', '0000-00-00'),
('322', '10', '2320', '0', '0', '0', '0', '0000-00-00'),
('323', '11', '2320', '0', '0', '0', '0', '0000-00-00'),
('324', '12', '2320', '0', '0', '0', '0', '0000-00-00'),
('325', '13', '2320', '0', '0', '0', '0', '0000-00-00'),
('326', '14', '2320', '0', '0', '0', '0', '0000-00-00'),
('327', '15', '2320', '0', '0', '0', '0', '0000-00-00'),
('328', '16', '2320', '0', '0', '0', '0', '0000-00-00'),
('329', '17', '2320', '0', '0', '0', '0', '0000-00-00'),
('330', '18', '2320', '0', '0', '0', '0', '0000-00-00'),
('331', '19', '2320', '0', '0', '0', '0', '0000-00-00'),
('332', '20', '2320', '0', '0', '0', '0', '0000-00-00'),
('333', '21', '2320', '0', '0', '0', '0', '0000-00-00'),
('334', '22', '2320', '0', '0', '0', '0', '0000-00-00'),
('335', '23', '2320', '0', '0', '0', '0', '0000-00-00'),
('336', '24', '2320', '0', '0', '0', '0', '0000-00-00'),
('361', '1', '2340', '0', '0', '0', '0', '0000-00-00'),
('362', '2', '2340', '0', '0', '0', '0', '0000-00-00'),
('363', '3', '2340', '0', '0', '0', '0', '0000-00-00'),
('364', '4', '2340', '0', '0', '0', '0', '0000-00-00'),
('365', '5', '2340', '0', '0', '0', '0', '0000-00-00'),
('366', '6', '2340', '0', '0', '0', '0', '0000-00-00'),
('367', '7', '2340', '0', '0', '0', '0', '0000-00-00'),
('368', '8', '2340', '0', '0', '0', '0', '0000-00-00'),
('369', '9', '2340', '0', '0', '0', '0', '0000-00-00'),
('370', '10', '2340', '0', '0', '0', '0', '0000-00-00'),
('371', '11', '2340', '0', '0', '0', '0', '0000-00-00'),
('372', '12', '2340', '0', '0', '0', '0', '0000-00-00'),
('373', '13', '2340', '0', '0', '0', '0', '0000-00-00'),
('374', '14', '2340', '0', '0', '0', '0', '0000-00-00'),
('375', '15', '2340', '0', '0', '0', '0', '0000-00-00'),
('376', '16', '2340', '0', '0', '0', '0', '0000-00-00'),
('377', '17', '2340', '0', '0', '0', '0', '0000-00-00'),
('378', '18', '2340', '0', '0', '0', '0', '0000-00-00'),
('379', '19', '2340', '0', '0', '0', '0', '0000-00-00'),
('380', '20', '2340', '0', '0', '0', '0', '0000-00-00'),
('381', '21', '2340', '0', '0', '0', '0', '0000-00-00'),
('382', '22', '2340', '0', '0', '0', '0', '0000-00-00'),
('383', '23', '2340', '0', '0', '0', '0', '0000-00-00'),
('384', '24', '2340', '0', '0', '0', '0', '0000-00-00'),
('385', '1', '2350', '0', '0', '0', '0', '0000-00-00'),
('386', '2', '2350', '0', '0', '0', '0', '0000-00-00'),
('387', '3', '2350', '0', '0', '0', '0', '0000-00-00'),
('388', '4', '2350', '0', '0', '0', '0', '0000-00-00'),
('389', '5', '2350', '0', '0', '0', '0', '0000-00-00'),
('390', '6', '2350', '0', '0', '0', '0', '0000-00-00'),
('391', '7', '2350', '0', '0', '0', '0', '0000-00-00'),
('392', '8', '2350', '0', '0', '0', '0', '0000-00-00'),
('393', '9', '2350', '0', '0', '0', '0', '0000-00-00'),
('394', '10', '2350', '0', '0', '0', '0', '0000-00-00'),
('395', '11', '2350', '0', '0', '0', '0', '0000-00-00'),
('396', '12', '2350', '0', '0', '0', '0', '0000-00-00'),
('397', '13', '2350', '0', '0', '0', '0', '0000-00-00'),
('398', '14', '2350', '0', '0', '0', '0', '0000-00-00'),
('399', '15', '2350', '0', '0', '0', '0', '0000-00-00'),
('400', '16', '2350', '0', '0', '0', '0', '0000-00-00'),
('401', '17', '2350', '0', '0', '0', '0', '0000-00-00'),
('402', '18', '2350', '0', '0', '0', '0', '0000-00-00'),
('403', '19', '2350', '0', '0', '0', '0', '0000-00-00'),
('404', '20', '2350', '0', '0', '0', '0', '0000-00-00'),
('405', '21', '2350', '0', '0', '0', '0', '0000-00-00'),
('406', '22', '2350', '0', '0', '0', '0', '0000-00-00'),
('407', '23', '2350', '0', '0', '0', '0', '0000-00-00'),
('408', '24', '2350', '0', '0', '0', '0', '0000-00-00'),
('409', '1', '2360', '0', '0', '0', '0', '0000-00-00'),
('410', '2', '2360', '0', '0', '0', '0', '0000-00-00'),
('411', '3', '2360', '0', '0', '0', '0', '0000-00-00'),
('412', '4', '2360', '0', '0', '0', '0', '0000-00-00'),
('413', '5', '2360', '0', '0', '0', '0', '0000-00-00'),
('414', '6', '2360', '0', '0', '0', '0', '0000-00-00'),
('415', '7', '2360', '0', '0', '0', '0', '0000-00-00'),
('416', '8', '2360', '0', '0', '0', '0', '0000-00-00'),
('417', '9', '2360', '0', '0', '0', '0', '0000-00-00'),
('418', '10', '2360', '0', '0', '0', '0', '0000-00-00'),
('419', '11', '2360', '0', '0', '0', '0', '0000-00-00'),
('420', '12', '2360', '0', '0', '0', '0', '0000-00-00'),
('421', '13', '2360', '0', '0', '0', '0', '0000-00-00'),
('422', '14', '2360', '0', '0', '0', '0', '0000-00-00'),
('423', '15', '2360', '0', '0', '0', '0', '0000-00-00'),
('424', '16', '2360', '0', '0', '0', '0', '0000-00-00'),
('425', '17', '2360', '0', '0', '0', '0', '0000-00-00'),
('426', '18', '2360', '0', '0', '0', '0', '0000-00-00'),
('427', '19', '2360', '0', '0', '0', '0', '0000-00-00'),
('428', '20', '2360', '0', '0', '0', '0', '0000-00-00'),
('429', '21', '2360', '0', '0', '0', '0', '0000-00-00'),
('430', '22', '2360', '0', '0', '0', '0', '0000-00-00'),
('431', '23', '2360', '0', '0', '0', '0', '0000-00-00'),
('432', '24', '2360', '0', '0', '0', '0', '0000-00-00'),
('457', '1', '2380', '0', '0', '0', '0', '0000-00-00'),
('458', '2', '2380', '0', '0', '0', '0', '0000-00-00'),
('459', '3', '2380', '0', '0', '0', '0', '0000-00-00'),
('460', '4', '2380', '0', '0', '0', '0', '0000-00-00'),
('461', '5', '2380', '0', '0', '0', '0', '0000-00-00'),
('462', '6', '2380', '0', '0', '0', '0', '0000-00-00'),
('463', '7', '2380', '0', '0', '0', '0', '0000-00-00'),
('464', '8', '2380', '0', '0', '0', '0', '0000-00-00'),
('465', '9', '2380', '0', '0', '0', '0', '0000-00-00'),
('466', '10', '2380', '0', '0', '0', '0', '0000-00-00'),
('467', '11', '2380', '0', '0', '0', '0', '0000-00-00'),
('468', '12', '2380', '0', '0', '0', '0', '0000-00-00'),
('469', '13', '2380', '0', '0', '0', '0', '0000-00-00'),
('470', '14', '2380', '0', '0', '0', '0', '0000-00-00'),
('471', '15', '2380', '0', '0', '0', '0', '0000-00-00'),
('472', '16', '2380', '0', '0', '0', '0', '0000-00-00'),
('473', '17', '2380', '0', '0', '0', '0', '0000-00-00'),
('474', '18', '2380', '0', '0', '0', '0', '0000-00-00'),
('475', '19', '2380', '0', '0', '0', '0', '0000-00-00'),
('476', '20', '2380', '0', '0', '0', '0', '0000-00-00'),
('477', '21', '2380', '0', '0', '0', '0', '0000-00-00'),
('478', '22', '2380', '0', '0', '0', '0', '0000-00-00'),
('479', '23', '2380', '0', '0', '0', '0', '0000-00-00'),
('480', '24', '2380', '0', '0', '0', '0', '0000-00-00'),
('481', '1', '2400', '0', '0', '0', '0', '0000-00-00'),
('482', '2', '2400', '0', '0', '0', '0', '0000-00-00'),
('483', '3', '2400', '0', '0', '0', '0', '0000-00-00'),
('484', '4', '2400', '0', '0', '0', '0', '0000-00-00'),
('485', '5', '2400', '0', '0', '0', '0', '0000-00-00'),
('486', '6', '2400', '0', '0', '0', '0', '0000-00-00'),
('487', '7', '2400', '0', '0', '0', '0', '0000-00-00'),
('488', '8', '2400', '0', '0', '0', '0', '0000-00-00'),
('489', '9', '2400', '0', '0', '0', '0', '0000-00-00'),
('490', '10', '2400', '0', '0', '0', '0', '0000-00-00'),
('491', '11', '2400', '0', '0', '0', '0', '0000-00-00'),
('492', '12', '2400', '0', '0', '0', '0', '0000-00-00'),
('493', '13', '2400', '0', '0', '0', '0', '0000-00-00'),
('494', '14', '2400', '0', '0', '0', '0', '0000-00-00'),
('495', '15', '2400', '0', '0', '0', '0', '0000-00-00'),
('496', '16', '2400', '0', '0', '0', '0', '0000-00-00'),
('497', '17', '2400', '0', '0', '0', '0', '0000-00-00'),
('498', '18', '2400', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('499', '19', '2400', '0', '0', '0', '0', '0000-00-00'),
('500', '20', '2400', '0', '0', '0', '0', '0000-00-00'),
('501', '21', '2400', '0', '0', '0', '0', '0000-00-00'),
('502', '22', '2400', '0', '0', '0', '0', '0000-00-00'),
('503', '23', '2400', '0', '0', '0', '0', '0000-00-00'),
('504', '24', '2400', '0', '0', '0', '0', '0000-00-00'),
('505', '1', '2500', '0', '0', '0', '0', '0000-00-00'),
('506', '2', '2500', '0', '0', '0', '0', '0000-00-00'),
('507', '3', '2500', '0', '0', '0', '0', '0000-00-00'),
('508', '4', '2500', '0', '0', '0', '0', '0000-00-00'),
('509', '5', '2500', '0', '0', '0', '0', '0000-00-00'),
('510', '6', '2500', '0', '0', '0', '0', '0000-00-00'),
('511', '7', '2500', '0', '0', '0', '0', '0000-00-00'),
('512', '8', '2500', '0', '0', '0', '0', '0000-00-00'),
('513', '9', '2500', '0', '0', '0', '0', '0000-00-00'),
('514', '10', '2500', '0', '0', '0', '0', '0000-00-00'),
('515', '11', '2500', '0', '0', '0', '0', '0000-00-00'),
('516', '12', '2500', '0', '0', '0', '0', '0000-00-00'),
('517', '13', '2500', '0', '0', '0', '0', '0000-00-00'),
('518', '14', '2500', '0', '0', '0', '0', '0000-00-00'),
('519', '15', '2500', '0', '0', '0', '0', '0000-00-00'),
('520', '16', '2500', '0', '0', '0', '0', '0000-00-00'),
('521', '17', '2500', '0', '0', '0', '0', '0000-00-00'),
('522', '18', '2500', '0', '0', '0', '0', '0000-00-00'),
('523', '19', '2500', '0', '0', '0', '0', '0000-00-00'),
('524', '20', '2500', '0', '0', '0', '0', '0000-00-00'),
('525', '21', '2500', '0', '0', '0', '0', '0000-00-00'),
('526', '22', '2500', '0', '0', '0', '0', '0000-00-00'),
('527', '23', '2500', '0', '0', '0', '0', '0000-00-00'),
('528', '24', '2500', '0', '0', '0', '0', '0000-00-00'),
('529', '1', '2700', '0', '0', '0', '0', '0000-00-00'),
('530', '2', '2700', '0', '0', '0', '0', '0000-00-00'),
('531', '3', '2700', '0', '0', '0', '0', '0000-00-00'),
('532', '4', '2700', '0', '0', '0', '0', '0000-00-00'),
('533', '5', '2700', '0', '0', '0', '0', '0000-00-00'),
('534', '6', '2700', '0', '0', '0', '0', '0000-00-00'),
('535', '7', '2700', '0', '0', '0', '0', '0000-00-00'),
('536', '8', '2700', '0', '0', '0', '0', '0000-00-00'),
('537', '9', '2700', '0', '0', '0', '0', '0000-00-00'),
('538', '10', '2700', '0', '0', '0', '0', '0000-00-00'),
('539', '11', '2700', '0', '0', '0', '0', '0000-00-00'),
('540', '12', '2700', '0', '0', '0', '0', '0000-00-00'),
('541', '13', '2700', '0', '0', '0', '0', '0000-00-00'),
('542', '14', '2700', '0', '0', '0', '0', '0000-00-00'),
('543', '15', '2700', '0', '0', '0', '0', '0000-00-00'),
('544', '16', '2700', '0', '0', '0', '0', '0000-00-00'),
('545', '17', '2700', '0', '0', '0', '0', '0000-00-00'),
('546', '18', '2700', '0', '0', '0', '0', '0000-00-00'),
('547', '19', '2700', '0', '0', '0', '0', '0000-00-00'),
('548', '20', '2700', '0', '0', '0', '0', '0000-00-00'),
('549', '21', '2700', '0', '0', '0', '0', '0000-00-00'),
('550', '22', '2700', '0', '0', '0', '0', '0000-00-00'),
('551', '23', '2700', '0', '0', '0', '0', '0000-00-00'),
('552', '24', '2700', '0', '0', '0', '0', '0000-00-00'),
('553', '1', '3100', '0', '0', '0', '0', '0000-00-00'),
('554', '2', '3100', '0', '0', '0', '0', '0000-00-00'),
('555', '3', '3100', '0', '0', '0', '0', '0000-00-00'),
('556', '4', '3100', '0', '0', '0', '0', '0000-00-00'),
('557', '5', '3100', '0', '0', '0', '0', '0000-00-00'),
('558', '6', '3100', '0', '0', '0', '0', '0000-00-00'),
('559', '7', '3100', '0', '0', '0', '0', '0000-00-00'),
('560', '8', '3100', '0', '0', '0', '0', '0000-00-00'),
('561', '9', '3100', '0', '0', '0', '0', '0000-00-00'),
('562', '10', '3100', '0', '0', '0', '0', '0000-00-00'),
('563', '11', '3100', '0', '0', '0', '0', '0000-00-00'),
('564', '12', '3100', '0', '0', '0', '0', '0000-00-00'),
('565', '13', '3100', '0', '0', '0', '0', '0000-00-00'),
('566', '14', '3100', '0', '0', '0', '0', '0000-00-00'),
('567', '15', '3100', '0', '0', '0', '0', '0000-00-00'),
('568', '16', '3100', '0', '0', '0', '0', '0000-00-00'),
('569', '17', '3100', '0', '0', '0', '0', '0000-00-00'),
('570', '18', '3100', '0', '0', '0', '0', '0000-00-00'),
('571', '19', '3100', '0', '0', '0', '0', '0000-00-00'),
('572', '20', '3100', '0', '0', '0', '0', '0000-00-00'),
('573', '21', '3100', '0', '0', '0', '0', '0000-00-00'),
('574', '22', '3100', '0', '0', '0', '0', '0000-00-00'),
('575', '23', '3100', '0', '0', '0', '0', '0000-00-00'),
('576', '24', '3100', '0', '0', '0', '0', '0000-00-00'),
('577', '1', '3200', '0', '0', '0', '0', '0000-00-00'),
('578', '2', '3200', '0', '0', '0', '0', '0000-00-00'),
('579', '3', '3200', '0', '0', '0', '0', '0000-00-00'),
('580', '4', '3200', '0', '0', '0', '0', '0000-00-00'),
('581', '5', '3200', '0', '0', '0', '0', '0000-00-00'),
('582', '6', '3200', '0', '0', '0', '0', '0000-00-00'),
('583', '7', '3200', '0', '0', '0', '0', '0000-00-00'),
('584', '8', '3200', '0', '0', '0', '0', '0000-00-00'),
('585', '9', '3200', '0', '0', '0', '0', '0000-00-00'),
('586', '10', '3200', '0', '0', '0', '0', '0000-00-00'),
('587', '11', '3200', '0', '0', '0', '0', '0000-00-00'),
('588', '12', '3200', '0', '0', '0', '0', '0000-00-00'),
('589', '13', '3200', '0', '0', '0', '0', '0000-00-00'),
('590', '14', '3200', '0', '0', '0', '0', '0000-00-00'),
('591', '15', '3200', '0', '0', '0', '0', '0000-00-00'),
('592', '16', '3200', '0', '0', '0', '0', '0000-00-00'),
('593', '17', '3200', '0', '0', '0', '0', '0000-00-00'),
('594', '18', '3200', '0', '0', '0', '0', '0000-00-00'),
('595', '19', '3200', '0', '0', '0', '0', '0000-00-00'),
('596', '20', '3200', '0', '0', '0', '0', '0000-00-00'),
('597', '21', '3200', '0', '0', '0', '0', '0000-00-00'),
('598', '22', '3200', '0', '0', '0', '0', '0000-00-00'),
('599', '23', '3200', '0', '0', '0', '0', '0000-00-00'),
('600', '24', '3200', '0', '0', '0', '0', '0000-00-00'),
('601', '1', '3800', '0', '0', '0', '0', '0000-00-00'),
('602', '2', '3800', '0', '0', '0', '0', '0000-00-00'),
('603', '3', '3800', '0', '0', '0', '0', '0000-00-00'),
('604', '4', '3800', '0', '0', '0', '0', '0000-00-00'),
('605', '5', '3800', '0', '0', '0', '0', '0000-00-00'),
('606', '6', '3800', '0', '0', '0', '0', '0000-00-00'),
('607', '7', '3800', '0', '0', '0', '0', '0000-00-00'),
('608', '8', '3800', '0', '0', '0', '0', '0000-00-00'),
('609', '9', '3800', '0', '0', '0', '0', '0000-00-00'),
('610', '10', '3800', '0', '0', '0', '0', '0000-00-00'),
('611', '11', '3800', '0', '0', '0', '0', '0000-00-00'),
('612', '12', '3800', '0', '0', '0', '0', '0000-00-00'),
('613', '13', '3800', '0', '0', '0', '0', '0000-00-00'),
('614', '14', '3800', '0', '0', '0', '0', '0000-00-00'),
('615', '15', '3800', '0', '0', '0', '0', '0000-00-00'),
('616', '16', '3800', '0', '0', '0', '0', '0000-00-00'),
('617', '17', '3800', '0', '0', '0', '0', '0000-00-00'),
('618', '18', '3800', '0', '0', '0', '0', '0000-00-00'),
('619', '19', '3800', '0', '0', '0', '0', '0000-00-00'),
('620', '20', '3800', '0', '0', '0', '0', '0000-00-00'),
('621', '21', '3800', '0', '0', '0', '0', '0000-00-00'),
('622', '22', '3800', '0', '0', '0', '0', '0000-00-00'),
('623', '23', '3800', '0', '0', '0', '0', '0000-00-00'),
('624', '24', '3800', '0', '0', '0', '0', '0000-00-00'),
('625', '1', '4000', '0', '0', '0', '0', '0000-00-00'),
('626', '2', '4000', '0', '0', '0', '0', '0000-00-00'),
('627', '3', '4000', '0', '0', '0', '0', '0000-00-00'),
('628', '4', '4000', '0', '0', '0', '0', '0000-00-00'),
('629', '5', '4000', '0', '0', '0', '0', '0000-00-00'),
('630', '6', '4000', '0', '0', '0', '0', '0000-00-00'),
('631', '7', '4000', '0', '0', '0', '0', '0000-00-00'),
('632', '8', '4000', '0', '0', '0', '0', '0000-00-00'),
('633', '9', '4000', '0', '0', '0', '0', '0000-00-00'),
('634', '10', '4000', '0', '0', '0', '0', '0000-00-00'),
('635', '11', '4000', '0', '0', '0', '0', '0000-00-00'),
('636', '12', '4000', '0', '0', '0', '0', '0000-00-00'),
('637', '13', '4000', '0', '0', '0', '0', '0000-00-00'),
('638', '14', '4000', '0', '0', '0', '0', '0000-00-00'),
('639', '15', '4000', '0', '0', '0', '0', '0000-00-00'),
('640', '16', '4000', '0', '0', '0', '0', '0000-00-00'),
('641', '17', '4000', '0', '0', '0', '0', '0000-00-00'),
('642', '18', '4000', '0', '0', '0', '0', '0000-00-00'),
('643', '19', '4000', '0', '0', '0', '0', '0000-00-00'),
('644', '20', '4000', '0', '0', '0', '0', '0000-00-00'),
('645', '21', '4000', '0', '0', '0', '0', '0000-00-00'),
('646', '22', '4000', '0', '0', '0', '0', '0000-00-00'),
('647', '23', '4000', '0', '0', '0', '0', '0000-00-00'),
('648', '24', '4000', '0', '0', '0', '0', '0000-00-00'),
('649', '1', '4100', '0', '0', '0', '0', '0000-00-00'),
('650', '2', '4100', '0', '0', '0', '0', '0000-00-00'),
('651', '3', '4100', '0', '0', '0', '0', '0000-00-00'),
('652', '4', '4100', '0', '0', '0', '0', '0000-00-00'),
('653', '5', '4100', '0', '0', '0', '0', '0000-00-00'),
('654', '6', '4100', '0', '0', '0', '0', '0000-00-00'),
('655', '7', '4100', '0', '0', '0', '0', '0000-00-00'),
('656', '8', '4100', '0', '0', '0', '0', '0000-00-00'),
('657', '9', '4100', '0', '0', '0', '0', '0000-00-00'),
('658', '10', '4100', '0', '0', '0', '0', '0000-00-00'),
('659', '11', '4100', '0', '0', '0', '0', '0000-00-00'),
('660', '12', '4100', '0', '0', '0', '0', '0000-00-00'),
('661', '13', '4100', '0', '0', '0', '0', '0000-00-00'),
('662', '14', '4100', '0', '0', '0', '0', '0000-00-00'),
('663', '15', '4100', '0', '0', '0', '0', '0000-00-00'),
('664', '16', '4100', '0', '0', '0', '0', '0000-00-00'),
('665', '17', '4100', '0', '0', '0', '0', '0000-00-00'),
('666', '18', '4100', '0', '0', '0', '0', '0000-00-00'),
('667', '19', '4100', '0', '0', '0', '0', '0000-00-00'),
('668', '20', '4100', '0', '0', '0', '0', '0000-00-00'),
('669', '21', '4100', '0', '0', '0', '0', '0000-00-00'),
('670', '22', '4100', '0', '0', '0', '0', '0000-00-00'),
('671', '23', '4100', '0', '0', '0', '0', '0000-00-00'),
('672', '24', '4100', '0', '0', '0', '0', '0000-00-00'),
('673', '1', '4200', '0', '0', '0', '0', '0000-00-00'),
('674', '2', '4200', '0', '0', '0', '0', '0000-00-00'),
('675', '3', '4200', '0', '0', '0', '0', '0000-00-00'),
('676', '4', '4200', '0', '0', '0', '0', '0000-00-00'),
('677', '5', '4200', '0', '0', '0', '0', '0000-00-00'),
('678', '6', '4200', '0', '0', '0', '0', '0000-00-00'),
('679', '7', '4200', '0', '0', '0', '0', '0000-00-00'),
('680', '8', '4200', '0', '0', '0', '0', '0000-00-00'),
('681', '9', '4200', '0', '0', '0', '0', '0000-00-00'),
('682', '10', '4200', '0', '0', '0', '0', '0000-00-00'),
('683', '11', '4200', '0', '0', '0', '0', '0000-00-00'),
('684', '12', '4200', '0', '0', '0', '0', '0000-00-00'),
('685', '13', '4200', '0', '0', '0', '0', '0000-00-00'),
('686', '14', '4200', '0', '0', '0', '0', '0000-00-00'),
('687', '15', '4200', '0', '0', '0', '0', '0000-00-00'),
('688', '16', '4200', '0', '0', '0', '0', '0000-00-00'),
('689', '17', '4200', '0', '0', '0', '0', '0000-00-00'),
('690', '18', '4200', '0', '0', '0', '0', '0000-00-00'),
('691', '19', '4200', '0', '0', '0', '0', '0000-00-00'),
('692', '20', '4200', '0', '0', '0', '0', '0000-00-00'),
('693', '21', '4200', '0', '0', '0', '0', '0000-00-00'),
('694', '22', '4200', '0', '0', '0', '0', '0000-00-00'),
('695', '23', '4200', '0', '0', '0', '0', '0000-00-00'),
('696', '24', '4200', '0', '0', '0', '0', '0000-00-00'),
('697', '1', '4300', '0', '0', '0', '0', '0000-00-00'),
('698', '2', '4300', '0', '0', '0', '0', '0000-00-00'),
('699', '3', '4300', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('700', '4', '4300', '0', '0', '0', '0', '0000-00-00'),
('701', '5', '4300', '0', '0', '0', '0', '0000-00-00'),
('702', '6', '4300', '0', '0', '0', '0', '0000-00-00'),
('703', '7', '4300', '0', '0', '0', '0', '0000-00-00'),
('704', '8', '4300', '0', '0', '0', '0', '0000-00-00'),
('705', '9', '4300', '0', '0', '0', '0', '0000-00-00'),
('706', '10', '4300', '0', '0', '0', '0', '0000-00-00'),
('707', '11', '4300', '0', '0', '0', '0', '0000-00-00'),
('708', '12', '4300', '0', '0', '0', '0', '0000-00-00'),
('709', '13', '4300', '0', '0', '0', '0', '0000-00-00'),
('710', '14', '4300', '0', '0', '0', '0', '0000-00-00'),
('711', '15', '4300', '0', '0', '0', '0', '0000-00-00'),
('712', '16', '4300', '0', '0', '0', '0', '0000-00-00'),
('713', '17', '4300', '0', '0', '0', '0', '0000-00-00'),
('714', '18', '4300', '0', '0', '0', '0', '0000-00-00'),
('715', '19', '4300', '0', '0', '0', '0', '0000-00-00'),
('716', '20', '4300', '0', '0', '0', '0', '0000-00-00'),
('717', '21', '4300', '0', '0', '0', '0', '0000-00-00'),
('718', '22', '4300', '0', '0', '0', '0', '0000-00-00'),
('719', '23', '4300', '0', '0', '0', '0', '0000-00-00'),
('720', '24', '4300', '0', '0', '0', '0', '0000-00-00'),
('721', '1', '4900', '0', '0', '0', '0', '0000-00-00'),
('722', '2', '4900', '0', '0', '0', '0', '0000-00-00'),
('723', '3', '4900', '0', '0', '0', '0', '0000-00-00'),
('724', '4', '4900', '0', '0', '0', '0', '0000-00-00'),
('725', '5', '4900', '0', '0', '0', '0', '0000-00-00'),
('726', '6', '4900', '0', '0', '0', '0', '0000-00-00'),
('727', '7', '4900', '0', '0', '0', '0', '0000-00-00'),
('728', '8', '4900', '0', '0', '0', '0', '0000-00-00'),
('729', '9', '4900', '0', '0', '0', '0', '0000-00-00'),
('730', '10', '4900', '0', '0', '0', '0', '0000-00-00'),
('731', '11', '4900', '0', '0', '0', '0', '0000-00-00'),
('732', '12', '4900', '0', '0', '0', '0', '0000-00-00'),
('733', '13', '4900', '0', '0', '0', '0', '0000-00-00'),
('734', '14', '4900', '0', '0', '0', '0', '0000-00-00'),
('735', '15', '4900', '0', '0', '0', '0', '0000-00-00'),
('736', '16', '4900', '0', '0', '0', '0', '0000-00-00'),
('737', '17', '4900', '0', '0', '0', '0', '0000-00-00'),
('738', '18', '4900', '0', '0', '0', '0', '0000-00-00'),
('739', '19', '4900', '0', '0', '0', '0', '0000-00-00'),
('740', '20', '4900', '0', '0', '0', '0', '0000-00-00'),
('741', '21', '4900', '0', '0', '0', '0', '0000-00-00'),
('742', '22', '4900', '0', '0', '0', '0', '0000-00-00'),
('743', '23', '4900', '0', '0', '0', '0', '0000-00-00'),
('744', '24', '4900', '0', '0', '0', '0', '0000-00-00'),
('745', '1', '5000', '0', '0', '0', '0', '0000-00-00'),
('746', '2', '5000', '0', '0', '0', '0', '0000-00-00'),
('747', '3', '5000', '0', '0', '0', '0', '0000-00-00'),
('748', '4', '5000', '0', '0', '0', '0', '0000-00-00'),
('749', '5', '5000', '0', '0', '0', '0', '0000-00-00'),
('750', '6', '5000', '0', '0', '0', '0', '0000-00-00'),
('751', '7', '5000', '0', '0', '0', '0', '0000-00-00'),
('752', '8', '5000', '0', '0', '0', '0', '0000-00-00'),
('753', '9', '5000', '0', '0', '0', '0', '0000-00-00'),
('754', '10', '5000', '0', '0', '0', '0', '0000-00-00'),
('755', '11', '5000', '0', '0', '0', '0', '0000-00-00'),
('756', '12', '5000', '0', '0', '0', '0', '0000-00-00'),
('757', '13', '5000', '0', '0', '0', '0', '0000-00-00'),
('758', '14', '5000', '0', '0', '0', '0', '0000-00-00'),
('759', '15', '5000', '0', '0', '0', '0', '0000-00-00'),
('760', '16', '5000', '0', '0', '0', '0', '0000-00-00'),
('761', '17', '5000', '0', '0', '0', '0', '0000-00-00'),
('762', '18', '5000', '0', '0', '0', '0', '0000-00-00'),
('763', '19', '5000', '0', '0', '0', '0', '0000-00-00'),
('764', '20', '5000', '0', '0', '0', '0', '0000-00-00'),
('765', '21', '5000', '0', '0', '0', '0', '0000-00-00'),
('766', '22', '5000', '0', '0', '0', '0', '0000-00-00'),
('767', '23', '5000', '0', '0', '0', '0', '0000-00-00'),
('768', '24', '5000', '0', '0', '0', '0', '0000-00-00'),
('769', '1', '5100', '0', '0', '0', '0', '0000-00-00'),
('770', '2', '5100', '0', '0', '0', '0', '0000-00-00'),
('771', '3', '5100', '0', '0', '0', '0', '0000-00-00'),
('772', '4', '5100', '0', '0', '0', '0', '0000-00-00'),
('773', '5', '5100', '0', '0', '0', '0', '0000-00-00'),
('774', '6', '5100', '0', '0', '0', '0', '0000-00-00'),
('775', '7', '5100', '0', '0', '0', '0', '0000-00-00'),
('776', '8', '5100', '0', '0', '0', '0', '0000-00-00'),
('777', '9', '5100', '0', '0', '0', '0', '0000-00-00'),
('778', '10', '5100', '0', '0', '0', '0', '0000-00-00'),
('779', '11', '5100', '0', '0', '0', '0', '0000-00-00'),
('780', '12', '5100', '0', '0', '0', '0', '0000-00-00'),
('781', '13', '5100', '0', '0', '0', '0', '0000-00-00'),
('782', '14', '5100', '0', '0', '0', '0', '0000-00-00'),
('783', '15', '5100', '0', '0', '0', '0', '0000-00-00'),
('784', '16', '5100', '0', '0', '0', '0', '0000-00-00'),
('785', '17', '5100', '0', '0', '0', '0', '0000-00-00'),
('786', '18', '5100', '0', '0', '0', '0', '0000-00-00'),
('787', '19', '5100', '0', '0', '0', '0', '0000-00-00'),
('788', '20', '5100', '0', '0', '0', '0', '0000-00-00'),
('789', '21', '5100', '0', '0', '0', '0', '0000-00-00'),
('790', '22', '5100', '0', '0', '0', '0', '0000-00-00'),
('791', '23', '5100', '0', '0', '0', '0', '0000-00-00'),
('792', '24', '5100', '0', '0', '0', '0', '0000-00-00'),
('793', '1', '5400', '0', '0', '0', '0', '0000-00-00'),
('794', '2', '5400', '0', '0', '0', '0', '0000-00-00'),
('795', '3', '5400', '0', '0', '0', '0', '0000-00-00'),
('796', '4', '5400', '0', '0', '0', '0', '0000-00-00'),
('797', '5', '5400', '0', '0', '0', '0', '0000-00-00'),
('798', '6', '5400', '0', '0', '0', '0', '0000-00-00'),
('799', '7', '5400', '0', '0', '0', '0', '0000-00-00'),
('800', '8', '5400', '0', '0', '0', '0', '0000-00-00'),
('801', '9', '5400', '0', '0', '0', '0', '0000-00-00'),
('802', '10', '5400', '0', '0', '0', '0', '0000-00-00'),
('803', '11', '5400', '0', '0', '0', '0', '0000-00-00'),
('804', '12', '5400', '0', '0', '0', '0', '0000-00-00'),
('805', '13', '5400', '0', '0', '0', '0', '0000-00-00'),
('806', '14', '5400', '0', '0', '0', '0', '0000-00-00'),
('807', '15', '5400', '0', '0', '0', '0', '0000-00-00'),
('808', '16', '5400', '0', '0', '0', '0', '0000-00-00'),
('809', '17', '5400', '0', '0', '0', '0', '0000-00-00'),
('810', '18', '5400', '0', '0', '0', '0', '0000-00-00'),
('811', '19', '5400', '0', '0', '0', '0', '0000-00-00'),
('812', '20', '5400', '0', '0', '0', '0', '0000-00-00'),
('813', '21', '5400', '0', '0', '0', '0', '0000-00-00'),
('814', '22', '5400', '0', '0', '0', '0', '0000-00-00'),
('815', '23', '5400', '0', '0', '0', '0', '0000-00-00'),
('816', '24', '5400', '0', '0', '0', '0', '0000-00-00'),
('817', '1', '5900', '0', '0', '0', '0', '0000-00-00'),
('818', '2', '5900', '0', '0', '0', '0', '0000-00-00'),
('819', '3', '5900', '0', '0', '0', '0', '0000-00-00'),
('820', '4', '5900', '0', '0', '0', '0', '0000-00-00'),
('821', '5', '5900', '0', '0', '0', '0', '0000-00-00'),
('822', '6', '5900', '0', '0', '0', '0', '0000-00-00'),
('823', '7', '5900', '0', '0', '0', '0', '0000-00-00'),
('824', '8', '5900', '0', '0', '0', '0', '0000-00-00'),
('825', '9', '5900', '0', '0', '0', '0', '0000-00-00'),
('826', '10', '5900', '0', '0', '0', '0', '0000-00-00'),
('827', '11', '5900', '0', '0', '0', '0', '0000-00-00'),
('828', '12', '5900', '0', '0', '0', '0', '0000-00-00'),
('829', '13', '5900', '0', '0', '0', '0', '0000-00-00'),
('830', '14', '5900', '0', '0', '0', '0', '0000-00-00'),
('831', '15', '5900', '0', '0', '0', '0', '0000-00-00'),
('832', '16', '5900', '0', '0', '0', '0', '0000-00-00'),
('833', '17', '5900', '0', '0', '0', '0', '0000-00-00'),
('834', '18', '5900', '0', '0', '0', '0', '0000-00-00'),
('835', '19', '5900', '0', '0', '0', '0', '0000-00-00'),
('836', '20', '5900', '0', '0', '0', '0', '0000-00-00'),
('837', '21', '5900', '0', '0', '0', '0', '0000-00-00'),
('838', '22', '5900', '0', '0', '0', '0', '0000-00-00'),
('839', '23', '5900', '0', '0', '0', '0', '0000-00-00'),
('840', '24', '5900', '0', '0', '0', '0', '0000-00-00'),
('841', '1', '6000', '0', '0', '0', '0', '0000-00-00'),
('842', '2', '6000', '0', '0', '0', '0', '0000-00-00'),
('843', '3', '6000', '0', '0', '0', '0', '0000-00-00'),
('844', '4', '6000', '0', '0', '0', '0', '0000-00-00'),
('845', '5', '6000', '0', '0', '0', '0', '0000-00-00'),
('846', '6', '6000', '0', '0', '0', '0', '0000-00-00'),
('847', '7', '6000', '0', '0', '0', '0', '0000-00-00'),
('848', '8', '6000', '0', '0', '0', '0', '0000-00-00'),
('849', '9', '6000', '0', '0', '0', '0', '0000-00-00'),
('850', '10', '6000', '0', '0', '0', '0', '0000-00-00'),
('851', '11', '6000', '0', '0', '0', '0', '0000-00-00'),
('852', '12', '6000', '0', '0', '0', '0', '0000-00-00'),
('853', '13', '6000', '0', '0', '0', '0', '0000-00-00'),
('854', '14', '6000', '0', '0', '0', '0', '0000-00-00'),
('855', '15', '6000', '0', '0', '0', '0', '0000-00-00'),
('856', '16', '6000', '0', '0', '0', '0', '0000-00-00'),
('857', '17', '6000', '0', '0', '0', '0', '0000-00-00'),
('858', '18', '6000', '0', '0', '0', '0', '0000-00-00'),
('859', '19', '6000', '0', '0', '0', '0', '0000-00-00'),
('860', '20', '6000', '0', '0', '0', '0', '0000-00-00'),
('861', '21', '6000', '0', '0', '0', '0', '0000-00-00'),
('862', '22', '6000', '0', '0', '0', '0', '0000-00-00'),
('863', '23', '6000', '0', '0', '0', '0', '0000-00-00'),
('864', '24', '6000', '0', '0', '0', '0', '0000-00-00'),
('865', '1', '6050', '0', '0', '0', '0', '0000-00-00'),
('866', '2', '6050', '0', '0', '0', '0', '0000-00-00'),
('867', '3', '6050', '0', '0', '0', '0', '0000-00-00'),
('868', '4', '6050', '0', '0', '0', '0', '0000-00-00'),
('869', '5', '6050', '0', '0', '0', '0', '0000-00-00'),
('870', '6', '6050', '0', '0', '0', '0', '0000-00-00'),
('871', '7', '6050', '0', '0', '0', '0', '0000-00-00'),
('872', '8', '6050', '0', '0', '0', '0', '0000-00-00'),
('873', '9', '6050', '0', '0', '0', '0', '0000-00-00'),
('874', '10', '6050', '0', '0', '0', '0', '0000-00-00'),
('875', '11', '6050', '0', '0', '0', '0', '0000-00-00'),
('876', '12', '6050', '0', '0', '0', '0', '0000-00-00'),
('877', '13', '6050', '0', '0', '0', '0', '0000-00-00'),
('878', '14', '6050', '0', '0', '0', '0', '0000-00-00'),
('879', '15', '6050', '0', '0', '0', '0', '0000-00-00'),
('880', '16', '6050', '0', '0', '0', '0', '0000-00-00'),
('881', '17', '6050', '0', '0', '0', '0', '0000-00-00'),
('882', '18', '6050', '0', '0', '0', '0', '0000-00-00'),
('883', '19', '6050', '0', '0', '0', '0', '0000-00-00'),
('884', '20', '6050', '0', '0', '0', '0', '0000-00-00'),
('885', '21', '6050', '0', '0', '0', '0', '0000-00-00'),
('886', '22', '6050', '0', '0', '0', '0', '0000-00-00'),
('887', '23', '6050', '0', '0', '0', '0', '0000-00-00'),
('888', '24', '6050', '0', '0', '0', '0', '0000-00-00'),
('889', '1', '6100', '0', '0', '0', '0', '0000-00-00'),
('890', '2', '6100', '0', '0', '0', '0', '0000-00-00'),
('891', '3', '6100', '0', '0', '0', '0', '0000-00-00'),
('892', '4', '6100', '0', '0', '0', '0', '0000-00-00'),
('893', '5', '6100', '0', '0', '0', '0', '0000-00-00'),
('894', '6', '6100', '0', '0', '0', '0', '0000-00-00'),
('895', '7', '6100', '0', '0', '0', '0', '0000-00-00'),
('896', '8', '6100', '0', '0', '0', '0', '0000-00-00'),
('897', '9', '6100', '0', '0', '0', '0', '0000-00-00'),
('898', '10', '6100', '0', '0', '0', '0', '0000-00-00'),
('899', '11', '6100', '0', '0', '0', '0', '0000-00-00'),
('900', '12', '6100', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('901', '13', '6100', '0', '0', '0', '0', '0000-00-00'),
('902', '14', '6100', '0', '0', '0', '0', '0000-00-00'),
('903', '15', '6100', '0', '0', '0', '0', '0000-00-00'),
('904', '16', '6100', '0', '0', '0', '0', '0000-00-00'),
('905', '17', '6100', '0', '0', '0', '0', '0000-00-00'),
('906', '18', '6100', '0', '0', '0', '0', '0000-00-00'),
('907', '19', '6100', '0', '0', '0', '0', '0000-00-00'),
('908', '20', '6100', '0', '0', '0', '0', '0000-00-00'),
('909', '21', '6100', '0', '0', '0', '0', '0000-00-00'),
('910', '22', '6100', '0', '0', '0', '0', '0000-00-00'),
('911', '23', '6100', '0', '0', '0', '0', '0000-00-00'),
('912', '24', '6100', '0', '0', '0', '0', '0000-00-00'),
('913', '1', '6150', '0', '0', '0', '0', '0000-00-00'),
('914', '2', '6150', '0', '0', '0', '0', '0000-00-00'),
('915', '3', '6150', '0', '0', '0', '0', '0000-00-00'),
('916', '4', '6150', '0', '0', '0', '0', '0000-00-00'),
('917', '5', '6150', '0', '0', '0', '0', '0000-00-00'),
('918', '6', '6150', '0', '0', '0', '0', '0000-00-00'),
('919', '7', '6150', '0', '0', '0', '0', '0000-00-00'),
('920', '8', '6150', '0', '0', '0', '0', '0000-00-00'),
('921', '9', '6150', '0', '0', '0', '0', '0000-00-00'),
('922', '10', '6150', '0', '0', '0', '0', '0000-00-00'),
('923', '11', '6150', '0', '0', '0', '0', '0000-00-00'),
('924', '12', '6150', '0', '0', '0', '0', '0000-00-00'),
('925', '13', '6150', '0', '0', '0', '0', '0000-00-00'),
('926', '14', '6150', '0', '0', '0', '0', '0000-00-00'),
('927', '15', '6150', '0', '0', '0', '0', '0000-00-00'),
('928', '16', '6150', '0', '0', '0', '0', '0000-00-00'),
('929', '17', '6150', '0', '0', '0', '0', '0000-00-00'),
('930', '18', '6150', '0', '0', '0', '0', '0000-00-00'),
('931', '19', '6150', '0', '0', '0', '0', '0000-00-00'),
('932', '20', '6150', '0', '0', '0', '0', '0000-00-00'),
('933', '21', '6150', '0', '0', '0', '0', '0000-00-00'),
('934', '22', '6150', '0', '0', '0', '0', '0000-00-00'),
('935', '23', '6150', '0', '0', '0', '0', '0000-00-00'),
('936', '24', '6150', '0', '0', '0', '0', '0000-00-00'),
('937', '1', '6200', '0', '0', '0', '0', '0000-00-00'),
('938', '2', '6200', '0', '0', '0', '0', '0000-00-00'),
('939', '3', '6200', '0', '0', '0', '0', '0000-00-00'),
('940', '4', '6200', '0', '0', '0', '0', '0000-00-00'),
('941', '5', '6200', '0', '0', '0', '0', '0000-00-00'),
('942', '6', '6200', '0', '0', '0', '0', '0000-00-00'),
('943', '7', '6200', '0', '0', '0', '0', '0000-00-00'),
('944', '8', '6200', '0', '0', '0', '0', '0000-00-00'),
('945', '9', '6200', '0', '0', '0', '0', '0000-00-00'),
('946', '10', '6200', '0', '0', '0', '0', '0000-00-00'),
('947', '11', '6200', '0', '0', '0', '0', '0000-00-00'),
('948', '12', '6200', '0', '0', '0', '0', '0000-00-00'),
('949', '13', '6200', '0', '0', '0', '0', '0000-00-00'),
('950', '14', '6200', '0', '0', '0', '0', '0000-00-00'),
('951', '15', '6200', '0', '0', '0', '0', '0000-00-00'),
('952', '16', '6200', '0', '0', '0', '0', '0000-00-00'),
('953', '17', '6200', '0', '0', '0', '0', '0000-00-00'),
('954', '18', '6200', '0', '0', '0', '0', '0000-00-00'),
('955', '19', '6200', '0', '0', '0', '0', '0000-00-00'),
('956', '20', '6200', '0', '0', '0', '0', '0000-00-00'),
('957', '21', '6200', '0', '0', '0', '0', '0000-00-00'),
('958', '22', '6200', '0', '0', '0', '0', '0000-00-00'),
('959', '23', '6200', '0', '0', '0', '0', '0000-00-00'),
('960', '24', '6200', '0', '0', '0', '0', '0000-00-00'),
('961', '1', '6250', '0', '0', '0', '0', '0000-00-00'),
('962', '2', '6250', '0', '0', '0', '0', '0000-00-00'),
('963', '3', '6250', '0', '0', '0', '0', '0000-00-00'),
('964', '4', '6250', '0', '0', '0', '0', '0000-00-00'),
('965', '5', '6250', '0', '0', '0', '0', '0000-00-00'),
('966', '6', '6250', '0', '0', '0', '0', '0000-00-00'),
('967', '7', '6250', '0', '0', '0', '0', '0000-00-00'),
('968', '8', '6250', '0', '0', '0', '0', '0000-00-00'),
('969', '9', '6250', '0', '0', '0', '0', '0000-00-00'),
('970', '10', '6250', '0', '0', '0', '0', '0000-00-00'),
('971', '11', '6250', '0', '0', '0', '0', '0000-00-00'),
('972', '12', '6250', '0', '0', '0', '0', '0000-00-00'),
('973', '13', '6250', '0', '0', '0', '0', '0000-00-00'),
('974', '14', '6250', '0', '0', '0', '0', '0000-00-00'),
('975', '15', '6250', '0', '0', '0', '0', '0000-00-00'),
('976', '16', '6250', '0', '0', '0', '0', '0000-00-00'),
('977', '17', '6250', '0', '0', '0', '0', '0000-00-00'),
('978', '18', '6250', '0', '0', '0', '0', '0000-00-00'),
('979', '19', '6250', '0', '0', '0', '0', '0000-00-00'),
('980', '20', '6250', '0', '0', '0', '0', '0000-00-00'),
('981', '21', '6250', '0', '0', '0', '0', '0000-00-00'),
('982', '22', '6250', '0', '0', '0', '0', '0000-00-00'),
('983', '23', '6250', '0', '0', '0', '0', '0000-00-00'),
('984', '24', '6250', '0', '0', '0', '0', '0000-00-00'),
('985', '1', '6300', '0', '0', '0', '0', '0000-00-00'),
('986', '2', '6300', '0', '0', '0', '0', '0000-00-00'),
('987', '3', '6300', '0', '0', '0', '0', '0000-00-00'),
('988', '4', '6300', '0', '0', '0', '0', '0000-00-00'),
('989', '5', '6300', '0', '0', '0', '0', '0000-00-00'),
('990', '6', '6300', '0', '0', '0', '0', '0000-00-00'),
('991', '7', '6300', '0', '0', '0', '0', '0000-00-00'),
('992', '8', '6300', '0', '0', '0', '0', '0000-00-00'),
('993', '9', '6300', '0', '0', '0', '0', '0000-00-00'),
('994', '10', '6300', '0', '0', '0', '0', '0000-00-00'),
('995', '11', '6300', '0', '0', '0', '0', '0000-00-00'),
('996', '12', '6300', '0', '0', '0', '0', '0000-00-00'),
('997', '13', '6300', '0', '0', '0', '0', '0000-00-00'),
('998', '14', '6300', '0', '0', '0', '0', '0000-00-00'),
('999', '15', '6300', '0', '0', '0', '0', '0000-00-00'),
('1000', '16', '6300', '0', '0', '0', '0', '0000-00-00'),
('1001', '17', '6300', '0', '0', '0', '0', '0000-00-00'),
('1002', '18', '6300', '0', '0', '0', '0', '0000-00-00'),
('1003', '19', '6300', '0', '0', '0', '0', '0000-00-00'),
('1004', '20', '6300', '0', '0', '0', '0', '0000-00-00'),
('1005', '21', '6300', '0', '0', '0', '0', '0000-00-00'),
('1006', '22', '6300', '0', '0', '0', '0', '0000-00-00'),
('1007', '23', '6300', '0', '0', '0', '0', '0000-00-00'),
('1008', '24', '6300', '0', '0', '0', '0', '0000-00-00'),
('1009', '1', '6350', '0', '0', '0', '0', '0000-00-00'),
('1010', '2', '6350', '0', '0', '0', '0', '0000-00-00'),
('1011', '3', '6350', '0', '0', '0', '0', '0000-00-00'),
('1012', '4', '6350', '0', '0', '0', '0', '0000-00-00'),
('1013', '5', '6350', '0', '0', '0', '0', '0000-00-00'),
('1014', '6', '6350', '0', '0', '0', '0', '0000-00-00'),
('1015', '7', '6350', '0', '0', '0', '0', '0000-00-00'),
('1016', '8', '6350', '0', '0', '0', '0', '0000-00-00'),
('1017', '9', '6350', '0', '0', '0', '0', '0000-00-00'),
('1018', '10', '6350', '0', '0', '0', '0', '0000-00-00'),
('1019', '11', '6350', '0', '0', '0', '0', '0000-00-00'),
('1020', '12', '6350', '0', '0', '0', '0', '0000-00-00'),
('1021', '13', '6350', '0', '0', '0', '0', '0000-00-00'),
('1022', '14', '6350', '0', '0', '0', '0', '0000-00-00'),
('1023', '15', '6350', '0', '0', '0', '0', '0000-00-00'),
('1024', '16', '6350', '0', '0', '0', '0', '0000-00-00'),
('1025', '17', '6350', '0', '0', '0', '0', '0000-00-00'),
('1026', '18', '6350', '0', '0', '0', '0', '0000-00-00'),
('1027', '19', '6350', '0', '0', '0', '0', '0000-00-00'),
('1028', '20', '6350', '0', '0', '0', '0', '0000-00-00'),
('1029', '21', '6350', '0', '0', '0', '0', '0000-00-00'),
('1030', '22', '6350', '0', '0', '0', '0', '0000-00-00'),
('1031', '23', '6350', '0', '0', '0', '0', '0000-00-00'),
('1032', '24', '6350', '0', '0', '0', '0', '0000-00-00'),
('1033', '1', '6400', '0', '0', '0', '0', '0000-00-00'),
('1034', '2', '6400', '0', '0', '0', '0', '0000-00-00'),
('1035', '3', '6400', '0', '0', '0', '0', '0000-00-00'),
('1036', '4', '6400', '0', '0', '0', '0', '0000-00-00'),
('1037', '5', '6400', '0', '0', '0', '0', '0000-00-00'),
('1038', '6', '6400', '0', '0', '0', '0', '0000-00-00'),
('1039', '7', '6400', '0', '0', '0', '0', '0000-00-00'),
('1040', '8', '6400', '0', '0', '0', '0', '0000-00-00'),
('1041', '9', '6400', '0', '0', '0', '0', '0000-00-00'),
('1042', '10', '6400', '0', '0', '0', '0', '0000-00-00'),
('1043', '11', '6400', '0', '0', '0', '0', '0000-00-00'),
('1044', '12', '6400', '0', '0', '0', '0', '0000-00-00'),
('1045', '13', '6400', '0', '0', '0', '0', '0000-00-00'),
('1046', '14', '6400', '0', '0', '0', '0', '0000-00-00'),
('1047', '15', '6400', '0', '0', '0', '0', '0000-00-00'),
('1048', '16', '6400', '0', '0', '0', '0', '0000-00-00'),
('1049', '17', '6400', '0', '0', '0', '0', '0000-00-00'),
('1050', '18', '6400', '0', '0', '0', '0', '0000-00-00'),
('1051', '19', '6400', '0', '0', '0', '0', '0000-00-00'),
('1052', '20', '6400', '0', '0', '0', '0', '0000-00-00'),
('1053', '21', '6400', '0', '0', '0', '0', '0000-00-00'),
('1054', '22', '6400', '0', '0', '0', '0', '0000-00-00'),
('1055', '23', '6400', '0', '0', '0', '0', '0000-00-00'),
('1056', '24', '6400', '0', '0', '0', '0', '0000-00-00'),
('1057', '1', '6450', '0', '0', '0', '0', '0000-00-00'),
('1058', '2', '6450', '0', '0', '0', '0', '0000-00-00'),
('1059', '3', '6450', '0', '0', '0', '0', '0000-00-00'),
('1060', '4', '6450', '0', '0', '0', '0', '0000-00-00'),
('1061', '5', '6450', '0', '0', '0', '0', '0000-00-00'),
('1062', '6', '6450', '0', '0', '0', '0', '0000-00-00'),
('1063', '7', '6450', '0', '0', '0', '0', '0000-00-00'),
('1064', '8', '6450', '0', '0', '0', '0', '0000-00-00'),
('1065', '9', '6450', '0', '0', '0', '0', '0000-00-00'),
('1066', '10', '6450', '0', '0', '0', '0', '0000-00-00'),
('1067', '11', '6450', '0', '0', '0', '0', '0000-00-00'),
('1068', '12', '6450', '0', '0', '0', '0', '0000-00-00'),
('1069', '13', '6450', '0', '0', '0', '0', '0000-00-00'),
('1070', '14', '6450', '0', '0', '0', '0', '0000-00-00'),
('1071', '15', '6450', '0', '0', '0', '0', '0000-00-00'),
('1072', '16', '6450', '0', '0', '0', '0', '0000-00-00'),
('1073', '17', '6450', '0', '0', '0', '0', '0000-00-00'),
('1074', '18', '6450', '0', '0', '0', '0', '0000-00-00'),
('1075', '19', '6450', '0', '0', '0', '0', '0000-00-00'),
('1076', '20', '6450', '0', '0', '0', '0', '0000-00-00'),
('1077', '21', '6450', '0', '0', '0', '0', '0000-00-00'),
('1078', '22', '6450', '0', '0', '0', '0', '0000-00-00'),
('1079', '23', '6450', '0', '0', '0', '0', '0000-00-00'),
('1080', '24', '6450', '0', '0', '0', '0', '0000-00-00'),
('1081', '1', '6500', '0', '0', '0', '0', '0000-00-00'),
('1082', '2', '6500', '0', '0', '0', '0', '0000-00-00'),
('1083', '3', '6500', '0', '0', '0', '0', '0000-00-00'),
('1084', '4', '6500', '0', '0', '0', '0', '0000-00-00'),
('1085', '5', '6500', '0', '0', '0', '0', '0000-00-00'),
('1086', '6', '6500', '0', '0', '0', '0', '0000-00-00'),
('1087', '7', '6500', '0', '0', '0', '0', '0000-00-00'),
('1088', '8', '6500', '0', '0', '0', '0', '0000-00-00'),
('1089', '9', '6500', '0', '0', '0', '0', '0000-00-00'),
('1090', '10', '6500', '0', '0', '0', '0', '0000-00-00'),
('1091', '11', '6500', '0', '0', '0', '0', '0000-00-00'),
('1092', '12', '6500', '0', '0', '0', '0', '0000-00-00'),
('1093', '13', '6500', '0', '0', '0', '0', '0000-00-00'),
('1094', '14', '6500', '0', '0', '0', '0', '0000-00-00'),
('1095', '15', '6500', '0', '0', '0', '0', '0000-00-00'),
('1096', '16', '6500', '0', '0', '0', '0', '0000-00-00'),
('1097', '17', '6500', '0', '0', '0', '0', '0000-00-00'),
('1098', '18', '6500', '0', '0', '0', '0', '0000-00-00'),
('1099', '19', '6500', '0', '0', '0', '0', '0000-00-00'),
('1100', '20', '6500', '0', '0', '0', '0', '0000-00-00'),
('1101', '21', '6500', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1102', '22', '6500', '0', '0', '0', '0', '0000-00-00'),
('1103', '23', '6500', '0', '0', '0', '0', '0000-00-00'),
('1104', '24', '6500', '0', '0', '0', '0', '0000-00-00'),
('1105', '1', '6550', '0', '0', '0', '0', '0000-00-00'),
('1106', '2', '6550', '0', '0', '0', '0', '0000-00-00'),
('1107', '3', '6550', '0', '0', '0', '0', '0000-00-00'),
('1108', '4', '6550', '0', '0', '0', '0', '0000-00-00'),
('1109', '5', '6550', '0', '0', '0', '0', '0000-00-00'),
('1110', '6', '6550', '0', '0', '0', '0', '0000-00-00'),
('1111', '7', '6550', '0', '0', '0', '0', '0000-00-00'),
('1112', '8', '6550', '0', '0', '0', '0', '0000-00-00'),
('1113', '9', '6550', '0', '0', '0', '0', '0000-00-00'),
('1114', '10', '6550', '0', '0', '0', '0', '0000-00-00'),
('1115', '11', '6550', '0', '0', '0', '0', '0000-00-00'),
('1116', '12', '6550', '0', '0', '0', '0', '0000-00-00'),
('1117', '13', '6550', '0', '0', '0', '0', '0000-00-00'),
('1118', '14', '6550', '0', '0', '0', '0', '0000-00-00'),
('1119', '15', '6550', '0', '0', '0', '0', '0000-00-00'),
('1120', '16', '6550', '0', '0', '0', '0', '0000-00-00'),
('1121', '17', '6550', '0', '0', '0', '0', '0000-00-00'),
('1122', '18', '6550', '0', '0', '0', '0', '0000-00-00'),
('1123', '19', '6550', '0', '0', '0', '0', '0000-00-00'),
('1124', '20', '6550', '0', '0', '0', '0', '0000-00-00'),
('1125', '21', '6550', '0', '0', '0', '0', '0000-00-00'),
('1126', '22', '6550', '0', '0', '0', '0', '0000-00-00'),
('1127', '23', '6550', '0', '0', '0', '0', '0000-00-00'),
('1128', '24', '6550', '0', '0', '0', '0', '0000-00-00'),
('1129', '1', '6600', '0', '0', '0', '0', '0000-00-00'),
('1130', '2', '6600', '0', '0', '0', '0', '0000-00-00'),
('1131', '3', '6600', '0', '0', '0', '0', '0000-00-00'),
('1132', '4', '6600', '0', '0', '0', '0', '0000-00-00'),
('1133', '5', '6600', '0', '0', '0', '0', '0000-00-00'),
('1134', '6', '6600', '0', '0', '0', '0', '0000-00-00'),
('1135', '7', '6600', '0', '0', '0', '0', '0000-00-00'),
('1136', '8', '6600', '0', '0', '0', '0', '0000-00-00'),
('1137', '9', '6600', '0', '0', '0', '0', '0000-00-00'),
('1138', '10', '6600', '0', '0', '0', '0', '0000-00-00'),
('1139', '11', '6600', '0', '0', '0', '0', '0000-00-00'),
('1140', '12', '6600', '0', '0', '0', '0', '0000-00-00'),
('1141', '13', '6600', '0', '0', '0', '0', '0000-00-00'),
('1142', '14', '6600', '0', '0', '0', '0', '0000-00-00'),
('1143', '15', '6600', '0', '0', '0', '0', '0000-00-00'),
('1144', '16', '6600', '0', '0', '0', '0', '0000-00-00'),
('1145', '17', '6600', '0', '0', '0', '0', '0000-00-00'),
('1146', '18', '6600', '0', '0', '0', '0', '0000-00-00'),
('1147', '19', '6600', '0', '0', '0', '0', '0000-00-00'),
('1148', '20', '6600', '0', '0', '0', '0', '0000-00-00'),
('1149', '21', '6600', '0', '0', '0', '0', '0000-00-00'),
('1150', '22', '6600', '0', '0', '0', '0', '0000-00-00'),
('1151', '23', '6600', '0', '0', '0', '0', '0000-00-00'),
('1152', '24', '6600', '0', '0', '0', '0', '0000-00-00'),
('1153', '1', '6650', '0', '0', '0', '0', '0000-00-00'),
('1154', '2', '6650', '0', '0', '0', '0', '0000-00-00'),
('1155', '3', '6650', '0', '0', '0', '0', '0000-00-00'),
('1156', '4', '6650', '0', '0', '0', '0', '0000-00-00'),
('1157', '5', '6650', '0', '0', '0', '0', '0000-00-00'),
('1158', '6', '6650', '0', '0', '0', '0', '0000-00-00'),
('1159', '7', '6650', '0', '0', '0', '0', '0000-00-00'),
('1160', '8', '6650', '0', '0', '0', '0', '0000-00-00'),
('1161', '9', '6650', '0', '0', '0', '0', '0000-00-00'),
('1162', '10', '6650', '0', '0', '0', '0', '0000-00-00'),
('1163', '11', '6650', '0', '0', '0', '0', '0000-00-00'),
('1164', '12', '6650', '0', '0', '0', '0', '0000-00-00'),
('1165', '13', '6650', '0', '0', '0', '0', '0000-00-00'),
('1166', '14', '6650', '0', '0', '0', '0', '0000-00-00'),
('1167', '15', '6650', '0', '0', '0', '0', '0000-00-00'),
('1168', '16', '6650', '0', '0', '0', '0', '0000-00-00'),
('1169', '17', '6650', '0', '0', '0', '0', '0000-00-00'),
('1170', '18', '6650', '0', '0', '0', '0', '0000-00-00'),
('1171', '19', '6650', '0', '0', '0', '0', '0000-00-00'),
('1172', '20', '6650', '0', '0', '0', '0', '0000-00-00'),
('1173', '21', '6650', '0', '0', '0', '0', '0000-00-00'),
('1174', '22', '6650', '0', '0', '0', '0', '0000-00-00'),
('1175', '23', '6650', '0', '0', '0', '0', '0000-00-00'),
('1176', '24', '6650', '0', '0', '0', '0', '0000-00-00'),
('1177', '1', '6700', '0', '0', '0', '0', '0000-00-00'),
('1178', '2', '6700', '0', '0', '0', '0', '0000-00-00'),
('1179', '3', '6700', '0', '0', '0', '0', '0000-00-00'),
('1180', '4', '6700', '0', '0', '0', '0', '0000-00-00'),
('1181', '5', '6700', '0', '0', '0', '0', '0000-00-00'),
('1182', '6', '6700', '0', '0', '0', '0', '0000-00-00'),
('1183', '7', '6700', '0', '0', '0', '0', '0000-00-00'),
('1184', '8', '6700', '0', '0', '0', '0', '0000-00-00'),
('1185', '9', '6700', '0', '0', '0', '0', '0000-00-00'),
('1186', '10', '6700', '0', '0', '0', '0', '0000-00-00'),
('1187', '11', '6700', '0', '0', '0', '0', '0000-00-00'),
('1188', '12', '6700', '0', '0', '0', '0', '0000-00-00'),
('1189', '13', '6700', '0', '0', '0', '0', '0000-00-00'),
('1190', '14', '6700', '0', '0', '0', '0', '0000-00-00'),
('1191', '15', '6700', '0', '0', '0', '0', '0000-00-00'),
('1192', '16', '6700', '0', '0', '0', '0', '0000-00-00'),
('1193', '17', '6700', '0', '0', '0', '0', '0000-00-00'),
('1194', '18', '6700', '0', '0', '0', '0', '0000-00-00'),
('1195', '19', '6700', '0', '0', '0', '0', '0000-00-00'),
('1196', '20', '6700', '0', '0', '0', '0', '0000-00-00'),
('1197', '21', '6700', '0', '0', '0', '0', '0000-00-00'),
('1198', '22', '6700', '0', '0', '0', '0', '0000-00-00'),
('1199', '23', '6700', '0', '0', '0', '0', '0000-00-00'),
('1200', '24', '6700', '0', '0', '0', '0', '0000-00-00'),
('1201', '1', '6750', '0', '0', '0', '0', '0000-00-00'),
('1202', '2', '6750', '0', '0', '0', '0', '0000-00-00'),
('1203', '3', '6750', '0', '0', '0', '0', '0000-00-00'),
('1204', '4', '6750', '0', '0', '0', '0', '0000-00-00'),
('1205', '5', '6750', '0', '0', '0', '0', '0000-00-00'),
('1206', '6', '6750', '0', '0', '0', '0', '0000-00-00'),
('1207', '7', '6750', '0', '0', '0', '0', '0000-00-00'),
('1208', '8', '6750', '0', '0', '0', '0', '0000-00-00'),
('1209', '9', '6750', '0', '0', '0', '0', '0000-00-00'),
('1210', '10', '6750', '0', '0', '0', '0', '0000-00-00'),
('1211', '11', '6750', '0', '0', '0', '0', '0000-00-00'),
('1212', '12', '6750', '0', '0', '0', '0', '0000-00-00'),
('1213', '13', '6750', '0', '0', '0', '0', '0000-00-00'),
('1214', '14', '6750', '0', '0', '0', '0', '0000-00-00'),
('1215', '15', '6750', '0', '0', '0', '0', '0000-00-00'),
('1216', '16', '6750', '0', '0', '0', '0', '0000-00-00'),
('1217', '17', '6750', '0', '0', '0', '0', '0000-00-00'),
('1218', '18', '6750', '0', '0', '0', '0', '0000-00-00'),
('1219', '19', '6750', '0', '0', '0', '0', '0000-00-00'),
('1220', '20', '6750', '0', '0', '0', '0', '0000-00-00'),
('1221', '21', '6750', '0', '0', '0', '0', '0000-00-00'),
('1222', '22', '6750', '0', '0', '0', '0', '0000-00-00'),
('1223', '23', '6750', '0', '0', '0', '0', '0000-00-00'),
('1224', '24', '6750', '0', '0', '0', '0', '0000-00-00'),
('1225', '1', '6800', '0', '0', '0', '0', '0000-00-00'),
('1226', '2', '6800', '0', '0', '0', '0', '0000-00-00'),
('1227', '3', '6800', '0', '0', '0', '0', '0000-00-00'),
('1228', '4', '6800', '0', '0', '0', '0', '0000-00-00'),
('1229', '5', '6800', '0', '0', '0', '0', '0000-00-00'),
('1230', '6', '6800', '0', '0', '0', '0', '0000-00-00'),
('1231', '7', '6800', '0', '0', '0', '0', '0000-00-00'),
('1232', '8', '6800', '0', '0', '0', '0', '0000-00-00'),
('1233', '9', '6800', '0', '0', '0', '0', '0000-00-00'),
('1234', '10', '6800', '0', '0', '0', '0', '0000-00-00'),
('1235', '11', '6800', '0', '0', '0', '0', '0000-00-00'),
('1236', '12', '6800', '0', '0', '0', '0', '0000-00-00'),
('1237', '13', '6800', '0', '0', '0', '0', '0000-00-00'),
('1238', '14', '6800', '0', '0', '0', '0', '0000-00-00'),
('1239', '15', '6800', '0', '0', '0', '0', '0000-00-00'),
('1240', '16', '6800', '0', '0', '0', '0', '0000-00-00'),
('1241', '17', '6800', '0', '0', '0', '0', '0000-00-00'),
('1242', '18', '6800', '0', '0', '0', '0', '0000-00-00'),
('1243', '19', '6800', '0', '0', '0', '0', '0000-00-00'),
('1244', '20', '6800', '0', '0', '0', '0', '0000-00-00'),
('1245', '21', '6800', '0', '0', '0', '0', '0000-00-00'),
('1246', '22', '6800', '0', '0', '0', '0', '0000-00-00'),
('1247', '23', '6800', '0', '0', '0', '0', '0000-00-00'),
('1248', '24', '6800', '0', '0', '0', '0', '0000-00-00'),
('1249', '1', '6850', '0', '0', '0', '0', '0000-00-00'),
('1250', '2', '6850', '0', '0', '0', '0', '0000-00-00'),
('1251', '3', '6850', '0', '0', '0', '0', '0000-00-00'),
('1252', '4', '6850', '0', '0', '0', '0', '0000-00-00'),
('1253', '5', '6850', '0', '0', '0', '0', '0000-00-00'),
('1254', '6', '6850', '0', '0', '0', '0', '0000-00-00'),
('1255', '7', '6850', '0', '0', '0', '0', '0000-00-00'),
('1256', '8', '6850', '0', '0', '0', '0', '0000-00-00'),
('1257', '9', '6850', '0', '0', '0', '0', '0000-00-00'),
('1258', '10', '6850', '0', '0', '0', '0', '0000-00-00'),
('1259', '11', '6850', '0', '0', '0', '0', '0000-00-00'),
('1260', '12', '6850', '0', '0', '0', '0', '0000-00-00'),
('1261', '13', '6850', '0', '0', '0', '0', '0000-00-00'),
('1262', '14', '6850', '0', '0', '0', '0', '0000-00-00'),
('1263', '15', '6850', '0', '0', '0', '0', '0000-00-00'),
('1264', '16', '6850', '0', '0', '0', '0', '0000-00-00'),
('1265', '17', '6850', '0', '0', '0', '0', '0000-00-00'),
('1266', '18', '6850', '0', '0', '0', '0', '0000-00-00'),
('1267', '19', '6850', '0', '0', '0', '0', '0000-00-00'),
('1268', '20', '6850', '0', '0', '0', '0', '0000-00-00'),
('1269', '21', '6850', '0', '0', '0', '0', '0000-00-00'),
('1270', '22', '6850', '0', '0', '0', '0', '0000-00-00'),
('1271', '23', '6850', '0', '0', '0', '0', '0000-00-00'),
('1272', '24', '6850', '0', '0', '0', '0', '0000-00-00'),
('1273', '1', '6900', '0', '0', '0', '0', '0000-00-00'),
('1274', '2', '6900', '0', '0', '0', '0', '0000-00-00'),
('1275', '3', '6900', '0', '0', '0', '0', '0000-00-00'),
('1276', '4', '6900', '0', '0', '0', '0', '0000-00-00'),
('1277', '5', '6900', '0', '0', '0', '0', '0000-00-00'),
('1278', '6', '6900', '0', '0', '0', '0', '0000-00-00'),
('1279', '7', '6900', '0', '0', '0', '0', '0000-00-00'),
('1280', '8', '6900', '0', '0', '0', '0', '0000-00-00'),
('1281', '9', '6900', '0', '0', '0', '0', '0000-00-00'),
('1282', '10', '6900', '0', '0', '0', '0', '0000-00-00'),
('1283', '11', '6900', '0', '0', '0', '0', '0000-00-00'),
('1284', '12', '6900', '0', '0', '0', '0', '0000-00-00'),
('1285', '13', '6900', '0', '0', '0', '0', '0000-00-00'),
('1286', '14', '6900', '0', '0', '0', '0', '0000-00-00'),
('1287', '15', '6900', '0', '0', '0', '0', '0000-00-00'),
('1288', '16', '6900', '0', '0', '0', '0', '0000-00-00'),
('1289', '17', '6900', '0', '0', '0', '0', '0000-00-00'),
('1290', '18', '6900', '0', '0', '0', '0', '0000-00-00'),
('1291', '19', '6900', '0', '0', '0', '0', '0000-00-00'),
('1292', '20', '6900', '0', '0', '0', '0', '0000-00-00'),
('1293', '21', '6900', '0', '0', '0', '0', '0000-00-00'),
('1294', '22', '6900', '0', '0', '0', '0', '0000-00-00'),
('1295', '23', '6900', '0', '0', '0', '0', '0000-00-00'),
('1296', '24', '6900', '0', '0', '0', '0', '0000-00-00'),
('1297', '1', '6950', '0', '0', '0', '0', '0000-00-00'),
('1298', '2', '6950', '0', '0', '0', '0', '0000-00-00'),
('1299', '3', '6950', '0', '0', '0', '0', '0000-00-00'),
('1300', '4', '6950', '0', '0', '0', '0', '0000-00-00'),
('1301', '5', '6950', '0', '0', '0', '0', '0000-00-00'),
('1302', '6', '6950', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1303', '7', '6950', '0', '0', '0', '0', '0000-00-00'),
('1304', '8', '6950', '0', '0', '0', '0', '0000-00-00'),
('1305', '9', '6950', '0', '0', '0', '0', '0000-00-00'),
('1306', '10', '6950', '0', '0', '0', '0', '0000-00-00'),
('1307', '11', '6950', '0', '0', '0', '0', '0000-00-00'),
('1308', '12', '6950', '0', '0', '0', '0', '0000-00-00'),
('1309', '13', '6950', '0', '0', '0', '0', '0000-00-00'),
('1310', '14', '6950', '0', '0', '0', '0', '0000-00-00'),
('1311', '15', '6950', '0', '0', '0', '0', '0000-00-00'),
('1312', '16', '6950', '0', '0', '0', '0', '0000-00-00'),
('1313', '17', '6950', '0', '0', '0', '0', '0000-00-00'),
('1314', '18', '6950', '0', '0', '0', '0', '0000-00-00'),
('1315', '19', '6950', '0', '0', '0', '0', '0000-00-00'),
('1316', '20', '6950', '0', '0', '0', '0', '0000-00-00'),
('1317', '21', '6950', '0', '0', '0', '0', '0000-00-00'),
('1318', '22', '6950', '0', '0', '0', '0', '0000-00-00'),
('1319', '23', '6950', '0', '0', '0', '0', '0000-00-00'),
('1320', '24', '6950', '0', '0', '0', '0', '0000-00-00'),
('1321', '1', '7000', '0', '0', '0', '0', '0000-00-00'),
('1322', '2', '7000', '0', '0', '0', '0', '0000-00-00'),
('1323', '3', '7000', '0', '0', '0', '0', '0000-00-00'),
('1324', '4', '7000', '0', '0', '0', '0', '0000-00-00'),
('1325', '5', '7000', '0', '0', '0', '0', '0000-00-00'),
('1326', '6', '7000', '0', '0', '0', '0', '0000-00-00'),
('1327', '7', '7000', '0', '0', '0', '0', '0000-00-00'),
('1328', '8', '7000', '0', '0', '0', '0', '0000-00-00'),
('1329', '9', '7000', '0', '0', '0', '0', '0000-00-00'),
('1330', '10', '7000', '0', '0', '0', '0', '0000-00-00'),
('1331', '11', '7000', '0', '0', '0', '0', '0000-00-00'),
('1332', '12', '7000', '0', '0', '0', '0', '0000-00-00'),
('1333', '13', '7000', '0', '0', '0', '0', '0000-00-00'),
('1334', '14', '7000', '0', '0', '0', '0', '0000-00-00'),
('1335', '15', '7000', '0', '0', '0', '0', '0000-00-00'),
('1336', '16', '7000', '0', '0', '0', '0', '0000-00-00'),
('1337', '17', '7000', '0', '0', '0', '0', '0000-00-00'),
('1338', '18', '7000', '0', '0', '0', '0', '0000-00-00'),
('1339', '19', '7000', '0', '0', '0', '0', '0000-00-00'),
('1340', '20', '7000', '0', '0', '0', '0', '0000-00-00'),
('1341', '21', '7000', '0', '0', '0', '0', '0000-00-00'),
('1342', '22', '7000', '0', '0', '0', '0', '0000-00-00'),
('1343', '23', '7000', '0', '0', '0', '0', '0000-00-00'),
('1344', '24', '7000', '0', '0', '0', '0', '0000-00-00'),
('1345', '1', '7050', '0', '0', '0', '0', '0000-00-00'),
('1346', '2', '7050', '0', '0', '0', '0', '0000-00-00'),
('1347', '3', '7050', '0', '0', '0', '0', '0000-00-00'),
('1348', '4', '7050', '0', '0', '0', '0', '0000-00-00'),
('1349', '5', '7050', '0', '0', '0', '0', '0000-00-00'),
('1350', '6', '7050', '0', '0', '0', '0', '0000-00-00'),
('1351', '7', '7050', '0', '0', '0', '0', '0000-00-00'),
('1352', '8', '7050', '0', '0', '0', '0', '0000-00-00'),
('1353', '9', '7050', '0', '0', '0', '0', '0000-00-00'),
('1354', '10', '7050', '0', '0', '0', '0', '0000-00-00'),
('1355', '11', '7050', '0', '0', '0', '0', '0000-00-00'),
('1356', '12', '7050', '0', '0', '0', '0', '0000-00-00'),
('1357', '13', '7050', '0', '0', '0', '0', '0000-00-00'),
('1358', '14', '7050', '0', '0', '0', '0', '0000-00-00'),
('1359', '15', '7050', '0', '0', '0', '0', '0000-00-00'),
('1360', '16', '7050', '0', '0', '0', '0', '0000-00-00'),
('1361', '17', '7050', '0', '0', '0', '0', '0000-00-00'),
('1362', '18', '7050', '0', '0', '0', '0', '0000-00-00'),
('1363', '19', '7050', '0', '0', '0', '0', '0000-00-00'),
('1364', '20', '7050', '0', '0', '0', '0', '0000-00-00'),
('1365', '21', '7050', '0', '0', '0', '0', '0000-00-00'),
('1366', '22', '7050', '0', '0', '0', '0', '0000-00-00'),
('1367', '23', '7050', '0', '0', '0', '0', '0000-00-00'),
('1368', '24', '7050', '0', '0', '0', '0', '0000-00-00'),
('1369', '1', '7100', '0', '0', '0', '0', '0000-00-00'),
('1370', '2', '7100', '0', '0', '0', '0', '0000-00-00'),
('1371', '3', '7100', '0', '0', '0', '0', '0000-00-00'),
('1372', '4', '7100', '0', '0', '0', '0', '0000-00-00'),
('1373', '5', '7100', '0', '0', '0', '0', '0000-00-00'),
('1374', '6', '7100', '0', '0', '0', '0', '0000-00-00'),
('1375', '7', '7100', '0', '0', '0', '0', '0000-00-00'),
('1376', '8', '7100', '0', '0', '0', '0', '0000-00-00'),
('1377', '9', '7100', '0', '0', '0', '0', '0000-00-00'),
('1378', '10', '7100', '0', '0', '0', '0', '0000-00-00'),
('1379', '11', '7100', '0', '0', '0', '0', '0000-00-00'),
('1380', '12', '7100', '0', '0', '0', '0', '0000-00-00'),
('1381', '13', '7100', '0', '0', '0', '0', '0000-00-00'),
('1382', '14', '7100', '0', '0', '0', '0', '0000-00-00'),
('1383', '15', '7100', '0', '0', '0', '0', '0000-00-00'),
('1384', '16', '7100', '0', '0', '0', '0', '0000-00-00'),
('1385', '17', '7100', '0', '0', '0', '0', '0000-00-00'),
('1386', '18', '7100', '0', '0', '0', '0', '0000-00-00'),
('1387', '19', '7100', '0', '0', '0', '0', '0000-00-00'),
('1388', '20', '7100', '0', '0', '0', '0', '0000-00-00'),
('1389', '21', '7100', '0', '0', '0', '0', '0000-00-00'),
('1390', '22', '7100', '0', '0', '0', '0', '0000-00-00'),
('1391', '23', '7100', '0', '0', '0', '0', '0000-00-00'),
('1392', '24', '7100', '0', '0', '0', '0', '0000-00-00'),
('1393', '1', '1021', '0', '0', '0', '0', '0000-00-00'),
('1394', '2', '1021', '0', '0', '0', '0', '0000-00-00'),
('1395', '3', '1021', '0', '0', '0', '0', '0000-00-00'),
('1396', '4', '1021', '0', '0', '0', '0', '0000-00-00'),
('1397', '5', '1021', '0', '0', '0', '0', '0000-00-00'),
('1398', '6', '1021', '0', '0', '0', '0', '0000-00-00'),
('1399', '7', '1021', '0', '0', '0', '0', '0000-00-00'),
('1400', '8', '1021', '0', '0', '0', '0', '0000-00-00'),
('1401', '9', '1021', '0', '0', '0', '0', '0000-00-00'),
('1402', '10', '1021', '0', '0', '0', '0', '0000-00-00'),
('1403', '11', '1021', '0', '0', '0', '0', '0000-00-00'),
('1404', '12', '1021', '0', '0', '0', '0', '0000-00-00'),
('1405', '13', '1021', '0', '0', '0', '0', '0000-00-00'),
('1406', '14', '1021', '0', '0', '0', '0', '0000-00-00'),
('1407', '15', '1021', '0', '0', '0', '0', '0000-00-00'),
('1408', '16', '1021', '0', '0', '0', '0', '0000-00-00'),
('1409', '17', '1021', '0', '0', '0', '0', '0000-00-00'),
('1410', '18', '1021', '0', '0', '0', '0', '0000-00-00'),
('1411', '19', '1021', '0', '0', '0', '0', '0000-00-00'),
('1412', '20', '1021', '0', '0', '0', '0', '0000-00-00'),
('1413', '21', '1021', '0', '0', '0', '0', '0000-00-00'),
('1414', '22', '1021', '0', '0', '0', '0', '0000-00-00'),
('1415', '23', '1021', '0', '0', '0', '0', '0000-00-00'),
('1416', '24', '1021', '0', '0', '0', '0', '0000-00-00'),
('1417', '1', '1022', '0', '0', '0', '0', '0000-00-00'),
('1418', '2', '1022', '0', '0', '0', '0', '0000-00-00'),
('1419', '3', '1022', '0', '0', '0', '0', '0000-00-00'),
('1420', '4', '1022', '0', '0', '0', '0', '0000-00-00'),
('1421', '5', '1022', '0', '0', '0', '0', '0000-00-00'),
('1422', '6', '1022', '0', '0', '0', '0', '0000-00-00'),
('1423', '7', '1022', '0', '0', '0', '0', '0000-00-00'),
('1424', '8', '1022', '0', '0', '0', '0', '0000-00-00'),
('1425', '9', '1022', '0', '0', '0', '0', '0000-00-00'),
('1426', '10', '1022', '0', '0', '0', '0', '0000-00-00'),
('1427', '11', '1022', '0', '0', '0', '0', '0000-00-00'),
('1428', '12', '1022', '0', '0', '0', '0', '0000-00-00'),
('1429', '13', '1022', '0', '0', '0', '0', '0000-00-00'),
('1430', '14', '1022', '0', '0', '0', '0', '0000-00-00'),
('1431', '15', '1022', '0', '0', '0', '0', '0000-00-00'),
('1432', '16', '1022', '0', '0', '0', '0', '0000-00-00'),
('1433', '17', '1022', '0', '0', '0', '0', '0000-00-00'),
('1434', '18', '1022', '0', '0', '0', '0', '0000-00-00'),
('1435', '19', '1022', '0', '0', '0', '0', '0000-00-00'),
('1436', '20', '1022', '0', '0', '0', '0', '0000-00-00'),
('1437', '21', '1022', '0', '0', '0', '0', '0000-00-00'),
('1438', '22', '1022', '0', '0', '0', '0', '0000-00-00'),
('1439', '23', '1022', '0', '0', '0', '0', '0000-00-00'),
('1440', '24', '1022', '0', '0', '0', '0', '0000-00-00'),
('1441', '1', '1023', '0', '0', '0', '0', '0000-00-00'),
('1442', '2', '1023', '0', '0', '0', '0', '0000-00-00'),
('1443', '3', '1023', '0', '0', '0', '0', '0000-00-00'),
('1444', '4', '1023', '0', '0', '0', '0', '0000-00-00'),
('1445', '5', '1023', '0', '0', '0', '0', '0000-00-00'),
('1446', '6', '1023', '0', '0', '0', '0', '0000-00-00'),
('1447', '7', '1023', '0', '0', '0', '0', '0000-00-00'),
('1448', '8', '1023', '0', '0', '0', '0', '0000-00-00'),
('1449', '9', '1023', '0', '0', '0', '0', '0000-00-00'),
('1450', '10', '1023', '0', '0', '0', '0', '0000-00-00'),
('1451', '11', '1023', '0', '0', '0', '0', '0000-00-00'),
('1452', '12', '1023', '0', '0', '0', '0', '0000-00-00'),
('1453', '13', '1023', '0', '0', '0', '0', '0000-00-00'),
('1454', '14', '1023', '0', '0', '0', '0', '0000-00-00'),
('1455', '15', '1023', '0', '0', '0', '0', '0000-00-00'),
('1456', '16', '1023', '0', '0', '0', '0', '0000-00-00'),
('1457', '17', '1023', '0', '0', '0', '0', '0000-00-00'),
('1458', '18', '1023', '0', '0', '0', '0', '0000-00-00'),
('1459', '19', '1023', '0', '0', '0', '0', '0000-00-00'),
('1460', '20', '1023', '0', '0', '0', '0', '0000-00-00'),
('1461', '21', '1023', '0', '0', '0', '0', '0000-00-00'),
('1462', '22', '1023', '0', '0', '0', '0', '0000-00-00'),
('1463', '23', '1023', '0', '0', '0', '0', '0000-00-00'),
('1464', '24', '1023', '0', '0', '0', '0', '0000-00-00'),
('1465', '1', '1024', '0', '0', '0', '0', '0000-00-00'),
('1466', '2', '1024', '0', '0', '0', '0', '0000-00-00'),
('1467', '3', '1024', '0', '0', '0', '0', '0000-00-00'),
('1468', '4', '1024', '0', '0', '0', '0', '0000-00-00'),
('1469', '5', '1024', '0', '0', '0', '0', '0000-00-00'),
('1470', '6', '1024', '0', '0', '0', '0', '0000-00-00'),
('1471', '7', '1024', '0', '0', '0', '0', '0000-00-00'),
('1472', '8', '1024', '0', '0', '0', '0', '0000-00-00'),
('1473', '9', '1024', '0', '0', '0', '0', '0000-00-00'),
('1474', '10', '1024', '0', '0', '0', '0', '0000-00-00'),
('1475', '11', '1024', '0', '0', '0', '0', '0000-00-00'),
('1476', '12', '1024', '0', '0', '0', '0', '0000-00-00'),
('1477', '13', '1024', '0', '0', '0', '0', '0000-00-00'),
('1478', '14', '1024', '0', '0', '0', '0', '0000-00-00'),
('1479', '15', '1024', '0', '0', '0', '0', '0000-00-00'),
('1480', '16', '1024', '0', '0', '0', '0', '0000-00-00'),
('1481', '17', '1024', '0', '0', '0', '0', '0000-00-00'),
('1482', '18', '1024', '0', '0', '0', '0', '0000-00-00'),
('1483', '19', '1024', '0', '0', '0', '0', '0000-00-00'),
('1484', '20', '1024', '0', '0', '0', '0', '0000-00-00'),
('1485', '21', '1024', '0', '0', '0', '0', '0000-00-00'),
('1486', '22', '1024', '0', '0', '0', '0', '0000-00-00'),
('1487', '23', '1024', '0', '0', '0', '0', '0000-00-00'),
('1488', '24', '1024', '0', '0', '0', '0', '0000-00-00'),
('1489', '1', '1025', '0', '0', '0', '0', '0000-00-00'),
('1490', '2', '1025', '0', '0', '0', '0', '0000-00-00'),
('1491', '3', '1025', '0', '0', '0', '0', '0000-00-00'),
('1492', '4', '1025', '0', '0', '0', '0', '0000-00-00'),
('1493', '5', '1025', '0', '0', '0', '0', '0000-00-00'),
('1494', '6', '1025', '0', '0', '0', '0', '0000-00-00'),
('1495', '7', '1025', '0', '0', '0', '0', '0000-00-00'),
('1496', '8', '1025', '0', '0', '0', '0', '0000-00-00'),
('1497', '9', '1025', '0', '0', '0', '0', '0000-00-00'),
('1498', '10', '1025', '0', '0', '0', '0', '0000-00-00'),
('1499', '11', '1025', '0', '0', '0', '0', '0000-00-00'),
('1500', '12', '1025', '0', '0', '0', '0', '0000-00-00'),
('1501', '13', '1025', '0', '0', '0', '0', '0000-00-00'),
('1502', '14', '1025', '0', '0', '0', '0', '0000-00-00'),
('1503', '15', '1025', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1504', '16', '1025', '0', '0', '0', '0', '0000-00-00'),
('1505', '17', '1025', '0', '0', '0', '0', '0000-00-00'),
('1506', '18', '1025', '0', '0', '0', '0', '0000-00-00'),
('1507', '19', '1025', '0', '0', '0', '0', '0000-00-00'),
('1508', '20', '1025', '0', '0', '0', '0', '0000-00-00'),
('1509', '21', '1025', '0', '0', '0', '0', '0000-00-00'),
('1510', '22', '1025', '0', '0', '0', '0', '0000-00-00'),
('1511', '23', '1025', '0', '0', '0', '0', '0000-00-00'),
('1512', '24', '1025', '0', '0', '0', '0', '0000-00-00'),
('1513', '1', '1026', '0', '0', '0', '0', '0000-00-00'),
('1514', '2', '1026', '0', '0', '0', '0', '0000-00-00'),
('1515', '3', '1026', '0', '0', '0', '0', '0000-00-00'),
('1516', '4', '1026', '0', '0', '0', '0', '0000-00-00'),
('1517', '5', '1026', '0', '0', '0', '0', '0000-00-00'),
('1518', '6', '1026', '0', '0', '0', '0', '0000-00-00'),
('1519', '7', '1026', '0', '0', '0', '0', '0000-00-00'),
('1520', '8', '1026', '0', '0', '0', '0', '0000-00-00'),
('1521', '9', '1026', '0', '0', '0', '0', '0000-00-00'),
('1522', '10', '1026', '0', '0', '0', '0', '0000-00-00'),
('1523', '11', '1026', '0', '0', '0', '0', '0000-00-00'),
('1524', '12', '1026', '0', '0', '0', '0', '0000-00-00'),
('1525', '13', '1026', '0', '0', '0', '0', '0000-00-00'),
('1526', '14', '1026', '0', '0', '0', '0', '0000-00-00'),
('1527', '15', '1026', '0', '0', '0', '0', '0000-00-00'),
('1528', '16', '1026', '0', '0', '0', '0', '0000-00-00'),
('1529', '17', '1026', '0', '0', '0', '0', '0000-00-00'),
('1530', '18', '1026', '0', '0', '0', '0', '0000-00-00'),
('1531', '19', '1026', '0', '0', '0', '0', '0000-00-00'),
('1532', '20', '1026', '0', '0', '0', '0', '0000-00-00'),
('1533', '21', '1026', '0', '0', '0', '0', '0000-00-00'),
('1534', '22', '1026', '0', '0', '0', '0', '0000-00-00'),
('1535', '23', '1026', '0', '0', '0', '0', '0000-00-00'),
('1536', '24', '1026', '0', '0', '0', '0', '0000-00-00'),
('1537', '1', '1027', '0', '0', '0', '0', '0000-00-00'),
('1538', '2', '1027', '0', '0', '0', '0', '0000-00-00'),
('1539', '3', '1027', '0', '0', '0', '0', '0000-00-00'),
('1540', '4', '1027', '0', '0', '0', '0', '0000-00-00'),
('1541', '5', '1027', '0', '0', '0', '0', '0000-00-00'),
('1542', '6', '1027', '0', '0', '0', '0', '0000-00-00'),
('1543', '7', '1027', '0', '0', '0', '0', '0000-00-00'),
('1544', '8', '1027', '0', '0', '0', '0', '0000-00-00'),
('1545', '9', '1027', '0', '0', '0', '0', '0000-00-00'),
('1546', '10', '1027', '0', '0', '0', '0', '0000-00-00'),
('1547', '11', '1027', '0', '0', '0', '0', '0000-00-00'),
('1548', '12', '1027', '0', '0', '0', '0', '0000-00-00'),
('1549', '13', '1027', '0', '0', '0', '0', '0000-00-00'),
('1550', '14', '1027', '0', '0', '0', '0', '0000-00-00'),
('1551', '15', '1027', '0', '0', '0', '0', '0000-00-00'),
('1552', '16', '1027', '0', '0', '0', '0', '0000-00-00'),
('1553', '17', '1027', '0', '0', '0', '0', '0000-00-00'),
('1554', '18', '1027', '0', '0', '0', '0', '0000-00-00'),
('1555', '19', '1027', '0', '0', '0', '0', '0000-00-00'),
('1556', '20', '1027', '0', '0', '0', '0', '0000-00-00'),
('1557', '21', '1027', '0', '0', '0', '0', '0000-00-00'),
('1558', '22', '1027', '0', '0', '0', '0', '0000-00-00'),
('1559', '23', '1027', '0', '0', '0', '0', '0000-00-00'),
('1560', '24', '1027', '0', '0', '0', '0', '0000-00-00'),
('1561', '1', '1028', '0', '0', '0', '0', '0000-00-00'),
('1562', '2', '1028', '0', '0', '0', '0', '0000-00-00'),
('1563', '3', '1028', '0', '0', '0', '0', '0000-00-00'),
('1564', '4', '1028', '0', '0', '0', '0', '0000-00-00'),
('1565', '5', '1028', '0', '0', '0', '0', '0000-00-00'),
('1566', '6', '1028', '0', '0', '0', '0', '0000-00-00'),
('1567', '7', '1028', '0', '0', '0', '0', '0000-00-00'),
('1568', '8', '1028', '0', '0', '0', '0', '0000-00-00'),
('1569', '9', '1028', '0', '0', '0', '0', '0000-00-00'),
('1570', '10', '1028', '0', '0', '0', '0', '0000-00-00'),
('1571', '11', '1028', '0', '0', '0', '0', '0000-00-00'),
('1572', '12', '1028', '0', '0', '0', '0', '0000-00-00'),
('1573', '13', '1028', '0', '0', '0', '0', '0000-00-00'),
('1574', '14', '1028', '0', '0', '0', '0', '0000-00-00'),
('1575', '15', '1028', '0', '0', '0', '0', '0000-00-00'),
('1576', '16', '1028', '0', '0', '0', '0', '0000-00-00'),
('1577', '17', '1028', '0', '0', '0', '0', '0000-00-00'),
('1578', '18', '1028', '0', '0', '0', '0', '0000-00-00'),
('1579', '19', '1028', '0', '0', '0', '0', '0000-00-00'),
('1580', '20', '1028', '0', '0', '0', '0', '0000-00-00'),
('1581', '21', '1028', '0', '0', '0', '0', '0000-00-00'),
('1582', '22', '1028', '0', '0', '0', '0', '0000-00-00'),
('1583', '23', '1028', '0', '0', '0', '0', '0000-00-00'),
('1584', '24', '1028', '0', '0', '0', '0', '0000-00-00'),
('1585', '1', '1029', '0', '0', '0', '0', '0000-00-00'),
('1586', '2', '1029', '0', '0', '0', '0', '0000-00-00'),
('1587', '3', '1029', '0', '0', '0', '0', '0000-00-00'),
('1588', '4', '1029', '0', '0', '0', '0', '0000-00-00'),
('1589', '5', '1029', '0', '0', '0', '0', '0000-00-00'),
('1590', '6', '1029', '0', '0', '0', '0', '0000-00-00'),
('1591', '7', '1029', '0', '0', '0', '0', '0000-00-00'),
('1592', '8', '1029', '0', '0', '0', '0', '0000-00-00'),
('1593', '9', '1029', '0', '0', '0', '0', '0000-00-00'),
('1594', '10', '1029', '0', '0', '0', '0', '0000-00-00'),
('1595', '11', '1029', '0', '0', '0', '0', '0000-00-00'),
('1596', '12', '1029', '0', '0', '0', '0', '0000-00-00'),
('1597', '13', '1029', '0', '0', '0', '0', '0000-00-00'),
('1598', '14', '1029', '0', '0', '0', '0', '0000-00-00'),
('1599', '15', '1029', '0', '0', '0', '0', '0000-00-00'),
('1600', '16', '1029', '0', '0', '0', '0', '0000-00-00'),
('1601', '17', '1029', '0', '0', '0', '0', '0000-00-00'),
('1602', '18', '1029', '0', '0', '0', '0', '0000-00-00'),
('1603', '19', '1029', '0', '0', '0', '0', '0000-00-00'),
('1604', '20', '1029', '0', '0', '0', '0', '0000-00-00'),
('1605', '21', '1029', '0', '0', '0', '0', '0000-00-00'),
('1606', '22', '1029', '0', '0', '0', '0', '0000-00-00'),
('1607', '23', '1029', '0', '0', '0', '0', '0000-00-00'),
('1608', '24', '1029', '0', '0', '0', '0', '0000-00-00'),
('1609', '1', '1030', '0', '0', '0', '0', '0000-00-00'),
('1610', '2', '1030', '0', '0', '0', '0', '0000-00-00'),
('1611', '3', '1030', '0', '0', '0', '0', '0000-00-00'),
('1612', '4', '1030', '0', '0', '0', '0', '0000-00-00'),
('1613', '5', '1030', '0', '0', '0', '0', '0000-00-00'),
('1614', '6', '1030', '0', '0', '0', '0', '0000-00-00'),
('1615', '7', '1030', '0', '0', '0', '0', '0000-00-00'),
('1616', '8', '1030', '0', '0', '0', '0', '0000-00-00'),
('1617', '9', '1030', '0', '0', '0', '0', '0000-00-00'),
('1618', '10', '1030', '0', '0', '0', '0', '0000-00-00'),
('1619', '11', '1030', '0', '0', '0', '0', '0000-00-00'),
('1620', '12', '1030', '0', '0', '0', '0', '0000-00-00'),
('1621', '13', '1030', '0', '0', '0', '0', '0000-00-00'),
('1622', '14', '1030', '0', '0', '0', '0', '0000-00-00'),
('1623', '15', '1030', '0', '0', '0', '0', '0000-00-00'),
('1624', '16', '1030', '0', '0', '0', '0', '0000-00-00'),
('1625', '17', '1030', '0', '0', '0', '0', '0000-00-00'),
('1626', '18', '1030', '0', '0', '0', '0', '0000-00-00'),
('1627', '19', '1030', '0', '0', '0', '0', '0000-00-00'),
('1628', '20', '1030', '0', '0', '0', '0', '0000-00-00'),
('1629', '21', '1030', '0', '0', '0', '0', '0000-00-00'),
('1630', '22', '1030', '0', '0', '0', '0', '0000-00-00'),
('1631', '23', '1030', '0', '0', '0', '0', '0000-00-00'),
('1632', '24', '1030', '0', '0', '0', '0', '0000-00-00'),
('1633', '1', '1031', '0', '0', '0', '0', '0000-00-00'),
('1634', '2', '1031', '0', '0', '0', '0', '0000-00-00'),
('1635', '3', '1031', '0', '0', '0', '0', '0000-00-00'),
('1636', '4', '1031', '0', '0', '0', '0', '0000-00-00'),
('1637', '5', '1031', '0', '0', '0', '0', '0000-00-00'),
('1638', '6', '1031', '0', '0', '0', '0', '0000-00-00'),
('1639', '7', '1031', '0', '0', '0', '0', '0000-00-00'),
('1640', '8', '1031', '0', '0', '0', '0', '0000-00-00'),
('1641', '9', '1031', '0', '0', '0', '0', '0000-00-00'),
('1642', '10', '1031', '0', '0', '0', '0', '0000-00-00'),
('1643', '11', '1031', '0', '0', '0', '0', '0000-00-00'),
('1644', '12', '1031', '0', '0', '0', '0', '0000-00-00'),
('1645', '13', '1031', '0', '0', '0', '0', '0000-00-00'),
('1646', '14', '1031', '0', '0', '0', '0', '0000-00-00'),
('1647', '15', '1031', '0', '0', '0', '0', '0000-00-00'),
('1648', '16', '1031', '0', '0', '0', '0', '0000-00-00'),
('1649', '17', '1031', '0', '0', '0', '0', '0000-00-00'),
('1650', '18', '1031', '0', '0', '0', '0', '0000-00-00'),
('1651', '19', '1031', '0', '0', '0', '0', '0000-00-00'),
('1652', '20', '1031', '0', '0', '0', '0', '0000-00-00'),
('1653', '21', '1031', '0', '0', '0', '0', '0000-00-00'),
('1654', '22', '1031', '0', '0', '0', '0', '0000-00-00'),
('1655', '23', '1031', '0', '0', '0', '0', '0000-00-00'),
('1656', '24', '1031', '0', '0', '0', '0', '0000-00-00'),
('1657', '1', '1032', '0', '0', '0', '0', '0000-00-00'),
('1658', '2', '1032', '0', '0', '0', '0', '0000-00-00'),
('1659', '3', '1032', '0', '0', '0', '0', '0000-00-00'),
('1660', '4', '1032', '0', '0', '0', '0', '0000-00-00'),
('1661', '5', '1032', '0', '0', '0', '0', '0000-00-00'),
('1662', '6', '1032', '0', '0', '0', '0', '0000-00-00'),
('1663', '7', '1032', '0', '0', '0', '0', '0000-00-00'),
('1664', '8', '1032', '0', '0', '0', '0', '0000-00-00'),
('1665', '9', '1032', '0', '0', '0', '0', '0000-00-00'),
('1666', '10', '1032', '0', '0', '0', '0', '0000-00-00'),
('1667', '11', '1032', '0', '0', '0', '0', '0000-00-00'),
('1668', '12', '1032', '0', '0', '0', '0', '0000-00-00'),
('1669', '13', '1032', '0', '0', '0', '0', '0000-00-00'),
('1670', '14', '1032', '0', '0', '0', '0', '0000-00-00'),
('1671', '15', '1032', '0', '0', '0', '0', '0000-00-00'),
('1672', '16', '1032', '0', '0', '0', '0', '0000-00-00'),
('1673', '17', '1032', '0', '0', '0', '0', '0000-00-00'),
('1674', '18', '1032', '0', '0', '0', '0', '0000-00-00'),
('1675', '19', '1032', '0', '0', '0', '0', '0000-00-00'),
('1676', '20', '1032', '0', '0', '0', '0', '0000-00-00'),
('1677', '21', '1032', '0', '0', '0', '0', '0000-00-00'),
('1678', '22', '1032', '0', '0', '0', '0', '0000-00-00'),
('1679', '23', '1032', '0', '0', '0', '0', '0000-00-00'),
('1680', '24', '1032', '0', '0', '0', '0', '0000-00-00'),
('1681', '1', '1033', '0', '0', '0', '0', '0000-00-00'),
('1682', '2', '1033', '0', '0', '0', '0', '0000-00-00'),
('1683', '3', '1033', '0', '0', '0', '0', '0000-00-00'),
('1684', '4', '1033', '0', '0', '0', '0', '0000-00-00'),
('1685', '5', '1033', '0', '0', '0', '0', '0000-00-00'),
('1686', '6', '1033', '0', '0', '0', '0', '0000-00-00'),
('1687', '7', '1033', '0', '0', '0', '0', '0000-00-00'),
('1688', '8', '1033', '0', '0', '0', '0', '0000-00-00'),
('1689', '9', '1033', '0', '0', '0', '0', '0000-00-00'),
('1690', '10', '1033', '0', '0', '0', '0', '0000-00-00'),
('1691', '11', '1033', '0', '0', '0', '0', '0000-00-00'),
('1692', '12', '1033', '0', '0', '0', '0', '0000-00-00'),
('1693', '13', '1033', '0', '0', '0', '0', '0000-00-00'),
('1694', '14', '1033', '0', '0', '0', '0', '0000-00-00'),
('1695', '15', '1033', '0', '0', '0', '0', '0000-00-00'),
('1696', '16', '1033', '0', '0', '0', '0', '0000-00-00'),
('1697', '17', '1033', '0', '0', '0', '0', '0000-00-00'),
('1698', '18', '1033', '0', '0', '0', '0', '0000-00-00'),
('1699', '19', '1033', '0', '0', '0', '0', '0000-00-00'),
('1700', '20', '1033', '0', '0', '0', '0', '0000-00-00'),
('1701', '21', '1033', '0', '0', '0', '0', '0000-00-00'),
('1702', '22', '1033', '0', '0', '0', '0', '0000-00-00'),
('1703', '23', '1033', '0', '0', '0', '0', '0000-00-00'),
('1704', '24', '1033', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1705', '1', '1034', '0', '0', '0', '0', '0000-00-00'),
('1706', '2', '1034', '0', '0', '0', '0', '0000-00-00'),
('1707', '3', '1034', '0', '0', '0', '0', '0000-00-00'),
('1708', '4', '1034', '0', '0', '0', '0', '0000-00-00'),
('1709', '5', '1034', '0', '0', '0', '0', '0000-00-00'),
('1710', '6', '1034', '0', '0', '0', '0', '0000-00-00'),
('1711', '7', '1034', '0', '0', '0', '0', '0000-00-00'),
('1712', '8', '1034', '0', '0', '0', '0', '0000-00-00'),
('1713', '9', '1034', '0', '0', '0', '0', '0000-00-00'),
('1714', '10', '1034', '0', '0', '0', '0', '0000-00-00'),
('1715', '11', '1034', '0', '0', '0', '0', '0000-00-00'),
('1716', '12', '1034', '0', '0', '0', '0', '0000-00-00'),
('1717', '13', '1034', '0', '0', '0', '0', '0000-00-00'),
('1718', '14', '1034', '0', '0', '0', '0', '0000-00-00'),
('1719', '15', '1034', '0', '0', '0', '0', '0000-00-00'),
('1720', '16', '1034', '0', '0', '0', '0', '0000-00-00'),
('1721', '17', '1034', '0', '0', '0', '0', '0000-00-00'),
('1722', '18', '1034', '0', '0', '0', '0', '0000-00-00'),
('1723', '19', '1034', '0', '0', '0', '0', '0000-00-00'),
('1724', '20', '1034', '0', '0', '0', '0', '0000-00-00'),
('1725', '21', '1034', '0', '0', '0', '0', '0000-00-00'),
('1726', '22', '1034', '0', '0', '0', '0', '0000-00-00'),
('1727', '23', '1034', '0', '0', '0', '0', '0000-00-00'),
('1728', '24', '1034', '0', '0', '0', '0', '0000-00-00'),
('1729', '1', '1035', '0', '0', '0', '0', '0000-00-00'),
('1730', '2', '1035', '0', '0', '0', '0', '0000-00-00'),
('1731', '3', '1035', '0', '0', '0', '0', '0000-00-00'),
('1732', '4', '1035', '0', '0', '0', '0', '0000-00-00'),
('1733', '5', '1035', '0', '0', '0', '0', '0000-00-00'),
('1734', '6', '1035', '0', '0', '0', '0', '0000-00-00'),
('1735', '7', '1035', '0', '0', '0', '0', '0000-00-00'),
('1736', '8', '1035', '0', '0', '0', '0', '0000-00-00'),
('1737', '9', '1035', '0', '0', '0', '0', '0000-00-00'),
('1738', '10', '1035', '0', '0', '0', '0', '0000-00-00'),
('1739', '11', '1035', '0', '0', '0', '0', '0000-00-00'),
('1740', '12', '1035', '0', '0', '0', '0', '0000-00-00'),
('1741', '13', '1035', '0', '0', '0', '0', '0000-00-00'),
('1742', '14', '1035', '0', '0', '0', '0', '0000-00-00'),
('1743', '15', '1035', '0', '0', '0', '0', '0000-00-00'),
('1744', '16', '1035', '0', '0', '0', '0', '0000-00-00'),
('1745', '17', '1035', '0', '0', '0', '0', '0000-00-00'),
('1746', '18', '1035', '0', '0', '0', '0', '0000-00-00'),
('1747', '19', '1035', '0', '0', '0', '0', '0000-00-00'),
('1748', '20', '1035', '0', '0', '0', '0', '0000-00-00'),
('1749', '21', '1035', '0', '0', '0', '0', '0000-00-00'),
('1750', '22', '1035', '0', '0', '0', '0', '0000-00-00'),
('1751', '23', '1035', '0', '0', '0', '0', '0000-00-00'),
('1752', '24', '1035', '0', '0', '0', '0', '0000-00-00'),
('1753', '1', '1036', '0', '0', '0', '0', '0000-00-00'),
('1754', '2', '1036', '0', '0', '0', '0', '0000-00-00'),
('1755', '3', '1036', '0', '0', '0', '0', '0000-00-00'),
('1756', '4', '1036', '0', '0', '0', '0', '0000-00-00'),
('1757', '5', '1036', '0', '0', '0', '0', '0000-00-00'),
('1758', '6', '1036', '0', '0', '0', '0', '0000-00-00'),
('1759', '7', '1036', '0', '0', '0', '0', '0000-00-00'),
('1760', '8', '1036', '0', '0', '0', '0', '0000-00-00'),
('1761', '9', '1036', '0', '0', '0', '0', '0000-00-00'),
('1762', '10', '1036', '0', '0', '0', '0', '0000-00-00'),
('1763', '11', '1036', '0', '0', '0', '0', '0000-00-00'),
('1764', '12', '1036', '0', '0', '0', '0', '0000-00-00'),
('1765', '13', '1036', '0', '0', '0', '0', '0000-00-00'),
('1766', '14', '1036', '0', '0', '0', '0', '0000-00-00'),
('1767', '15', '1036', '0', '0', '0', '0', '0000-00-00'),
('1768', '16', '1036', '0', '0', '0', '0', '0000-00-00'),
('1769', '17', '1036', '0', '0', '0', '0', '0000-00-00'),
('1770', '18', '1036', '0', '0', '0', '0', '0000-00-00'),
('1771', '19', '1036', '0', '0', '0', '0', '0000-00-00'),
('1772', '20', '1036', '0', '0', '0', '0', '0000-00-00'),
('1773', '21', '1036', '0', '0', '0', '0', '0000-00-00'),
('1774', '22', '1036', '0', '0', '0', '0', '0000-00-00'),
('1775', '23', '1036', '0', '0', '0', '0', '0000-00-00'),
('1776', '24', '1036', '0', '0', '0', '0', '0000-00-00'),
('1777', '1', '1037', '0', '0', '0', '0', '0000-00-00'),
('1778', '2', '1037', '0', '0', '0', '0', '0000-00-00'),
('1779', '3', '1037', '0', '0', '0', '0', '0000-00-00'),
('1780', '4', '1037', '0', '0', '0', '0', '0000-00-00'),
('1781', '5', '1037', '0', '0', '0', '0', '0000-00-00'),
('1782', '6', '1037', '0', '0', '0', '0', '0000-00-00'),
('1783', '7', '1037', '0', '0', '0', '0', '0000-00-00'),
('1784', '8', '1037', '0', '0', '0', '0', '0000-00-00'),
('1785', '9', '1037', '0', '0', '0', '0', '0000-00-00'),
('1786', '10', '1037', '0', '0', '0', '0', '0000-00-00'),
('1787', '11', '1037', '0', '0', '0', '0', '0000-00-00'),
('1788', '12', '1037', '0', '0', '0', '0', '0000-00-00'),
('1789', '13', '1037', '0', '0', '0', '0', '0000-00-00'),
('1790', '14', '1037', '0', '0', '0', '0', '0000-00-00'),
('1791', '15', '1037', '0', '0', '0', '0', '0000-00-00'),
('1792', '16', '1037', '0', '0', '0', '0', '0000-00-00'),
('1793', '17', '1037', '0', '0', '0', '0', '0000-00-00'),
('1794', '18', '1037', '0', '0', '0', '0', '0000-00-00'),
('1795', '19', '1037', '0', '0', '0', '0', '0000-00-00'),
('1796', '20', '1037', '0', '0', '0', '0', '0000-00-00'),
('1797', '21', '1037', '0', '0', '0', '0', '0000-00-00'),
('1798', '22', '1037', '0', '0', '0', '0', '0000-00-00'),
('1799', '23', '1037', '0', '0', '0', '0', '0000-00-00'),
('1800', '24', '1037', '0', '0', '0', '0', '0000-00-00'),
('1801', '1', '1038', '0', '0', '0', '0', '0000-00-00'),
('1802', '2', '1038', '0', '0', '0', '0', '0000-00-00'),
('1803', '3', '1038', '0', '0', '0', '0', '0000-00-00'),
('1804', '4', '1038', '0', '0', '0', '0', '0000-00-00'),
('1805', '5', '1038', '0', '0', '0', '0', '0000-00-00'),
('1806', '6', '1038', '0', '0', '0', '0', '0000-00-00'),
('1807', '7', '1038', '0', '0', '0', '0', '0000-00-00'),
('1808', '8', '1038', '0', '0', '0', '0', '0000-00-00'),
('1809', '9', '1038', '0', '0', '0', '0', '0000-00-00'),
('1810', '10', '1038', '0', '0', '0', '0', '0000-00-00'),
('1811', '11', '1038', '0', '0', '0', '0', '0000-00-00'),
('1812', '12', '1038', '0', '0', '0', '0', '0000-00-00'),
('1813', '13', '1038', '0', '0', '0', '0', '0000-00-00'),
('1814', '14', '1038', '0', '0', '0', '0', '0000-00-00'),
('1815', '15', '1038', '0', '0', '0', '0', '0000-00-00'),
('1816', '16', '1038', '0', '0', '0', '0', '0000-00-00'),
('1817', '17', '1038', '0', '0', '0', '0', '0000-00-00'),
('1818', '18', '1038', '0', '0', '0', '0', '0000-00-00'),
('1819', '19', '1038', '0', '0', '0', '0', '0000-00-00'),
('1820', '20', '1038', '0', '0', '0', '0', '0000-00-00'),
('1821', '21', '1038', '0', '0', '0', '0', '0000-00-00'),
('1822', '22', '1038', '0', '0', '0', '0', '0000-00-00'),
('1823', '23', '1038', '0', '0', '0', '0', '0000-00-00'),
('1824', '24', '1038', '0', '0', '0', '0', '0000-00-00'),
('1825', '1', '1039', '0', '0', '0', '0', '0000-00-00'),
('1826', '2', '1039', '0', '0', '0', '0', '0000-00-00'),
('1827', '3', '1039', '0', '0', '0', '0', '0000-00-00'),
('1828', '4', '1039', '0', '0', '0', '0', '0000-00-00'),
('1829', '5', '1039', '0', '0', '0', '0', '0000-00-00'),
('1830', '6', '1039', '0', '0', '0', '0', '0000-00-00'),
('1831', '7', '1039', '0', '0', '0', '0', '0000-00-00'),
('1832', '8', '1039', '0', '0', '0', '0', '0000-00-00'),
('1833', '9', '1039', '0', '0', '0', '0', '0000-00-00'),
('1834', '10', '1039', '0', '0', '0', '0', '0000-00-00'),
('1835', '11', '1039', '0', '0', '0', '0', '0000-00-00'),
('1836', '12', '1039', '0', '0', '0', '0', '0000-00-00'),
('1837', '13', '1039', '0', '0', '0', '0', '0000-00-00'),
('1838', '14', '1039', '0', '0', '0', '0', '0000-00-00'),
('1839', '15', '1039', '0', '0', '0', '0', '0000-00-00'),
('1840', '16', '1039', '0', '0', '0', '0', '0000-00-00'),
('1841', '17', '1039', '0', '0', '0', '0', '0000-00-00'),
('1842', '18', '1039', '0', '0', '0', '0', '0000-00-00'),
('1843', '19', '1039', '0', '0', '0', '0', '0000-00-00'),
('1844', '20', '1039', '0', '0', '0', '0', '0000-00-00'),
('1845', '21', '1039', '0', '0', '0', '0', '0000-00-00'),
('1846', '22', '1039', '0', '0', '0', '0', '0000-00-00'),
('1847', '23', '1039', '0', '0', '0', '0', '0000-00-00'),
('1848', '24', '1039', '0', '0', '0', '0', '0000-00-00'),
('1849', '1', '1040', '0', '0', '0', '0', '0000-00-00'),
('1850', '2', '1040', '0', '0', '0', '0', '0000-00-00'),
('1851', '3', '1040', '0', '0', '0', '0', '0000-00-00'),
('1852', '4', '1040', '0', '0', '0', '0', '0000-00-00'),
('1853', '5', '1040', '0', '0', '0', '0', '0000-00-00'),
('1854', '6', '1040', '0', '0', '0', '0', '0000-00-00'),
('1855', '7', '1040', '0', '0', '0', '0', '0000-00-00'),
('1856', '8', '1040', '0', '0', '0', '0', '0000-00-00'),
('1857', '9', '1040', '0', '0', '0', '0', '0000-00-00'),
('1858', '10', '1040', '0', '0', '0', '0', '0000-00-00'),
('1859', '11', '1040', '0', '0', '0', '0', '0000-00-00'),
('1860', '12', '1040', '0', '0', '0', '0', '0000-00-00'),
('1861', '13', '1040', '0', '0', '0', '0', '0000-00-00'),
('1862', '14', '1040', '0', '0', '0', '0', '0000-00-00'),
('1863', '15', '1040', '0', '0', '0', '0', '0000-00-00'),
('1864', '16', '1040', '0', '0', '0', '0', '0000-00-00'),
('1865', '17', '1040', '0', '0', '0', '0', '0000-00-00'),
('1866', '18', '1040', '0', '0', '0', '0', '0000-00-00'),
('1867', '19', '1040', '0', '0', '0', '0', '0000-00-00'),
('1868', '20', '1040', '0', '0', '0', '0', '0000-00-00'),
('1869', '21', '1040', '0', '0', '0', '0', '0000-00-00'),
('1870', '22', '1040', '0', '0', '0', '0', '0000-00-00'),
('1871', '23', '1040', '0', '0', '0', '0', '0000-00-00'),
('1872', '24', '1040', '0', '0', '0', '0', '0000-00-00'),
('1873', '1', '1041', '0', '0', '0', '0', '0000-00-00'),
('1874', '2', '1041', '0', '0', '0', '0', '0000-00-00'),
('1875', '3', '1041', '0', '0', '0', '0', '0000-00-00'),
('1876', '4', '1041', '0', '0', '0', '0', '0000-00-00'),
('1877', '5', '1041', '0', '0', '0', '0', '0000-00-00'),
('1878', '6', '1041', '0', '0', '0', '0', '0000-00-00'),
('1879', '7', '1041', '0', '0', '0', '0', '0000-00-00'),
('1880', '8', '1041', '0', '0', '0', '0', '0000-00-00'),
('1881', '9', '1041', '0', '0', '0', '0', '0000-00-00'),
('1882', '10', '1041', '0', '0', '0', '0', '0000-00-00'),
('1883', '11', '1041', '0', '0', '0', '0', '0000-00-00'),
('1884', '12', '1041', '0', '0', '0', '0', '0000-00-00'),
('1885', '13', '1041', '0', '0', '0', '0', '0000-00-00'),
('1886', '14', '1041', '0', '0', '0', '0', '0000-00-00'),
('1887', '15', '1041', '0', '0', '0', '0', '0000-00-00'),
('1888', '16', '1041', '0', '0', '0', '0', '0000-00-00'),
('1889', '17', '1041', '0', '0', '0', '0', '0000-00-00'),
('1890', '18', '1041', '0', '0', '0', '0', '0000-00-00'),
('1891', '19', '1041', '0', '0', '0', '0', '0000-00-00'),
('1892', '20', '1041', '0', '0', '0', '0', '0000-00-00'),
('1893', '21', '1041', '0', '0', '0', '0', '0000-00-00'),
('1894', '22', '1041', '0', '0', '0', '0', '0000-00-00'),
('1895', '23', '1041', '0', '0', '0', '0', '0000-00-00'),
('1896', '24', '1041', '0', '0', '0', '0', '0000-00-00'),
('1897', '1', '1042', '0', '0', '0', '0', '0000-00-00'),
('1898', '2', '1042', '0', '0', '0', '0', '0000-00-00'),
('1899', '3', '1042', '0', '0', '0', '0', '0000-00-00'),
('1900', '4', '1042', '0', '0', '0', '0', '0000-00-00'),
('1901', '5', '1042', '0', '0', '0', '0', '0000-00-00'),
('1902', '6', '1042', '0', '0', '0', '0', '0000-00-00'),
('1903', '7', '1042', '0', '0', '0', '0', '0000-00-00'),
('1904', '8', '1042', '0', '0', '0', '0', '0000-00-00'),
('1905', '9', '1042', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('1906', '10', '1042', '0', '0', '0', '0', '0000-00-00'),
('1907', '11', '1042', '0', '0', '0', '0', '0000-00-00'),
('1908', '12', '1042', '0', '0', '0', '0', '0000-00-00'),
('1909', '13', '1042', '0', '0', '0', '0', '0000-00-00'),
('1910', '14', '1042', '0', '0', '0', '0', '0000-00-00'),
('1911', '15', '1042', '0', '0', '0', '0', '0000-00-00'),
('1912', '16', '1042', '0', '0', '0', '0', '0000-00-00'),
('1913', '17', '1042', '0', '0', '0', '0', '0000-00-00'),
('1914', '18', '1042', '0', '0', '0', '0', '0000-00-00'),
('1915', '19', '1042', '0', '0', '0', '0', '0000-00-00'),
('1916', '20', '1042', '0', '0', '0', '0', '0000-00-00'),
('1917', '21', '1042', '0', '0', '0', '0', '0000-00-00'),
('1918', '22', '1042', '0', '0', '0', '0', '0000-00-00'),
('1919', '23', '1042', '0', '0', '0', '0', '0000-00-00'),
('1920', '24', '1042', '0', '0', '0', '0', '0000-00-00'),
('1921', '1', '1043', '0', '0', '0', '0', '0000-00-00'),
('1922', '2', '1043', '0', '0', '0', '0', '0000-00-00'),
('1923', '3', '1043', '0', '0', '0', '0', '0000-00-00'),
('1924', '4', '1043', '0', '0', '0', '0', '0000-00-00'),
('1925', '5', '1043', '0', '0', '0', '0', '0000-00-00'),
('1926', '6', '1043', '0', '0', '0', '0', '0000-00-00'),
('1927', '7', '1043', '0', '0', '0', '0', '0000-00-00'),
('1928', '8', '1043', '0', '0', '0', '0', '0000-00-00'),
('1929', '9', '1043', '0', '0', '0', '0', '0000-00-00'),
('1930', '10', '1043', '0', '0', '0', '0', '0000-00-00'),
('1931', '11', '1043', '0', '0', '0', '0', '0000-00-00'),
('1932', '12', '1043', '0', '0', '0', '0', '0000-00-00'),
('1933', '13', '1043', '0', '0', '0', '0', '0000-00-00'),
('1934', '14', '1043', '0', '0', '0', '0', '0000-00-00'),
('1935', '15', '1043', '0', '0', '0', '0', '0000-00-00'),
('1936', '16', '1043', '0', '0', '0', '0', '0000-00-00'),
('1937', '17', '1043', '0', '0', '0', '0', '0000-00-00'),
('1938', '18', '1043', '0', '0', '0', '0', '0000-00-00'),
('1939', '19', '1043', '0', '0', '0', '0', '0000-00-00'),
('1940', '20', '1043', '0', '0', '0', '0', '0000-00-00'),
('1941', '21', '1043', '0', '0', '0', '0', '0000-00-00'),
('1942', '22', '1043', '0', '0', '0', '0', '0000-00-00'),
('1943', '23', '1043', '0', '0', '0', '0', '0000-00-00'),
('1944', '24', '1043', '0', '0', '0', '0', '0000-00-00'),
('1945', '1', '1044', '0', '0', '0', '0', '0000-00-00'),
('1946', '2', '1044', '0', '0', '0', '0', '0000-00-00'),
('1947', '3', '1044', '0', '0', '0', '0', '0000-00-00'),
('1948', '4', '1044', '0', '0', '0', '0', '0000-00-00'),
('1949', '5', '1044', '0', '0', '0', '0', '0000-00-00'),
('1950', '6', '1044', '0', '0', '0', '0', '0000-00-00'),
('1951', '7', '1044', '0', '0', '0', '0', '0000-00-00'),
('1952', '8', '1044', '0', '0', '0', '0', '0000-00-00'),
('1953', '9', '1044', '0', '0', '0', '0', '0000-00-00'),
('1954', '10', '1044', '0', '0', '0', '0', '0000-00-00'),
('1955', '11', '1044', '0', '0', '0', '0', '0000-00-00'),
('1956', '12', '1044', '0', '0', '0', '0', '0000-00-00'),
('1957', '13', '1044', '0', '0', '0', '0', '0000-00-00'),
('1958', '14', '1044', '0', '0', '0', '0', '0000-00-00'),
('1959', '15', '1044', '0', '0', '0', '0', '0000-00-00'),
('1960', '16', '1044', '0', '0', '0', '0', '0000-00-00'),
('1961', '17', '1044', '0', '0', '0', '0', '0000-00-00'),
('1962', '18', '1044', '0', '0', '0', '0', '0000-00-00'),
('1963', '19', '1044', '0', '0', '0', '0', '0000-00-00'),
('1964', '20', '1044', '0', '0', '0', '0', '0000-00-00'),
('1965', '21', '1044', '0', '0', '0', '0', '0000-00-00'),
('1966', '22', '1044', '0', '0', '0', '0', '0000-00-00'),
('1967', '23', '1044', '0', '0', '0', '0', '0000-00-00'),
('1968', '24', '1044', '0', '0', '0', '0', '0000-00-00'),
('1969', '1', '1045', '0', '0', '0', '0', '0000-00-00'),
('1970', '2', '1045', '0', '0', '0', '0', '0000-00-00'),
('1971', '3', '1045', '0', '0', '0', '0', '0000-00-00'),
('1972', '4', '1045', '0', '0', '0', '0', '0000-00-00'),
('1973', '5', '1045', '0', '0', '0', '0', '0000-00-00'),
('1974', '6', '1045', '0', '0', '0', '0', '0000-00-00'),
('1975', '7', '1045', '0', '0', '0', '0', '0000-00-00'),
('1976', '8', '1045', '0', '0', '0', '0', '0000-00-00'),
('1977', '9', '1045', '0', '0', '0', '0', '0000-00-00'),
('1978', '10', '1045', '0', '0', '0', '0', '0000-00-00'),
('1979', '11', '1045', '0', '0', '0', '0', '0000-00-00'),
('1980', '12', '1045', '0', '0', '0', '0', '0000-00-00'),
('1981', '13', '1045', '0', '0', '0', '0', '0000-00-00'),
('1982', '14', '1045', '0', '0', '0', '0', '0000-00-00'),
('1983', '15', '1045', '0', '0', '0', '0', '0000-00-00'),
('1984', '16', '1045', '0', '0', '0', '0', '0000-00-00'),
('1985', '17', '1045', '0', '0', '0', '0', '0000-00-00'),
('1986', '18', '1045', '0', '0', '0', '0', '0000-00-00'),
('1987', '19', '1045', '0', '0', '0', '0', '0000-00-00'),
('1988', '20', '1045', '0', '0', '0', '0', '0000-00-00'),
('1989', '21', '1045', '0', '0', '0', '0', '0000-00-00'),
('1990', '22', '1045', '0', '0', '0', '0', '0000-00-00'),
('1991', '23', '1045', '0', '0', '0', '0', '0000-00-00'),
('1992', '24', '1045', '0', '0', '0', '0', '0000-00-00'),
('1993', '1', '1046', '0', '0', '0', '0', '0000-00-00'),
('1994', '2', '1046', '0', '0', '0', '0', '0000-00-00'),
('1995', '3', '1046', '0', '0', '0', '0', '0000-00-00'),
('1996', '4', '1046', '0', '0', '0', '0', '0000-00-00'),
('1997', '5', '1046', '0', '0', '0', '0', '0000-00-00'),
('1998', '6', '1046', '0', '0', '0', '0', '0000-00-00'),
('1999', '7', '1046', '0', '0', '0', '0', '0000-00-00'),
('2000', '8', '1046', '0', '0', '0', '0', '0000-00-00'),
('2001', '9', '1046', '0', '0', '0', '0', '0000-00-00'),
('2002', '10', '1046', '0', '0', '0', '0', '0000-00-00'),
('2003', '11', '1046', '0', '0', '0', '0', '0000-00-00'),
('2004', '12', '1046', '0', '0', '0', '0', '0000-00-00'),
('2005', '13', '1046', '0', '0', '0', '0', '0000-00-00'),
('2006', '14', '1046', '0', '0', '0', '0', '0000-00-00'),
('2007', '15', '1046', '0', '0', '0', '0', '0000-00-00'),
('2008', '16', '1046', '0', '0', '0', '0', '0000-00-00'),
('2009', '17', '1046', '0', '0', '0', '0', '0000-00-00'),
('2010', '18', '1046', '0', '0', '0', '0', '0000-00-00'),
('2011', '19', '1046', '0', '0', '0', '0', '0000-00-00'),
('2012', '20', '1046', '0', '0', '0', '0', '0000-00-00'),
('2013', '21', '1046', '0', '0', '0', '0', '0000-00-00'),
('2014', '22', '1046', '0', '0', '0', '0', '0000-00-00'),
('2015', '23', '1046', '0', '0', '0', '0', '0000-00-00'),
('2016', '24', '1046', '0', '0', '0', '0', '0000-00-00'),
('2017', '1', '1047', '0', '0', '0', '0', '0000-00-00'),
('2018', '2', '1047', '0', '0', '0', '0', '0000-00-00'),
('2019', '3', '1047', '0', '0', '0', '0', '0000-00-00'),
('2020', '4', '1047', '0', '0', '0', '0', '0000-00-00'),
('2021', '5', '1047', '0', '0', '0', '0', '0000-00-00'),
('2022', '6', '1047', '0', '0', '0', '0', '0000-00-00'),
('2023', '7', '1047', '0', '0', '0', '0', '0000-00-00'),
('2024', '8', '1047', '0', '0', '0', '0', '0000-00-00'),
('2025', '9', '1047', '0', '0', '0', '0', '0000-00-00'),
('2026', '10', '1047', '0', '0', '0', '0', '0000-00-00'),
('2027', '11', '1047', '0', '0', '0', '0', '0000-00-00'),
('2028', '12', '1047', '0', '0', '0', '0', '0000-00-00'),
('2029', '13', '1047', '0', '0', '0', '0', '0000-00-00'),
('2030', '14', '1047', '0', '0', '0', '0', '0000-00-00'),
('2031', '15', '1047', '0', '0', '0', '0', '0000-00-00'),
('2032', '16', '1047', '0', '0', '0', '0', '0000-00-00'),
('2033', '17', '1047', '0', '0', '0', '0', '0000-00-00'),
('2034', '18', '1047', '0', '0', '0', '0', '0000-00-00'),
('2035', '19', '1047', '0', '0', '0', '0', '0000-00-00'),
('2036', '20', '1047', '0', '0', '0', '0', '0000-00-00'),
('2037', '21', '1047', '0', '0', '0', '0', '0000-00-00'),
('2038', '22', '1047', '0', '0', '0', '0', '0000-00-00'),
('2039', '23', '1047', '0', '0', '0', '0', '0000-00-00'),
('2040', '24', '1047', '0', '0', '0', '0', '0000-00-00'),
('2041', '1', '1048', '0', '0', '0', '0', '0000-00-00'),
('2042', '2', '1048', '0', '0', '0', '0', '0000-00-00'),
('2043', '3', '1048', '0', '0', '0', '0', '0000-00-00'),
('2044', '4', '1048', '0', '0', '0', '0', '0000-00-00'),
('2045', '5', '1048', '0', '0', '0', '0', '0000-00-00'),
('2046', '6', '1048', '0', '0', '0', '0', '0000-00-00'),
('2047', '7', '1048', '0', '0', '0', '0', '0000-00-00'),
('2048', '8', '1048', '0', '0', '0', '0', '0000-00-00'),
('2049', '9', '1048', '0', '0', '0', '0', '0000-00-00'),
('2050', '10', '1048', '0', '0', '0', '0', '0000-00-00'),
('2051', '11', '1048', '0', '0', '0', '0', '0000-00-00'),
('2052', '12', '1048', '0', '0', '0', '0', '0000-00-00'),
('2053', '13', '1048', '0', '0', '0', '0', '0000-00-00'),
('2054', '14', '1048', '0', '0', '0', '0', '0000-00-00'),
('2055', '15', '1048', '0', '0', '0', '0', '0000-00-00'),
('2056', '16', '1048', '0', '0', '0', '0', '0000-00-00'),
('2057', '17', '1048', '0', '0', '0', '0', '0000-00-00'),
('2058', '18', '1048', '0', '0', '0', '0', '0000-00-00'),
('2059', '19', '1048', '0', '0', '0', '0', '0000-00-00'),
('2060', '20', '1048', '0', '0', '0', '0', '0000-00-00'),
('2061', '21', '1048', '0', '0', '0', '0', '0000-00-00'),
('2062', '22', '1048', '0', '0', '0', '0', '0000-00-00'),
('2063', '23', '1048', '0', '0', '0', '0', '0000-00-00'),
('2064', '24', '1048', '0', '0', '0', '0', '0000-00-00'),
('2065', '1', '1049', '0', '0', '0', '0', '0000-00-00'),
('2066', '2', '1049', '0', '0', '0', '0', '0000-00-00'),
('2067', '3', '1049', '0', '0', '0', '0', '0000-00-00'),
('2068', '4', '1049', '0', '0', '0', '0', '0000-00-00'),
('2069', '5', '1049', '0', '0', '0', '0', '0000-00-00'),
('2070', '6', '1049', '0', '0', '0', '0', '0000-00-00'),
('2071', '7', '1049', '0', '0', '0', '0', '0000-00-00'),
('2072', '8', '1049', '0', '0', '0', '0', '0000-00-00'),
('2073', '9', '1049', '0', '0', '0', '0', '0000-00-00'),
('2074', '10', '1049', '0', '0', '0', '0', '0000-00-00'),
('2075', '11', '1049', '0', '0', '0', '0', '0000-00-00'),
('2076', '12', '1049', '0', '0', '0', '0', '0000-00-00'),
('2077', '13', '1049', '0', '0', '0', '0', '0000-00-00'),
('2078', '14', '1049', '0', '0', '0', '0', '0000-00-00'),
('2079', '15', '1049', '0', '0', '0', '0', '0000-00-00'),
('2080', '16', '1049', '0', '0', '0', '0', '0000-00-00'),
('2081', '17', '1049', '0', '0', '0', '0', '0000-00-00'),
('2082', '18', '1049', '0', '0', '0', '0', '0000-00-00'),
('2083', '19', '1049', '0', '0', '0', '0', '0000-00-00'),
('2084', '20', '1049', '0', '0', '0', '0', '0000-00-00'),
('2085', '21', '1049', '0', '0', '0', '0', '0000-00-00'),
('2086', '22', '1049', '0', '0', '0', '0', '0000-00-00'),
('2087', '23', '1049', '0', '0', '0', '0', '0000-00-00'),
('2088', '24', '1049', '0', '0', '0', '0', '0000-00-00'),
('2089', '1', '1050', '0', '0', '0', '0', '0000-00-00'),
('2090', '2', '1050', '0', '0', '0', '0', '0000-00-00'),
('2091', '3', '1050', '0', '0', '0', '0', '0000-00-00'),
('2092', '4', '1050', '0', '0', '0', '0', '0000-00-00'),
('2093', '5', '1050', '0', '0', '0', '0', '0000-00-00'),
('2094', '6', '1050', '0', '0', '0', '0', '0000-00-00'),
('2095', '7', '1050', '0', '0', '0', '0', '0000-00-00'),
('2096', '8', '1050', '0', '0', '0', '0', '0000-00-00'),
('2097', '9', '1050', '0', '0', '0', '0', '0000-00-00'),
('2098', '10', '1050', '0', '0', '0', '0', '0000-00-00'),
('2099', '11', '1050', '0', '0', '0', '0', '0000-00-00'),
('2100', '12', '1050', '0', '0', '0', '0', '0000-00-00'),
('2101', '13', '1050', '0', '0', '0', '0', '0000-00-00'),
('2102', '14', '1050', '0', '0', '0', '0', '0000-00-00'),
('2103', '15', '1050', '0', '0', '0', '0', '0000-00-00'),
('2104', '16', '1050', '0', '0', '0', '0', '0000-00-00'),
('2105', '17', '1050', '0', '0', '0', '0', '0000-00-00'),
('2106', '18', '1050', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('2107', '19', '1050', '0', '0', '0', '0', '0000-00-00'),
('2108', '20', '1050', '0', '0', '0', '0', '0000-00-00'),
('2109', '21', '1050', '0', '0', '0', '0', '0000-00-00'),
('2110', '22', '1050', '0', '0', '0', '0', '0000-00-00'),
('2111', '23', '1050', '0', '0', '0', '0', '0000-00-00'),
('2112', '24', '1050', '0', '0', '0', '0', '0000-00-00'),
('2113', '1', '1051', '0', '0', '0', '0', '0000-00-00'),
('2114', '2', '1051', '0', '0', '0', '0', '0000-00-00'),
('2115', '3', '1051', '0', '0', '0', '0', '0000-00-00'),
('2116', '4', '1051', '0', '0', '0', '0', '0000-00-00'),
('2117', '5', '1051', '0', '0', '0', '0', '0000-00-00'),
('2118', '6', '1051', '0', '0', '0', '0', '0000-00-00'),
('2119', '7', '1051', '0', '0', '0', '0', '0000-00-00'),
('2120', '8', '1051', '0', '0', '0', '0', '0000-00-00'),
('2121', '9', '1051', '0', '0', '0', '0', '0000-00-00'),
('2122', '10', '1051', '0', '0', '0', '0', '0000-00-00'),
('2123', '11', '1051', '0', '0', '0', '0', '0000-00-00'),
('2124', '12', '1051', '0', '0', '0', '0', '0000-00-00'),
('2125', '13', '1051', '0', '0', '0', '0', '0000-00-00'),
('2126', '14', '1051', '0', '0', '0', '0', '0000-00-00'),
('2127', '15', '1051', '0', '0', '0', '0', '0000-00-00'),
('2128', '16', '1051', '0', '0', '0', '0', '0000-00-00'),
('2129', '17', '1051', '0', '0', '0', '0', '0000-00-00'),
('2130', '18', '1051', '0', '0', '0', '0', '0000-00-00'),
('2131', '19', '1051', '0', '0', '0', '0', '0000-00-00'),
('2132', '20', '1051', '0', '0', '0', '0', '0000-00-00'),
('2133', '21', '1051', '0', '0', '0', '0', '0000-00-00'),
('2134', '22', '1051', '0', '0', '0', '0', '0000-00-00'),
('2135', '23', '1051', '0', '0', '0', '0', '0000-00-00'),
('2136', '24', '1051', '0', '0', '0', '0', '0000-00-00'),
('2137', '1', '1052', '0', '0', '0', '0', '0000-00-00'),
('2138', '2', '1052', '0', '0', '0', '0', '0000-00-00'),
('2139', '3', '1052', '0', '0', '0', '0', '0000-00-00'),
('2140', '4', '1052', '0', '0', '0', '0', '0000-00-00'),
('2141', '5', '1052', '0', '0', '0', '0', '0000-00-00'),
('2142', '6', '1052', '0', '0', '0', '0', '0000-00-00'),
('2143', '7', '1052', '0', '0', '0', '0', '0000-00-00'),
('2144', '8', '1052', '0', '0', '0', '0', '0000-00-00'),
('2145', '9', '1052', '0', '0', '0', '0', '0000-00-00'),
('2146', '10', '1052', '0', '0', '0', '0', '0000-00-00'),
('2147', '11', '1052', '0', '0', '0', '0', '0000-00-00'),
('2148', '12', '1052', '0', '0', '0', '0', '0000-00-00'),
('2149', '13', '1052', '0', '0', '0', '0', '0000-00-00'),
('2150', '14', '1052', '0', '0', '0', '0', '0000-00-00'),
('2151', '15', '1052', '0', '0', '0', '0', '0000-00-00'),
('2152', '16', '1052', '0', '0', '0', '0', '0000-00-00'),
('2153', '17', '1052', '0', '0', '0', '0', '0000-00-00'),
('2154', '18', '1052', '0', '0', '0', '0', '0000-00-00'),
('2155', '19', '1052', '0', '0', '0', '0', '0000-00-00'),
('2156', '20', '1052', '0', '0', '0', '0', '0000-00-00'),
('2157', '21', '1052', '0', '0', '0', '0', '0000-00-00'),
('2158', '22', '1052', '0', '0', '0', '0', '0000-00-00'),
('2159', '23', '1052', '0', '0', '0', '0', '0000-00-00'),
('2160', '24', '1052', '0', '0', '0', '0', '0000-00-00'),
('2161', '1', '1053', '0', '0', '0', '0', '0000-00-00'),
('2162', '2', '1053', '0', '0', '0', '0', '0000-00-00'),
('2163', '3', '1053', '0', '0', '0', '0', '0000-00-00'),
('2164', '4', '1053', '0', '0', '0', '0', '0000-00-00'),
('2165', '5', '1053', '0', '0', '0', '0', '0000-00-00'),
('2166', '6', '1053', '0', '0', '0', '0', '0000-00-00'),
('2167', '7', '1053', '0', '0', '0', '0', '0000-00-00'),
('2168', '8', '1053', '0', '0', '0', '0', '0000-00-00'),
('2169', '9', '1053', '0', '0', '0', '0', '0000-00-00'),
('2170', '10', '1053', '0', '0', '0', '0', '0000-00-00'),
('2171', '11', '1053', '0', '0', '0', '0', '0000-00-00'),
('2172', '12', '1053', '0', '0', '0', '0', '0000-00-00'),
('2173', '13', '1053', '0', '0', '0', '0', '0000-00-00'),
('2174', '14', '1053', '0', '0', '0', '0', '0000-00-00'),
('2175', '15', '1053', '0', '0', '0', '0', '0000-00-00'),
('2176', '16', '1053', '0', '0', '0', '0', '0000-00-00'),
('2177', '17', '1053', '0', '0', '0', '0', '0000-00-00'),
('2178', '18', '1053', '0', '0', '0', '0', '0000-00-00'),
('2179', '19', '1053', '0', '0', '0', '0', '0000-00-00'),
('2180', '20', '1053', '0', '0', '0', '0', '0000-00-00'),
('2181', '21', '1053', '0', '0', '0', '0', '0000-00-00'),
('2182', '22', '1053', '0', '0', '0', '0', '0000-00-00'),
('2183', '23', '1053', '0', '0', '0', '0', '0000-00-00'),
('2184', '24', '1053', '0', '0', '0', '0', '0000-00-00'),
('2185', '1', '1054', '0', '0', '0', '0', '0000-00-00'),
('2186', '2', '1054', '0', '0', '0', '0', '0000-00-00'),
('2187', '3', '1054', '0', '0', '0', '0', '0000-00-00'),
('2188', '4', '1054', '0', '0', '0', '0', '0000-00-00'),
('2189', '5', '1054', '0', '0', '0', '0', '0000-00-00'),
('2190', '6', '1054', '0', '0', '0', '0', '0000-00-00'),
('2191', '7', '1054', '0', '0', '0', '0', '0000-00-00'),
('2192', '8', '1054', '0', '0', '0', '0', '0000-00-00'),
('2193', '9', '1054', '0', '0', '0', '0', '0000-00-00'),
('2194', '10', '1054', '0', '0', '0', '0', '0000-00-00'),
('2195', '11', '1054', '0', '0', '0', '0', '0000-00-00'),
('2196', '12', '1054', '0', '0', '0', '0', '0000-00-00'),
('2197', '13', '1054', '0', '0', '0', '0', '0000-00-00'),
('2198', '14', '1054', '0', '0', '0', '0', '0000-00-00'),
('2199', '15', '1054', '0', '0', '0', '0', '0000-00-00'),
('2200', '16', '1054', '0', '0', '0', '0', '0000-00-00'),
('2201', '17', '1054', '0', '0', '0', '0', '0000-00-00'),
('2202', '18', '1054', '0', '0', '0', '0', '0000-00-00'),
('2203', '19', '1054', '0', '0', '0', '0', '0000-00-00'),
('2204', '20', '1054', '0', '0', '0', '0', '0000-00-00'),
('2205', '21', '1054', '0', '0', '0', '0', '0000-00-00'),
('2206', '22', '1054', '0', '0', '0', '0', '0000-00-00'),
('2207', '23', '1054', '0', '0', '0', '0', '0000-00-00'),
('2208', '24', '1054', '0', '0', '0', '0', '0000-00-00'),
('2209', '1', '1055', '0', '0', '0', '0', '0000-00-00'),
('2210', '2', '1055', '0', '0', '0', '0', '0000-00-00'),
('2211', '3', '1055', '0', '0', '0', '0', '0000-00-00'),
('2212', '4', '1055', '0', '0', '0', '0', '0000-00-00'),
('2213', '5', '1055', '0', '0', '0', '0', '0000-00-00'),
('2214', '6', '1055', '0', '0', '0', '0', '0000-00-00'),
('2215', '7', '1055', '0', '0', '0', '0', '0000-00-00'),
('2216', '8', '1055', '0', '0', '0', '0', '0000-00-00'),
('2217', '9', '1055', '0', '0', '0', '0', '0000-00-00'),
('2218', '10', '1055', '0', '0', '0', '0', '0000-00-00'),
('2219', '11', '1055', '0', '0', '0', '0', '0000-00-00'),
('2220', '12', '1055', '0', '0', '0', '0', '0000-00-00'),
('2221', '13', '1055', '0', '0', '0', '0', '0000-00-00'),
('2222', '14', '1055', '0', '0', '0', '0', '0000-00-00'),
('2223', '15', '1055', '0', '0', '0', '0', '0000-00-00'),
('2224', '16', '1055', '0', '0', '0', '0', '0000-00-00'),
('2225', '17', '1055', '0', '0', '0', '0', '0000-00-00'),
('2226', '18', '1055', '0', '0', '0', '0', '0000-00-00'),
('2227', '19', '1055', '0', '0', '0', '0', '0000-00-00'),
('2228', '20', '1055', '0', '0', '0', '0', '0000-00-00'),
('2229', '21', '1055', '0', '0', '0', '0', '0000-00-00'),
('2230', '22', '1055', '0', '0', '0', '0', '0000-00-00'),
('2231', '23', '1055', '0', '0', '0', '0', '0000-00-00'),
('2232', '24', '1055', '0', '0', '0', '0', '0000-00-00'),
('2233', '1', '1056', '0', '0', '0', '0', '0000-00-00'),
('2234', '2', '1056', '0', '0', '0', '0', '0000-00-00'),
('2235', '3', '1056', '0', '0', '0', '0', '0000-00-00'),
('2236', '4', '1056', '0', '0', '0', '0', '0000-00-00'),
('2237', '5', '1056', '0', '0', '0', '0', '0000-00-00'),
('2238', '6', '1056', '0', '0', '0', '0', '0000-00-00'),
('2239', '7', '1056', '0', '0', '0', '0', '0000-00-00'),
('2240', '8', '1056', '0', '0', '0', '0', '0000-00-00'),
('2241', '9', '1056', '0', '0', '0', '0', '0000-00-00'),
('2242', '10', '1056', '0', '0', '0', '0', '0000-00-00'),
('2243', '11', '1056', '0', '0', '0', '0', '0000-00-00'),
('2244', '12', '1056', '0', '0', '0', '0', '0000-00-00'),
('2245', '13', '1056', '0', '0', '0', '0', '0000-00-00'),
('2246', '14', '1056', '0', '0', '0', '0', '0000-00-00'),
('2247', '15', '1056', '0', '0', '0', '0', '0000-00-00'),
('2248', '16', '1056', '0', '0', '0', '0', '0000-00-00'),
('2249', '17', '1056', '0', '0', '0', '0', '0000-00-00'),
('2250', '18', '1056', '0', '0', '0', '0', '0000-00-00'),
('2251', '19', '1056', '0', '0', '0', '0', '0000-00-00'),
('2252', '20', '1056', '0', '0', '0', '0', '0000-00-00'),
('2253', '21', '1056', '0', '0', '0', '0', '0000-00-00'),
('2254', '22', '1056', '0', '0', '0', '0', '0000-00-00'),
('2255', '23', '1056', '0', '0', '0', '0', '0000-00-00'),
('2256', '24', '1056', '0', '0', '0', '0', '0000-00-00'),
('2257', '1', '1057', '0', '0', '0', '0', '0000-00-00'),
('2258', '2', '1057', '0', '0', '0', '0', '0000-00-00'),
('2259', '3', '1057', '0', '0', '0', '0', '0000-00-00'),
('2260', '4', '1057', '0', '0', '0', '0', '0000-00-00'),
('2261', '5', '1057', '0', '0', '0', '0', '0000-00-00'),
('2262', '6', '1057', '0', '0', '0', '0', '0000-00-00'),
('2263', '7', '1057', '0', '0', '0', '0', '0000-00-00'),
('2264', '8', '1057', '0', '0', '0', '0', '0000-00-00'),
('2265', '9', '1057', '0', '0', '0', '0', '0000-00-00'),
('2266', '10', '1057', '0', '0', '0', '0', '0000-00-00'),
('2267', '11', '1057', '0', '0', '0', '0', '0000-00-00'),
('2268', '12', '1057', '0', '0', '0', '0', '0000-00-00'),
('2269', '13', '1057', '0', '0', '0', '0', '0000-00-00'),
('2270', '14', '1057', '0', '0', '0', '0', '0000-00-00'),
('2271', '15', '1057', '0', '0', '0', '0', '0000-00-00'),
('2272', '16', '1057', '0', '0', '0', '0', '0000-00-00'),
('2273', '17', '1057', '0', '0', '0', '0', '0000-00-00'),
('2274', '18', '1057', '0', '0', '0', '0', '0000-00-00'),
('2275', '19', '1057', '0', '0', '0', '0', '0000-00-00'),
('2276', '20', '1057', '0', '0', '0', '0', '0000-00-00'),
('2277', '21', '1057', '0', '0', '0', '0', '0000-00-00'),
('2278', '22', '1057', '0', '0', '0', '0', '0000-00-00'),
('2279', '23', '1057', '0', '0', '0', '0', '0000-00-00'),
('2280', '24', '1057', '0', '0', '0', '0', '0000-00-00'),
('2281', '1', '1058', '0', '0', '0', '0', '0000-00-00'),
('2282', '2', '1058', '0', '0', '0', '0', '0000-00-00'),
('2283', '3', '1058', '0', '0', '0', '0', '0000-00-00'),
('2284', '4', '1058', '0', '0', '0', '0', '0000-00-00'),
('2285', '5', '1058', '0', '0', '0', '0', '0000-00-00'),
('2286', '6', '1058', '0', '0', '0', '0', '0000-00-00'),
('2287', '7', '1058', '0', '0', '0', '0', '0000-00-00'),
('2288', '8', '1058', '0', '0', '0', '0', '0000-00-00'),
('2289', '9', '1058', '0', '0', '0', '0', '0000-00-00'),
('2290', '10', '1058', '0', '0', '0', '0', '0000-00-00'),
('2291', '11', '1058', '0', '0', '0', '0', '0000-00-00'),
('2292', '12', '1058', '0', '0', '0', '0', '0000-00-00'),
('2293', '13', '1058', '0', '0', '0', '0', '0000-00-00'),
('2294', '14', '1058', '0', '0', '0', '0', '0000-00-00'),
('2295', '15', '1058', '0', '0', '0', '0', '0000-00-00'),
('2296', '16', '1058', '0', '0', '0', '0', '0000-00-00'),
('2297', '17', '1058', '0', '0', '0', '0', '0000-00-00'),
('2298', '18', '1058', '0', '0', '0', '0', '0000-00-00'),
('2299', '19', '1058', '0', '0', '0', '0', '0000-00-00'),
('2300', '20', '1058', '0', '0', '0', '0', '0000-00-00'),
('2301', '21', '1058', '0', '0', '0', '0', '0000-00-00'),
('2302', '22', '1058', '0', '0', '0', '0', '0000-00-00'),
('2303', '23', '1058', '0', '0', '0', '0', '0000-00-00'),
('2304', '24', '1058', '0', '0', '0', '0', '0000-00-00'),
('2305', '1', '1059', '0', '0', '0', '0', '0000-00-00'),
('2306', '2', '1059', '0', '0', '0', '0', '0000-00-00'),
('2307', '3', '1059', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('2308', '4', '1059', '0', '0', '0', '0', '0000-00-00'),
('2309', '5', '1059', '0', '0', '0', '0', '0000-00-00'),
('2310', '6', '1059', '0', '0', '0', '0', '0000-00-00'),
('2311', '7', '1059', '0', '0', '0', '0', '0000-00-00'),
('2312', '8', '1059', '0', '0', '0', '0', '0000-00-00'),
('2313', '9', '1059', '0', '0', '0', '0', '0000-00-00'),
('2314', '10', '1059', '0', '0', '0', '0', '0000-00-00'),
('2315', '11', '1059', '0', '0', '0', '0', '0000-00-00'),
('2316', '12', '1059', '0', '0', '0', '0', '0000-00-00'),
('2317', '13', '1059', '0', '0', '0', '0', '0000-00-00'),
('2318', '14', '1059', '0', '0', '0', '0', '0000-00-00'),
('2319', '15', '1059', '0', '0', '0', '0', '0000-00-00'),
('2320', '16', '1059', '0', '0', '0', '0', '0000-00-00'),
('2321', '17', '1059', '0', '0', '0', '0', '0000-00-00'),
('2322', '18', '1059', '0', '0', '0', '0', '0000-00-00'),
('2323', '19', '1059', '0', '0', '0', '0', '0000-00-00'),
('2324', '20', '1059', '0', '0', '0', '0', '0000-00-00'),
('2325', '21', '1059', '0', '0', '0', '0', '0000-00-00'),
('2326', '22', '1059', '0', '0', '0', '0', '0000-00-00'),
('2327', '23', '1059', '0', '0', '0', '0', '0000-00-00'),
('2328', '24', '1059', '0', '0', '0', '0', '0000-00-00'),
('2329', '1', '1060', '0', '0', '0', '0', '0000-00-00'),
('2330', '2', '1060', '0', '0', '0', '0', '0000-00-00'),
('2331', '3', '1060', '0', '0', '0', '0', '0000-00-00'),
('2332', '4', '1060', '0', '0', '0', '0', '0000-00-00'),
('2333', '5', '1060', '0', '0', '0', '0', '0000-00-00'),
('2334', '6', '1060', '0', '0', '0', '0', '0000-00-00'),
('2335', '7', '1060', '0', '0', '0', '0', '0000-00-00'),
('2336', '8', '1060', '0', '0', '0', '0', '0000-00-00'),
('2337', '9', '1060', '0', '0', '0', '0', '0000-00-00'),
('2338', '10', '1060', '0', '0', '0', '0', '0000-00-00'),
('2339', '11', '1060', '0', '0', '0', '0', '0000-00-00'),
('2340', '12', '1060', '0', '0', '0', '0', '0000-00-00'),
('2341', '13', '1060', '0', '0', '0', '0', '0000-00-00'),
('2342', '14', '1060', '0', '0', '0', '0', '0000-00-00'),
('2343', '15', '1060', '0', '0', '0', '0', '0000-00-00'),
('2344', '16', '1060', '0', '0', '0', '0', '0000-00-00'),
('2345', '17', '1060', '0', '0', '0', '0', '0000-00-00'),
('2346', '18', '1060', '0', '0', '0', '0', '0000-00-00'),
('2347', '19', '1060', '0', '0', '0', '0', '0000-00-00'),
('2348', '20', '1060', '0', '0', '0', '0', '0000-00-00'),
('2349', '21', '1060', '0', '0', '0', '0', '0000-00-00'),
('2350', '22', '1060', '0', '0', '0', '0', '0000-00-00'),
('2351', '23', '1060', '0', '0', '0', '0', '0000-00-00'),
('2352', '24', '1060', '0', '0', '0', '0', '0000-00-00'),
('2353', '1', '1061', '0', '0', '0', '0', '0000-00-00'),
('2354', '2', '1061', '0', '0', '0', '0', '0000-00-00'),
('2355', '3', '1061', '0', '0', '0', '0', '0000-00-00'),
('2356', '4', '1061', '0', '0', '0', '0', '0000-00-00'),
('2357', '5', '1061', '0', '0', '0', '0', '0000-00-00'),
('2358', '6', '1061', '0', '0', '0', '0', '0000-00-00'),
('2359', '7', '1061', '0', '0', '0', '0', '0000-00-00'),
('2360', '8', '1061', '0', '0', '0', '0', '0000-00-00'),
('2361', '9', '1061', '0', '0', '0', '0', '0000-00-00'),
('2362', '10', '1061', '0', '0', '0', '0', '0000-00-00'),
('2363', '11', '1061', '0', '0', '0', '0', '0000-00-00'),
('2364', '12', '1061', '0', '0', '0', '0', '0000-00-00'),
('2365', '13', '1061', '0', '0', '0', '0', '0000-00-00'),
('2366', '14', '1061', '0', '0', '0', '0', '0000-00-00'),
('2367', '15', '1061', '0', '0', '0', '0', '0000-00-00'),
('2368', '16', '1061', '0', '0', '0', '0', '0000-00-00'),
('2369', '17', '1061', '0', '0', '0', '0', '0000-00-00'),
('2370', '18', '1061', '0', '0', '0', '0', '0000-00-00'),
('2371', '19', '1061', '0', '0', '0', '0', '0000-00-00'),
('2372', '20', '1061', '0', '0', '0', '0', '0000-00-00'),
('2373', '21', '1061', '0', '0', '0', '0', '0000-00-00'),
('2374', '22', '1061', '0', '0', '0', '0', '0000-00-00'),
('2375', '23', '1061', '0', '0', '0', '0', '0000-00-00'),
('2376', '24', '1061', '0', '0', '0', '0', '0000-00-00'),
('2377', '1', '1062', '0', '0', '0', '0', '0000-00-00'),
('2378', '2', '1062', '0', '0', '0', '0', '0000-00-00'),
('2379', '3', '1062', '0', '0', '0', '0', '0000-00-00'),
('2380', '4', '1062', '0', '0', '0', '0', '0000-00-00'),
('2381', '5', '1062', '0', '0', '0', '0', '0000-00-00'),
('2382', '6', '1062', '0', '0', '0', '0', '0000-00-00'),
('2383', '7', '1062', '0', '0', '0', '0', '0000-00-00'),
('2384', '8', '1062', '0', '0', '0', '0', '0000-00-00'),
('2385', '9', '1062', '0', '0', '0', '0', '0000-00-00'),
('2386', '10', '1062', '0', '0', '0', '0', '0000-00-00'),
('2387', '11', '1062', '0', '0', '0', '0', '0000-00-00'),
('2388', '12', '1062', '0', '0', '0', '0', '0000-00-00'),
('2389', '13', '1062', '0', '0', '0', '0', '0000-00-00'),
('2390', '14', '1062', '0', '0', '0', '0', '0000-00-00'),
('2391', '15', '1062', '0', '0', '0', '0', '0000-00-00'),
('2392', '16', '1062', '0', '0', '0', '0', '0000-00-00'),
('2393', '17', '1062', '0', '0', '0', '0', '0000-00-00'),
('2394', '18', '1062', '0', '0', '0', '0', '0000-00-00'),
('2395', '19', '1062', '0', '0', '0', '0', '0000-00-00'),
('2396', '20', '1062', '0', '0', '0', '0', '0000-00-00'),
('2397', '21', '1062', '0', '0', '0', '0', '0000-00-00'),
('2398', '22', '1062', '0', '0', '0', '0', '0000-00-00'),
('2399', '23', '1062', '0', '0', '0', '0', '0000-00-00'),
('2400', '24', '1062', '0', '0', '0', '0', '0000-00-00'),
('2401', '1', '1063', '0', '0', '0', '0', '0000-00-00'),
('2402', '2', '1063', '0', '0', '0', '0', '0000-00-00'),
('2403', '3', '1063', '0', '0', '0', '0', '0000-00-00'),
('2404', '4', '1063', '0', '0', '0', '0', '0000-00-00'),
('2405', '5', '1063', '0', '0', '0', '0', '0000-00-00'),
('2406', '6', '1063', '0', '0', '0', '0', '0000-00-00'),
('2407', '7', '1063', '0', '0', '0', '0', '0000-00-00'),
('2408', '8', '1063', '0', '0', '0', '0', '0000-00-00'),
('2409', '9', '1063', '0', '0', '0', '0', '0000-00-00'),
('2410', '10', '1063', '0', '0', '0', '0', '0000-00-00'),
('2411', '11', '1063', '0', '0', '0', '0', '0000-00-00'),
('2412', '12', '1063', '0', '0', '0', '0', '0000-00-00'),
('2413', '13', '1063', '0', '0', '0', '0', '0000-00-00'),
('2414', '14', '1063', '0', '0', '0', '0', '0000-00-00'),
('2415', '15', '1063', '0', '0', '0', '0', '0000-00-00'),
('2416', '16', '1063', '0', '0', '0', '0', '0000-00-00'),
('2417', '17', '1063', '0', '0', '0', '0', '0000-00-00'),
('2418', '18', '1063', '0', '0', '0', '0', '0000-00-00'),
('2419', '19', '1063', '0', '0', '0', '0', '0000-00-00'),
('2420', '20', '1063', '0', '0', '0', '0', '0000-00-00'),
('2421', '21', '1063', '0', '0', '0', '0', '0000-00-00'),
('2422', '22', '1063', '0', '0', '0', '0', '0000-00-00'),
('2423', '23', '1063', '0', '0', '0', '0', '0000-00-00'),
('2424', '24', '1063', '0', '0', '0', '0', '0000-00-00'),
('2425', '1', '1064', '0', '0', '0', '0', '0000-00-00'),
('2426', '2', '1064', '0', '0', '0', '0', '0000-00-00'),
('2427', '3', '1064', '0', '0', '0', '0', '0000-00-00'),
('2428', '4', '1064', '0', '0', '0', '0', '0000-00-00'),
('2429', '5', '1064', '0', '0', '0', '0', '0000-00-00'),
('2430', '6', '1064', '0', '0', '0', '0', '0000-00-00'),
('2431', '7', '1064', '0', '0', '0', '0', '0000-00-00'),
('2432', '8', '1064', '0', '0', '0', '0', '0000-00-00'),
('2433', '9', '1064', '0', '0', '0', '0', '0000-00-00'),
('2434', '10', '1064', '0', '0', '0', '0', '0000-00-00'),
('2435', '11', '1064', '0', '0', '0', '0', '0000-00-00'),
('2436', '12', '1064', '0', '0', '0', '0', '0000-00-00'),
('2437', '13', '1064', '0', '0', '0', '0', '0000-00-00'),
('2438', '14', '1064', '0', '0', '0', '0', '0000-00-00'),
('2439', '15', '1064', '0', '0', '0', '0', '0000-00-00'),
('2440', '16', '1064', '0', '0', '0', '0', '0000-00-00'),
('2441', '17', '1064', '0', '0', '0', '0', '0000-00-00'),
('2442', '18', '1064', '0', '0', '0', '0', '0000-00-00'),
('2443', '19', '1064', '0', '0', '0', '0', '0000-00-00'),
('2444', '20', '1064', '0', '0', '0', '0', '0000-00-00'),
('2445', '21', '1064', '0', '0', '0', '0', '0000-00-00'),
('2446', '22', '1064', '0', '0', '0', '0', '0000-00-00'),
('2447', '23', '1064', '0', '0', '0', '0', '0000-00-00'),
('2448', '24', '1064', '0', '0', '0', '0', '0000-00-00'),
('2449', '1', '1065', '0', '0', '0', '0', '0000-00-00'),
('2450', '2', '1065', '0', '0', '0', '0', '0000-00-00'),
('2451', '3', '1065', '0', '0', '0', '0', '0000-00-00'),
('2452', '4', '1065', '0', '0', '0', '0', '0000-00-00'),
('2453', '5', '1065', '0', '0', '0', '0', '0000-00-00'),
('2454', '6', '1065', '0', '0', '0', '0', '0000-00-00'),
('2455', '7', '1065', '0', '0', '0', '0', '0000-00-00'),
('2456', '8', '1065', '0', '0', '0', '0', '0000-00-00'),
('2457', '9', '1065', '0', '0', '0', '0', '0000-00-00'),
('2458', '10', '1065', '0', '0', '0', '0', '0000-00-00'),
('2459', '11', '1065', '0', '0', '0', '0', '0000-00-00'),
('2460', '12', '1065', '0', '0', '0', '0', '0000-00-00'),
('2461', '13', '1065', '0', '0', '0', '0', '0000-00-00'),
('2462', '14', '1065', '0', '0', '0', '0', '0000-00-00'),
('2463', '15', '1065', '0', '0', '0', '0', '0000-00-00'),
('2464', '16', '1065', '0', '0', '0', '0', '0000-00-00'),
('2465', '17', '1065', '0', '0', '0', '0', '0000-00-00'),
('2466', '18', '1065', '0', '0', '0', '0', '0000-00-00'),
('2467', '19', '1065', '0', '0', '0', '0', '0000-00-00'),
('2468', '20', '1065', '0', '0', '0', '0', '0000-00-00'),
('2469', '21', '1065', '0', '0', '0', '0', '0000-00-00'),
('2470', '22', '1065', '0', '0', '0', '0', '0000-00-00'),
('2471', '23', '1065', '0', '0', '0', '0', '0000-00-00'),
('2472', '24', '1065', '0', '0', '0', '0', '0000-00-00'),
('2473', '1', '1066', '0', '0', '0', '0', '0000-00-00'),
('2474', '2', '1066', '0', '0', '0', '0', '0000-00-00'),
('2475', '3', '1066', '0', '0', '0', '0', '0000-00-00'),
('2476', '4', '1066', '0', '0', '0', '0', '0000-00-00'),
('2477', '5', '1066', '0', '0', '0', '0', '0000-00-00'),
('2478', '6', '1066', '0', '0', '0', '0', '0000-00-00'),
('2479', '7', '1066', '0', '0', '0', '0', '0000-00-00'),
('2480', '8', '1066', '0', '0', '0', '0', '0000-00-00'),
('2481', '9', '1066', '0', '0', '0', '0', '0000-00-00'),
('2482', '10', '1066', '0', '0', '0', '0', '0000-00-00'),
('2483', '11', '1066', '0', '0', '0', '0', '0000-00-00'),
('2484', '12', '1066', '0', '0', '0', '0', '0000-00-00'),
('2485', '13', '1066', '0', '0', '0', '0', '0000-00-00'),
('2486', '14', '1066', '0', '0', '0', '0', '0000-00-00'),
('2487', '15', '1066', '0', '0', '0', '0', '0000-00-00'),
('2488', '16', '1066', '0', '0', '0', '0', '0000-00-00'),
('2489', '17', '1066', '0', '0', '0', '0', '0000-00-00'),
('2490', '18', '1066', '0', '0', '0', '0', '0000-00-00'),
('2491', '19', '1066', '0', '0', '0', '0', '0000-00-00'),
('2492', '20', '1066', '0', '0', '0', '0', '0000-00-00'),
('2493', '21', '1066', '0', '0', '0', '0', '0000-00-00'),
('2494', '22', '1066', '0', '0', '0', '0', '0000-00-00'),
('2495', '23', '1066', '0', '0', '0', '0', '0000-00-00'),
('2496', '24', '1066', '0', '0', '0', '0', '0000-00-00'),
('2497', '1', '1067', '0', '0', '0', '0', '0000-00-00'),
('2498', '2', '1067', '0', '0', '0', '0', '0000-00-00'),
('2499', '3', '1067', '0', '0', '0', '0', '0000-00-00'),
('2500', '4', '1067', '0', '0', '0', '0', '0000-00-00'),
('2501', '5', '1067', '0', '0', '0', '0', '0000-00-00'),
('2502', '6', '1067', '0', '0', '0', '0', '0000-00-00'),
('2503', '7', '1067', '0', '0', '0', '0', '0000-00-00'),
('2504', '8', '1067', '0', '0', '0', '0', '0000-00-00'),
('2505', '9', '1067', '0', '0', '0', '0', '0000-00-00'),
('2506', '10', '1067', '0', '0', '0', '0', '0000-00-00'),
('2507', '11', '1067', '0', '0', '0', '0', '0000-00-00'),
('2508', '12', '1067', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('2509', '13', '1067', '0', '0', '0', '0', '0000-00-00'),
('2510', '14', '1067', '0', '0', '0', '0', '0000-00-00'),
('2511', '15', '1067', '0', '0', '0', '0', '0000-00-00'),
('2512', '16', '1067', '0', '0', '0', '0', '0000-00-00'),
('2513', '17', '1067', '0', '0', '0', '0', '0000-00-00'),
('2514', '18', '1067', '0', '0', '0', '0', '0000-00-00'),
('2515', '19', '1067', '0', '0', '0', '0', '0000-00-00'),
('2516', '20', '1067', '0', '0', '0', '0', '0000-00-00'),
('2517', '21', '1067', '0', '0', '0', '0', '0000-00-00'),
('2518', '22', '1067', '0', '0', '0', '0', '0000-00-00'),
('2519', '23', '1067', '0', '0', '0', '0', '0000-00-00'),
('2520', '24', '1067', '0', '0', '0', '0', '0000-00-00'),
('2521', '1', '1068', '0', '0', '0', '0', '0000-00-00'),
('2522', '2', '1068', '0', '0', '0', '0', '0000-00-00'),
('2523', '3', '1068', '0', '0', '0', '0', '0000-00-00'),
('2524', '4', '1068', '0', '0', '0', '0', '0000-00-00'),
('2525', '5', '1068', '0', '0', '0', '0', '0000-00-00'),
('2526', '6', '1068', '0', '0', '0', '0', '0000-00-00'),
('2527', '7', '1068', '0', '0', '0', '0', '0000-00-00'),
('2528', '8', '1068', '0', '0', '0', '0', '0000-00-00'),
('2529', '9', '1068', '0', '0', '0', '0', '0000-00-00'),
('2530', '10', '1068', '0', '0', '0', '0', '0000-00-00'),
('2531', '11', '1068', '0', '0', '0', '0', '0000-00-00'),
('2532', '12', '1068', '0', '0', '0', '0', '0000-00-00'),
('2533', '13', '1068', '0', '0', '0', '0', '0000-00-00'),
('2534', '14', '1068', '0', '0', '0', '0', '0000-00-00'),
('2535', '15', '1068', '0', '0', '0', '0', '0000-00-00'),
('2536', '16', '1068', '0', '0', '0', '0', '0000-00-00'),
('2537', '17', '1068', '0', '0', '0', '0', '0000-00-00'),
('2538', '18', '1068', '0', '0', '0', '0', '0000-00-00'),
('2539', '19', '1068', '0', '0', '0', '0', '0000-00-00'),
('2540', '20', '1068', '0', '0', '0', '0', '0000-00-00'),
('2541', '21', '1068', '0', '0', '0', '0', '0000-00-00'),
('2542', '22', '1068', '0', '0', '0', '0', '0000-00-00'),
('2543', '23', '1068', '0', '0', '0', '0', '0000-00-00'),
('2544', '24', '1068', '0', '0', '0', '0', '0000-00-00'),
('2545', '1', '1069', '0', '0', '0', '0', '0000-00-00'),
('2546', '2', '1069', '0', '0', '0', '0', '0000-00-00'),
('2547', '3', '1069', '0', '0', '0', '0', '0000-00-00'),
('2548', '4', '1069', '0', '0', '0', '0', '0000-00-00'),
('2549', '5', '1069', '0', '0', '0', '0', '0000-00-00'),
('2550', '6', '1069', '0', '0', '0', '0', '0000-00-00'),
('2551', '7', '1069', '0', '0', '0', '0', '0000-00-00'),
('2552', '8', '1069', '0', '0', '0', '0', '0000-00-00'),
('2553', '9', '1069', '0', '0', '0', '0', '0000-00-00'),
('2554', '10', '1069', '0', '0', '0', '0', '0000-00-00'),
('2555', '11', '1069', '0', '0', '0', '0', '0000-00-00'),
('2556', '12', '1069', '0', '0', '0', '0', '0000-00-00'),
('2557', '13', '1069', '0', '0', '0', '0', '0000-00-00'),
('2558', '14', '1069', '0', '0', '0', '0', '0000-00-00'),
('2559', '15', '1069', '0', '0', '0', '0', '0000-00-00'),
('2560', '16', '1069', '0', '0', '0', '0', '0000-00-00'),
('2561', '17', '1069', '0', '0', '0', '0', '0000-00-00'),
('2562', '18', '1069', '0', '0', '0', '0', '0000-00-00'),
('2563', '19', '1069', '0', '0', '0', '0', '0000-00-00'),
('2564', '20', '1069', '0', '0', '0', '0', '0000-00-00'),
('2565', '21', '1069', '0', '0', '0', '0', '0000-00-00'),
('2566', '22', '1069', '0', '0', '0', '0', '0000-00-00'),
('2567', '23', '1069', '0', '0', '0', '0', '0000-00-00'),
('2568', '24', '1069', '0', '0', '0', '0', '0000-00-00'),
('2569', '1', '1070', '0', '0', '0', '0', '0000-00-00'),
('2570', '2', '1070', '0', '0', '0', '0', '0000-00-00'),
('2571', '3', '1070', '0', '0', '0', '0', '0000-00-00'),
('2572', '4', '1070', '0', '0', '0', '0', '0000-00-00'),
('2573', '5', '1070', '0', '0', '0', '0', '0000-00-00'),
('2574', '6', '1070', '0', '0', '0', '0', '0000-00-00'),
('2575', '7', '1070', '0', '0', '0', '0', '0000-00-00'),
('2576', '8', '1070', '0', '0', '0', '0', '0000-00-00'),
('2577', '9', '1070', '0', '0', '0', '0', '0000-00-00'),
('2578', '10', '1070', '0', '0', '0', '0', '0000-00-00'),
('2579', '11', '1070', '0', '0', '0', '0', '0000-00-00'),
('2580', '12', '1070', '0', '0', '0', '0', '0000-00-00'),
('2581', '13', '1070', '0', '0', '0', '0', '0000-00-00'),
('2582', '14', '1070', '0', '0', '0', '0', '0000-00-00'),
('2583', '15', '1070', '0', '0', '0', '0', '0000-00-00'),
('2584', '16', '1070', '0', '0', '0', '0', '0000-00-00'),
('2585', '17', '1070', '0', '0', '0', '0', '0000-00-00'),
('2586', '18', '1070', '0', '0', '0', '0', '0000-00-00'),
('2587', '19', '1070', '0', '0', '0', '0', '0000-00-00'),
('2588', '20', '1070', '0', '0', '0', '0', '0000-00-00'),
('2589', '21', '1070', '0', '0', '0', '0', '0000-00-00'),
('2590', '22', '1070', '0', '0', '0', '0', '0000-00-00'),
('2591', '23', '1070', '0', '0', '0', '0', '0000-00-00'),
('2592', '24', '1070', '0', '0', '0', '0', '0000-00-00'),
('2593', '1', '1550', '0', '0', '0', '0', '0000-00-00'),
('2594', '2', '1550', '0', '0', '0', '0', '0000-00-00'),
('2595', '3', '1550', '0', '0', '0', '0', '0000-00-00'),
('2596', '4', '1550', '0', '0', '0', '0', '0000-00-00'),
('2597', '5', '1550', '0', '0', '0', '0', '0000-00-00'),
('2598', '6', '1550', '0', '0', '0', '0', '0000-00-00'),
('2599', '7', '1550', '0', '0', '0', '0', '0000-00-00'),
('2600', '8', '1550', '0', '0', '0', '0', '0000-00-00'),
('2601', '9', '1550', '0', '0', '0', '0', '0000-00-00'),
('2602', '10', '1550', '0', '0', '0', '0', '0000-00-00'),
('2603', '11', '1550', '0', '0', '0', '0', '0000-00-00'),
('2604', '12', '1550', '0', '0', '0', '0', '0000-00-00'),
('2605', '13', '1550', '0', '0', '0', '0', '0000-00-00'),
('2606', '14', '1550', '0', '0', '0', '0', '0000-00-00'),
('2607', '15', '1550', '0', '0', '0', '0', '0000-00-00'),
('2608', '16', '1550', '0', '0', '0', '0', '0000-00-00'),
('2609', '17', '1550', '0', '0', '0', '0', '0000-00-00'),
('2610', '18', '1550', '0', '0', '0', '0', '0000-00-00'),
('2611', '19', '1550', '0', '0', '0', '0', '0000-00-00'),
('2612', '20', '1550', '0', '0', '0', '0', '0000-00-00'),
('2613', '21', '1550', '0', '0', '0', '0', '0000-00-00'),
('2614', '22', '1550', '0', '0', '0', '0', '0000-00-00'),
('2615', '23', '1550', '0', '0', '0', '0', '0000-00-00'),
('2616', '24', '1550', '0', '0', '0', '0', '0000-00-00'),
('2617', '1', '1910', '0', '0', '0', '0', '0000-00-00'),
('2618', '2', '1910', '0', '0', '0', '0', '0000-00-00'),
('2619', '3', '1910', '0', '0', '0', '0', '0000-00-00'),
('2620', '4', '1910', '0', '0', '0', '0', '0000-00-00'),
('2621', '5', '1910', '0', '0', '0', '0', '0000-00-00'),
('2622', '6', '1910', '0', '0', '0', '0', '0000-00-00'),
('2623', '7', '1910', '0', '0', '0', '0', '0000-00-00'),
('2624', '8', '1910', '0', '0', '0', '0', '0000-00-00'),
('2625', '9', '1910', '0', '0', '0', '0', '0000-00-00'),
('2626', '10', '1910', '0', '0', '0', '0', '0000-00-00'),
('2627', '11', '1910', '0', '0', '0', '0', '0000-00-00'),
('2628', '12', '1910', '0', '0', '0', '0', '0000-00-00'),
('2629', '13', '1910', '0', '0', '0', '0', '0000-00-00'),
('2630', '14', '1910', '0', '0', '0', '0', '0000-00-00'),
('2631', '15', '1910', '0', '0', '0', '0', '0000-00-00'),
('2632', '16', '1910', '0', '0', '0', '0', '0000-00-00'),
('2633', '17', '1910', '0', '0', '0', '0', '0000-00-00'),
('2634', '18', '1910', '0', '0', '0', '0', '0000-00-00'),
('2635', '19', '1910', '0', '0', '0', '0', '0000-00-00'),
('2636', '20', '1910', '0', '0', '0', '0', '0000-00-00'),
('2637', '21', '1910', '0', '0', '0', '0', '0000-00-00'),
('2638', '22', '1910', '0', '0', '0', '0', '0000-00-00'),
('2639', '23', '1910', '0', '0', '0', '0', '0000-00-00'),
('2640', '24', '1910', '0', '0', '0', '0', '0000-00-00'),
('2641', '1', '1510', '0', '0', '0', '0', '0000-00-00'),
('2642', '2', '1510', '0', '0', '0', '0', '0000-00-00'),
('2643', '3', '1510', '0', '0', '0', '0', '0000-00-00'),
('2644', '4', '1510', '0', '0', '0', '0', '0000-00-00'),
('2645', '5', '1510', '0', '0', '0', '0', '0000-00-00'),
('2646', '6', '1510', '0', '0', '0', '0', '0000-00-00'),
('2647', '7', '1510', '0', '0', '0', '0', '0000-00-00'),
('2648', '8', '1510', '0', '0', '0', '0', '0000-00-00'),
('2649', '9', '1510', '0', '0', '0', '0', '0000-00-00'),
('2650', '10', '1510', '0', '0', '0', '0', '0000-00-00'),
('2651', '11', '1510', '0', '0', '0', '0', '0000-00-00'),
('2652', '12', '1510', '0', '0', '0', '0', '0000-00-00'),
('2653', '13', '1510', '0', '0', '0', '0', '0000-00-00'),
('2654', '14', '1510', '0', '0', '0', '0', '0000-00-00'),
('2655', '15', '1510', '0', '0', '0', '0', '0000-00-00'),
('2656', '16', '1510', '0', '0', '0', '0', '0000-00-00'),
('2657', '17', '1510', '0', '0', '0', '0', '0000-00-00'),
('2658', '18', '1510', '0', '0', '0', '0', '0000-00-00'),
('2659', '19', '1510', '0', '0', '0', '0', '0000-00-00'),
('2660', '20', '1510', '0', '0', '0', '0', '0000-00-00'),
('2661', '21', '1510', '0', '0', '0', '0', '0000-00-00'),
('2662', '22', '1510', '0', '0', '0', '0', '0000-00-00'),
('2663', '23', '1510', '0', '0', '0', '0', '0000-00-00'),
('2664', '24', '1510', '0', '0', '0', '0', '0000-00-00'),
('2665', '1', '1920', '0', '0', '0', '0', '0000-00-00'),
('2666', '2', '1920', '0', '0', '0', '0', '0000-00-00'),
('2667', '3', '1920', '0', '0', '0', '0', '0000-00-00'),
('2668', '4', '1920', '0', '0', '0', '0', '0000-00-00'),
('2669', '5', '1920', '0', '0', '0', '0', '0000-00-00'),
('2670', '6', '1920', '0', '0', '0', '0', '0000-00-00'),
('2671', '7', '1920', '0', '0', '0', '0', '0000-00-00'),
('2672', '8', '1920', '0', '0', '0', '0', '0000-00-00'),
('2673', '9', '1920', '0', '0', '0', '0', '0000-00-00'),
('2674', '10', '1920', '0', '0', '0', '0', '0000-00-00'),
('2675', '11', '1920', '0', '0', '0', '0', '0000-00-00'),
('2676', '12', '1920', '0', '0', '0', '0', '0000-00-00'),
('2677', '13', '1920', '0', '0', '0', '0', '0000-00-00'),
('2678', '14', '1920', '0', '0', '0', '0', '0000-00-00'),
('2679', '15', '1920', '0', '0', '0', '0', '0000-00-00'),
('2680', '16', '1920', '0', '0', '0', '0', '0000-00-00'),
('2681', '17', '1920', '0', '0', '0', '0', '0000-00-00'),
('2682', '18', '1920', '0', '0', '0', '0', '0000-00-00'),
('2683', '19', '1920', '0', '0', '0', '0', '0000-00-00'),
('2684', '20', '1920', '0', '0', '0', '0', '0000-00-00'),
('2685', '21', '1920', '0', '0', '0', '0', '0000-00-00'),
('2686', '22', '1920', '0', '0', '0', '0', '0000-00-00'),
('2687', '23', '1920', '0', '0', '0', '0', '0000-00-00'),
('2688', '24', '1920', '0', '0', '0', '0', '0000-00-00'),
('2689', '1', '1410', '0', '0', '0', '0', '0000-00-00'),
('2690', '2', '1410', '0', '0', '0', '0', '0000-00-00'),
('2691', '3', '1410', '0', '0', '0', '0', '0000-00-00'),
('2692', '4', '1410', '0', '0', '0', '0', '0000-00-00'),
('2693', '5', '1410', '0', '0', '0', '0', '0000-00-00'),
('2694', '6', '1410', '0', '0', '0', '0', '0000-00-00'),
('2695', '7', '1410', '0', '0', '0', '0', '0000-00-00'),
('2696', '8', '1410', '0', '0', '0', '0', '0000-00-00'),
('2697', '9', '1410', '0', '0', '0', '0', '0000-00-00'),
('2698', '10', '1410', '0', '0', '0', '0', '0000-00-00'),
('2699', '11', '1410', '0', '0', '0', '0', '0000-00-00'),
('2700', '12', '1410', '0', '0', '0', '0', '0000-00-00'),
('2701', '13', '1410', '0', '0', '0', '0', '0000-00-00'),
('2702', '14', '1410', '0', '0', '0', '0', '0000-00-00'),
('2703', '15', '1410', '0', '0', '0', '0', '0000-00-00'),
('2704', '16', '1410', '0', '0', '0', '0', '0000-00-00'),
('2705', '17', '1410', '0', '0', '0', '0', '0000-00-00'),
('2706', '18', '1410', '0', '0', '0', '0', '0000-00-00'),
('2707', '19', '1410', '0', '0', '0', '0', '0000-00-00'),
('2708', '20', '1410', '0', '0', '0', '0', '0000-00-00'),
('2709', '21', '1410', '0', '0', '0', '0', '0000-00-00');
INSERT INTO chart_of_accounts_history (`id`,`period`,`account_id`,`beginning_balance`,`debit_amount`,`credit_amount`,`budget`,`last_update`) VALUES 
('2710', '22', '1410', '0', '0', '0', '0', '0000-00-00'),
('2711', '23', '1410', '0', '0', '0', '0', '0000-00-00'),
('2712', '24', '1410', '0', '0', '0', '0', '0000-00-00'),
('2713', '1', '2410', '0', '0', '0', '0', '0000-00-00'),
('2714', '2', '2410', '0', '0', '0', '0', '0000-00-00'),
('2715', '3', '2410', '0', '0', '0', '0', '0000-00-00'),
('2716', '4', '2410', '0', '0', '0', '0', '0000-00-00'),
('2717', '5', '2410', '0', '0', '0', '0', '0000-00-00'),
('2718', '6', '2410', '0', '0', '0', '0', '0000-00-00'),
('2719', '7', '2410', '0', '0', '0', '0', '0000-00-00'),
('2720', '8', '2410', '0', '0', '0', '0', '0000-00-00'),
('2721', '9', '2410', '0', '0', '0', '0', '0000-00-00'),
('2722', '10', '2410', '0', '0', '0', '0', '0000-00-00'),
('2723', '11', '2410', '0', '0', '0', '0', '0000-00-00'),
('2724', '12', '2410', '0', '0', '0', '0', '0000-00-00'),
('2725', '13', '2410', '0', '0', '0', '0', '0000-00-00'),
('2726', '14', '2410', '0', '0', '0', '0', '0000-00-00'),
('2727', '15', '2410', '0', '0', '0', '0', '0000-00-00'),
('2728', '16', '2410', '0', '0', '0', '0', '0000-00-00'),
('2729', '17', '2410', '0', '0', '0', '0', '0000-00-00'),
('2730', '18', '2410', '0', '0', '0', '0', '0000-00-00'),
('2731', '19', '2410', '0', '0', '0', '0', '0000-00-00'),
('2732', '20', '2410', '0', '0', '0', '0', '0000-00-00'),
('2733', '21', '2410', '0', '0', '0', '0', '0000-00-00'),
('2734', '22', '2410', '0', '0', '0', '0', '0000-00-00'),
('2735', '23', '2410', '0', '0', '0', '0', '0000-00-00'),
('2736', '24', '2410', '0', '0', '0', '0', '0000-00-00'),
('2737', '1', '6360', '0', '0', '0', '0', '0000-00-00'),
('2738', '2', '6360', '0', '0', '0', '0', '0000-00-00'),
('2739', '3', '6360', '0', '0', '0', '0', '0000-00-00'),
('2740', '4', '6360', '0', '0', '0', '0', '0000-00-00'),
('2741', '5', '6360', '0', '0', '0', '0', '0000-00-00'),
('2742', '6', '6360', '0', '0', '0', '0', '0000-00-00'),
('2743', '7', '6360', '0', '0', '0', '0', '0000-00-00'),
('2744', '8', '6360', '0', '0', '0', '0', '0000-00-00'),
('2745', '9', '6360', '0', '0', '0', '0', '0000-00-00'),
('2746', '10', '6360', '0', '0', '0', '0', '0000-00-00'),
('2747', '11', '6360', '0', '0', '0', '0', '0000-00-00'),
('2748', '12', '6360', '0', '0', '0', '0', '0000-00-00'),
('2749', '13', '6360', '0', '0', '0', '0', '0000-00-00'),
('2750', '14', '6360', '0', '0', '0', '0', '0000-00-00'),
('2751', '15', '6360', '0', '0', '0', '0', '0000-00-00'),
('2752', '16', '6360', '0', '0', '0', '0', '0000-00-00'),
('2753', '17', '6360', '0', '0', '0', '0', '0000-00-00'),
('2754', '18', '6360', '0', '0', '0', '0', '0000-00-00'),
('2755', '19', '6360', '0', '0', '0', '0', '0000-00-00'),
('2756', '20', '6360', '0', '0', '0', '0', '0000-00-00'),
('2757', '21', '6360', '0', '0', '0', '0', '0000-00-00'),
('2758', '22', '6360', '0', '0', '0', '0', '0000-00-00'),
('2759', '23', '6360', '0', '0', '0', '0', '0000-00-00'),
('2760', '24', '6360', '0', '0', '0', '0', '0000-00-00'),
('2761', '1', '1971', '0', '0', '0', '0', '0000-00-00'),
('2762', '2', '1971', '0', '0', '0', '0', '0000-00-00'),
('2763', '3', '1971', '0', '0', '0', '0', '0000-00-00'),
('2764', '4', '1971', '0', '0', '0', '0', '0000-00-00'),
('2765', '5', '1971', '0', '0', '0', '0', '0000-00-00'),
('2766', '6', '1971', '0', '0', '0', '0', '0000-00-00'),
('2767', '7', '1971', '0', '0', '0', '0', '0000-00-00'),
('2768', '8', '1971', '0', '0', '0', '0', '0000-00-00'),
('2769', '9', '1971', '0', '0', '0', '0', '0000-00-00'),
('2770', '10', '1971', '0', '0', '0', '0', '0000-00-00'),
('2771', '11', '1971', '0', '0', '0', '0', '0000-00-00'),
('2772', '12', '1971', '0', '0', '0', '0', '0000-00-00'),
('2773', '13', '1971', '0', '0', '0', '0', '0000-00-00'),
('2774', '14', '1971', '0', '0', '0', '0', '0000-00-00'),
('2775', '15', '1971', '0', '0', '0', '0', '0000-00-00'),
('2776', '16', '1971', '0', '0', '0', '0', '0000-00-00'),
('2777', '17', '1971', '0', '0', '0', '0', '0000-00-00'),
('2778', '18', '1971', '0', '0', '0', '0', '0000-00-00'),
('2779', '19', '1971', '0', '0', '0', '0', '0000-00-00'),
('2780', '20', '1971', '0', '0', '0', '0', '0000-00-00'),
('2781', '21', '1971', '0', '0', '0', '0', '0000-00-00'),
('2782', '22', '1971', '0', '0', '0', '0', '0000-00-00'),
('2783', '23', '1971', '0', '0', '0', '0', '0000-00-00'),
('2784', '24', '1971', '0', '0', '0', '0', '0000-00-00'),
('2785', '1', '1071', '0', '0', '0', '0', '0000-00-00'),
('2786', '2', '1071', '0', '0', '0', '0', '0000-00-00'),
('2787', '3', '1071', '0', '0', '0', '0', '0000-00-00'),
('2788', '4', '1071', '0', '0', '0', '0', '0000-00-00'),
('2789', '5', '1071', '0', '0', '0', '0', '0000-00-00'),
('2790', '6', '1071', '0', '0', '0', '0', '0000-00-00'),
('2791', '7', '1071', '0', '0', '0', '0', '0000-00-00'),
('2792', '8', '1071', '0', '0', '0', '0', '0000-00-00'),
('2793', '9', '1071', '0', '0', '0', '0', '0000-00-00'),
('2794', '10', '1071', '0', '0', '0', '0', '0000-00-00'),
('2795', '11', '1071', '0', '0', '0', '0', '0000-00-00'),
('2796', '12', '1071', '0', '0', '0', '0', '0000-00-00'),
('2797', '13', '1071', '0', '0', '0', '0', '0000-00-00'),
('2798', '14', '1071', '0', '0', '0', '0', '0000-00-00'),
('2799', '15', '1071', '0', '0', '0', '0', '0000-00-00'),
('2800', '16', '1071', '0', '0', '0', '0', '0000-00-00'),
('2801', '17', '1071', '0', '0', '0', '0', '0000-00-00'),
('2802', '18', '1071', '0', '0', '0', '0', '0000-00-00'),
('2803', '19', '1071', '0', '0', '0', '0', '0000-00-00'),
('2804', '20', '1071', '0', '0', '0', '0', '0000-00-00'),
('2805', '21', '1071', '0', '0', '0', '0', '0000-00-00'),
('2806', '22', '1071', '0', '0', '0', '0', '0000-00-00'),
('2807', '23', '1071', '0', '0', '0', '0', '0000-00-00'),
('2808', '24', '1071', '0', '0', '0', '0', '0000-00-00'),
('2809', '1', '1072', '0', '0', '0', '0', '0000-00-00'),
('2810', '2', '1072', '0', '0', '0', '0', '0000-00-00'),
('2811', '3', '1072', '0', '0', '0', '0', '0000-00-00'),
('2812', '4', '1072', '0', '0', '0', '0', '0000-00-00'),
('2813', '5', '1072', '0', '0', '0', '0', '0000-00-00'),
('2814', '6', '1072', '0', '0', '0', '0', '0000-00-00'),
('2815', '7', '1072', '0', '0', '0', '0', '0000-00-00'),
('2816', '8', '1072', '0', '0', '0', '0', '0000-00-00'),
('2817', '9', '1072', '0', '0', '0', '0', '0000-00-00'),
('2818', '10', '1072', '0', '0', '0', '0', '0000-00-00'),
('2819', '11', '1072', '0', '0', '0', '0', '0000-00-00'),
('2820', '12', '1072', '0', '0', '0', '0', '0000-00-00'),
('2821', '13', '1072', '0', '0', '0', '0', '0000-00-00'),
('2822', '14', '1072', '0', '0', '0', '0', '0000-00-00'),
('2823', '15', '1072', '0', '0', '0', '0', '0000-00-00'),
('2824', '16', '1072', '0', '0', '0', '0', '0000-00-00'),
('2825', '17', '1072', '0', '0', '0', '0', '0000-00-00'),
('2826', '18', '1072', '0', '0', '0', '0', '0000-00-00'),
('2827', '19', '1072', '0', '0', '0', '0', '0000-00-00'),
('2828', '20', '1072', '0', '0', '0', '0', '0000-00-00'),
('2829', '21', '1072', '0', '0', '0', '0', '0000-00-00'),
('2830', '22', '1072', '0', '0', '0', '0', '0000-00-00'),
('2831', '23', '1072', '0', '0', '0', '0', '0000-00-00'),
('2832', '24', '1072', '0', '0', '0', '0', '0000-00-00'),
('2833', '1', '1073', '0', '0', '0', '0', '0000-00-00'),
('2834', '2', '1073', '0', '0', '0', '0', '0000-00-00'),
('2835', '3', '1073', '0', '0', '0', '0', '0000-00-00'),
('2836', '4', '1073', '0', '0', '0', '0', '0000-00-00'),
('2837', '5', '1073', '0', '0', '0', '0', '0000-00-00'),
('2838', '6', '1073', '0', '0', '0', '0', '0000-00-00'),
('2839', '7', '1073', '0', '0', '0', '0', '0000-00-00'),
('2840', '8', '1073', '0', '0', '0', '0', '0000-00-00'),
('2841', '9', '1073', '0', '0', '0', '0', '0000-00-00'),
('2842', '10', '1073', '0', '0', '0', '0', '0000-00-00'),
('2843', '11', '1073', '0', '0', '0', '0', '0000-00-00'),
('2844', '12', '1073', '0', '0', '0', '0', '0000-00-00'),
('2845', '13', '1073', '0', '0', '0', '0', '0000-00-00'),
('2846', '14', '1073', '0', '0', '0', '0', '0000-00-00'),
('2847', '15', '1073', '0', '0', '0', '0', '0000-00-00'),
('2848', '16', '1073', '0', '0', '0', '0', '0000-00-00'),
('2849', '17', '1073', '0', '0', '0', '0', '0000-00-00'),
('2850', '18', '1073', '0', '0', '0', '0', '0000-00-00'),
('2851', '19', '1073', '0', '0', '0', '0', '0000-00-00'),
('2852', '20', '1073', '0', '0', '0', '0', '0000-00-00'),
('2853', '21', '1073', '0', '0', '0', '0', '0000-00-00'),
('2854', '22', '1073', '0', '0', '0', '0', '0000-00-00'),
('2855', '23', '1073', '0', '0', '0', '0', '0000-00-00'),
('2856', '24', '1073', '0', '0', '0', '0', '0000-00-00'),
('2857', '1', '1155', '0', '0', '0', '0', '0000-00-00'),
('2858', '2', '1155', '0', '0', '0', '0', '0000-00-00'),
('2859', '3', '1155', '0', '0', '0', '0', '0000-00-00'),
('2860', '4', '1155', '0', '0', '0', '0', '0000-00-00'),
('2861', '5', '1155', '0', '0', '0', '0', '0000-00-00'),
('2862', '6', '1155', '0', '0', '0', '0', '0000-00-00'),
('2863', '7', '1155', '0', '0', '0', '0', '0000-00-00'),
('2864', '8', '1155', '0', '0', '0', '0', '0000-00-00'),
('2865', '9', '1155', '0', '0', '0', '0', '0000-00-00'),
('2866', '10', '1155', '0', '0', '0', '0', '0000-00-00'),
('2867', '11', '1155', '0', '0', '0', '0', '0000-00-00'),
('2868', '12', '1155', '0', '0', '0', '0', '0000-00-00'),
('2869', '13', '1155', '0', '0', '0', '0', '0000-00-00'),
('2870', '14', '1155', '0', '0', '0', '0', '0000-00-00'),
('2871', '15', '1155', '0', '0', '0', '0', '0000-00-00'),
('2872', '16', '1155', '0', '0', '0', '0', '0000-00-00'),
('2873', '17', '1155', '0', '0', '0', '0', '0000-00-00'),
('2874', '18', '1155', '0', '0', '0', '0', '0000-00-00'),
('2875', '19', '1155', '0', '0', '0', '0', '0000-00-00'),
('2876', '20', '1155', '0', '0', '0', '0', '0000-00-00'),
('2877', '21', '1155', '0', '0', '0', '0', '0000-00-00'),
('2878', '22', '1155', '0', '0', '0', '0', '0000-00-00'),
('2879', '23', '1155', '0', '0', '0', '0', '0000-00-00'),
('2880', '24', '1155', '0', '0', '0', '0', '0000-00-00');


-- Table structure for table configuration
DROP TABLE IF EXISTS configuration;

CREATE TABLE `configuration` (
  `configuration_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `configuration_value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`configuration_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO configuration (`configuration_key`,`configuration_value`) VALUES 
('MODULE_PHREEDOM_STATUS', '3.7.1'),
('COMPANY_ID', 'TTNL'),
('COMPANY_NAME', 'Tridal Tech Nigeria Limited'),
('AR_CONTACT_NAME', 'Mr. Timothy Agwaraonye'),
('AP_CONTACT_NAME', 'Mr. Timothy Agwaraonye'),
('COMPANY_ADDRESS1', '5, Adepele Street, Off Medical Road'),
('COMPANY_ADDRESS2', 'Computer Village'),
('COMPANY_CITY_TOWN', 'Ikeja'),
('COMPANY_ZONE', 'Lagos'),
('COMPANY_POSTAL_CODE', '90001'),
('COMPANY_COUNTRY', 'NGA'),
('COMPANY_TELEPHONE1', ''),
('COMPANY_TELEPHONE2', ''),
('COMPANY_FAX', ''),
('COMPANY_EMAIL', 'webmaster@mycompany.com'),
('COMPANY_WEBSITE', ''),
('TAX_ID', ''),
('ENABLE_MULTI_BRANCH', '0'),
('ENABLE_MULTI_CURRENCY', '1'),
('ENABLE_ENCRYPTION', '0'),
('ENTRY_PASSWORD_MIN_LENGTH', '7'),
('MAX_DISPLAY_SEARCH_RESULTS', '30'),
('CFG_AUTO_UPDATE_CHECK', '0'),
('HIDE_SUCCESS_MESSAGES', '0'),
('AUTO_UPDATE_CURRENCY', '1'),
('LIMIT_HISTORY_RESULTS', '30'),
('SESSION_TIMEOUT_ADMIN', '300'),
('SESSION_AUTO_REFRESH', '0'),
('DEBUG', '1'),
('IE_RW_EXPORT_PREFERENCE', 'd'),
('EMAIL_TRANSPORT', 'PHP'),
('EMAIL_LINEFEED', 'LF'),
('EMAIL_USE_HTML', '0'),
('STORE_OWNER_EMAIL_ADDRESS', ''),
('EMAIL_FROM', ''),
('ADMIN_EXTRA_EMAIL_FORMAT', 'TEXT'),
('EMAIL_SMTPAUTH_MAILBOX', ''),
('EMAIL_SMTPAUTH_PASSWORD', ''),
('EMAIL_SMTPAUTH_MAIL_SERVER', ''),
('EMAIL_SMTPAUTH_MAIL_SERVER_PORT', '25'),
('EMAIL_SMTPAUTH_TLS', '0'),
('CURRENCIES_TRANSLATIONS', '£,?:€,?'),
('DATE_FORMAT', 'd/m/Y'),
('DATE_DELIMITER', '/'),
('DATE_TIME_FORMAT', 'd/m/Y h:i:s a'),
('SERVER_ADDRESS', ''),
('DEFAULT_CURRENCY', 'NGN'),
('MODULE_PHREEFORM_STATUS', '3.7'),
('PF_DEFAULT_COLUMN_WIDTH', '25'),
('PF_DEFAULT_MARGIN', '8'),
('PF_DEFAULT_TITLE1', '%reportname%'),
('PF_DEFAULT_TITLE2', 'Report Generated %date%'),
('PF_DEFAULT_PAPERSIZE', 'Letter:216:282'),
('PF_DEFAULT_ORIENTATION', 'P'),
('PF_DEFAULT_TRIM_LENGTH', '25'),
('PF_DEFAULT_ROWSPACE', '2'),
('PDF_APP', 'TCPDF'),
('MODULE_PHREEBOOKS_STATUS', '3.7'),
('AUTO_UPDATE_PERIOD', '1'),
('SHOW_FULL_GL_NAMES', '2'),
('ROUND_TAX_BY_AUTH', '0'),
('ENABLE_BAR_CODE_READERS', '1'),
('SINGLE_LINE_ORDER_SCREEN', '1'),
('ENABLE_ORDER_DISCOUNT', '0'),
('ALLOW_NEGATIVE_INVENTORY', '0'),
('AR_DEFAULT_GL_ACCT', '1100'),
('AR_DEF_GL_SALES_ACCT', '4000'),
('AR_SALES_RECEIPTS_ACCOUNT', '1020'),
('AR_DISCOUNT_SALES_ACCOUNT', '4000'),
('AR_DEF_FREIGHT_ACCT', '4300'),
('AR_DEF_DEPOSIT_ACCT', '1020'),
('AR_DEF_DEP_LIAB_ACCT', '1100'),
('AR_USE_CREDIT_LIMIT', '1'),
('AR_CREDIT_LIMIT_AMOUNT', '2500.00'),
('APPLY_CUSTOMER_CREDIT_LIMIT', '0'),
('AR_PREPAYMENT_DISCOUNT_PERCENT', '0'),
('AR_PREPAYMENT_DISCOUNT_DAYS', '0'),
('AR_NUM_DAYS_DUE', '0'),
('AR_AGING_HEADING_1', '0-30'),
('AR_ACCOUNT_AGING_START', '0'),
('AR_AGING_HEADING_2', '31-60'),
('AR_AGING_PERIOD_1', '30'),
('AR_AGING_HEADING_3', '61-90'),
('AR_AGING_PERIOD_2', '60'),
('AR_AGING_HEADING_4', 'Over 90'),
('AR_AGING_PERIOD_3', '90'),
('AR_CALCULATE_FINANCE_CHARGE', '0'),
('AR_ADD_SALES_TAX_TO_SHIPPING', '0'),
('AUTO_INC_CUST_ID', '1'),
('AR_SHOW_CONTACT_STATUS', '1'),
('AR_TAX_BEFORE_DISCOUNT', '0'),
('AP_DEFAULT_INVENTORY_ACCOUNT', '1200'),
('AP_DEFAULT_PURCHASE_ACCOUNT', '2000'),
('AP_PURCHASE_INVOICE_ACCOUNT', '1020'),
('AP_DEF_FREIGHT_ACCT', '5100'),
('AP_DISCOUNT_PURCHASE_ACCOUNT', '2000'),
('AP_DEF_DEPOSIT_ACCT', '1020'),
('AP_DEF_DEP_LIAB_ACCT', '2000'),
('AP_USE_CREDIT_LIMIT', '1'),
('AP_CREDIT_LIMIT_AMOUNT', '5000.00'),
('AP_PREPAYMENT_DISCOUNT_PERCENT', '0'),
('AP_PREPAYMENT_DISCOUNT_DAYS', '0'),
('AP_NUM_DAYS_DUE', '20'),
('AP_AGING_HEADING_1', '0-30'),
('AP_AGING_START_DATE', '0'),
('AP_AGING_HEADING_2', '31-60'),
('AP_AGING_DATE_1', '30'),
('AP_AGING_HEADING_3', '61-90'),
('AP_AGING_DATE_2', '60'),
('AP_AGING_HEADING_4', 'Over 90'),
('AP_AGING_DATE_3', '90'),
('AP_ADD_SALES_TAX_TO_SHIPPING', '0'),
('AUTO_INC_VEND_ID', '0'),
('AP_SHOW_CONTACT_STATUS', '0'),
('AP_TAX_BEFORE_DISCOUNT', '0'),
('MODULE_CONTACTS_STATUS', '3.73'),
('ADDRESS_BOOK_CONTACT_REQUIRED', '0'),
('ADDRESS_BOOK_ADDRESS1_REQUIRED', '1'),
('ADDRESS_BOOK_ADDRESS2_REQUIRED', '0'),
('ADDRESS_BOOK_CITY_TOWN_REQUIRED', '1'),
('ADDRESS_BOOK_STATE_PROVINCE_REQUIRED', '1'),
('ADDRESS_BOOK_POSTAL_CODE_REQUIRED', '1'),
('ADDRESS_BOOK_TELEPHONE1_REQUIRED', '0'),
('ADDRESS_BOOK_EMAIL_REQUIRED', '0'),
('MODULE_INVENTORY_STATUS', '3.7.4'),
('INV_STOCK_DEFAULT_SALES', '4000'),
('INV_STOCK_DEFAULT_INVENTORY', '1200'),
('INV_STOCK_DEFAULT_COS', '5000'),
('INV_STOCK_DEFAULT_COSTING', 'f'),
('INV_MASTER_STOCK_DEFAULT_SALES', '4000'),
('INV_MASTER_STOCK_DEFAULT_INVENTORY', '1200'),
('INV_MASTER_STOCK_DEFAULT_COS', '5000'),
('INV_MASTER_STOCK_DEFAULT_COSTING', 'f'),
('INV_ASSY_DEFAULT_SALES', '4000'),
('INV_ASSY_DEFAULT_INVENTORY', '1200'),
('INV_ASSY_DEFAULT_COS', '5000'),
('INV_ASSY_DEFAULT_COSTING', 'f'),
('INV_SERIALIZE_DEFAULT_SALES', '4000'),
('INV_SERIALIZE_DEFAULT_INVENTORY', '1200'),
('INV_SERIALIZE_DEFAULT_COS', '5000'),
('INV_SERIALIZE_DEFAULT_COSTING', 'f'),
('INV_NON_STOCK_DEFAULT_SALES', '4000'),
('INV_NON_STOCK_DEFAULT_INVENTORY', '6550'),
('INV_NON_STOCK_DEFAULT_COS', '5000'),
('INV_SERVICE_DEFAULT_SALES', '4000'),
('INV_SERVICE_DEFAULT_INVENTORY', '6550'),
('INV_SERVICE_DEFAULT_COS', '5000'),
('INV_LABOR_DEFAULT_SALES', '4000'),
('INV_LABOR_DEFAULT_INVENTORY', '6550'),
('INV_LABOR_DEFAULT_COS', '5000'),
('INV_ACTIVITY_DEFAULT_SALES', '4000'),
('INV_ACTIVITY_DEFAULT_INVENTORY', '6550'),
('INV_CHARGE_DEFAULT_SALES', '4000'),
('INV_CHARGE_DEFAULT_INVENTORY', '6550'),
('INV_DESC_DEFAULT_SALES', '4000'),
('INV_DESC_DEFAULT_INVENTORY', '6550'),
('INVENTORY_DEFAULT_TAX', '0'),
('INVENTORY_DEFAULT_PURCH_TAX', '0'),
('INVENTORY_AUTO_ADD', '0'),
('INVENTORY_AUTO_FILL', '0'),
('ORD_ENABLE_LINE_ITEM_BAR_CODE', '0'),
('ORD_BAR_CODE_LENGTH', '12'),
('ENABLE_AUTO_ITEM_COST', '0'),
('MODULE_SHIPPING_STATUS', '3.7'),
('ADDRESS_BOOK_SHIP_CONTACT_REQ', '0'),
('ADDRESS_BOOK_SHIP_ADD1_REQ', '1'),
('ADDRESS_BOOK_SHIP_ADD2_REQ', '0'),
('ADDRESS_BOOK_SHIP_CITY_REQ', '1'),
('ADDRESS_BOOK_SHIP_STATE_REQ', '1'),
('ADDRESS_BOOK_SHIP_POSTAL_CODE_REQ', '1'),
('SHIPPING_DEFAULT_WEIGHT_UNIT', 'LBS'),
('SHIPPING_DEFAULT_CURRENCY', 'USD'),
('SHIPPING_DEFAULT_PKG_DIM_UNIT', 'IN'),
('SHIPPING_DEFAULT_RESIDENTIAL', '1'),
('SHIPPING_DEFAULT_PACKAGE_TYPE', '02'),
('SHIPPING_DEFAULT_PICKUP_SERVICE', '01'),
('SHIPPING_DEFAULT_LENGTH', '8'),
('SHIPPING_DEFAULT_WIDTH', '6'),
('SHIPPING_DEFAULT_HEIGHT', '4'),
('SHIPPING_DEFAULT_ADDITIONAL_HANDLING_SHOW', '1'),
('SHIPPING_DEFAULT_ADDITIONAL_HANDLING_CHECKED', '0'),
('SHIPPING_DEFAULT_INSURANCE_SHOW', '1'),
('SHIPPING_DEFAULT_INSURANCE_CHECKED', '0'),
('SHIPPING_DEFAULT_INSURANCE_VALUE', '100.00'),
('SHIPPING_DEFAULT_SPLIT_LARGE_SHIPMENTS_SHOW', '1'),
('SHIPPING_DEFAULT_SPLIT_LARGE_SHIPMENTS_CHECKED', '1'),
('SHIPPING_DEFAULT_SPLIT_LARGE_SHIPMENTS_VALUE', '75'),
('SHIPPING_DEFAULT_DELIVERY_COMFIRMATION_SHOW', '1'),
('SHIPPING_DEFAULT_DELIVERY_COMFIRMATION_CHECKED', '0'),
('SHIPPING_DEFAULT_DELIVERY_COMFIRMATION_TYPE', '2'),
('SHIPPING_DEFAULT_HANDLING_CHARGE_SHOW', '1'),
('SHIPPING_DEFAULT_HANDLING_CHARGE_CHECKED', '0'),
('SHIPPING_DEFAULT_HANDLING_CHARGE_VALUE', '0.00'),
('SHIPPING_DEFAULT_COD_SHOW', '1'),
('SHIPPING_DEFAULT_COD_CHECKED', '0'),
('SHIPPING_DEFAULT_PAYMENT_TYPE', '1'),
('SHIPPING_DEFAULT_SATURDAY_PICKUP_SHOW', '1'),
('SHIPPING_DEFAULT_SATURDAY_PICKUP_CHECKED', '0'),
('SHIPPING_DEFAULT_SATURDAY_DELIVERY_SHOW', '1'),
('SHIPPING_DEFAULT_SATURDAY_DELIVERY_CHECKED', '0'),
('SHIPPING_DEFAULT_HAZARDOUS_SHOW', '0');
INSERT INTO configuration (`configuration_key`,`configuration_value`) VALUES 
('SHIPPING_DEFAULT_HAZARDOUS_CHECKED', '0'),
('SHIPPING_DEFAULT_DRY_ICE_SHOW', '0'),
('SHIPPING_DEFAULT_DRY_ICE_CHECKED', '0'),
('SHIPPING_DEFAULT_RETURN_SERVICE_SHOW', '1'),
('SHIPPING_DEFAULT_RETURN_SERVICE_CHECKED', '0'),
('SHIPPING_DEFAULT_RETURN_SERVICE', '2'),
('MODULE_SHIPPING_FREESHIPPER_STATUS', '1'),
('MODULE_SHIPPING_FREESHIPPER_TITLE', 'MODULE_SHIPPING_FREESHIPPER_TITLE_SHORT'),
('MODULE_SHIPPING_FREESHIPPER_COST', '0.00'),
('MODULE_SHIPPING_FREESHIPPER_HANDLING', '0.00'),
('MODULE_SHIPPING_FREESHIPPER_SORT_ORDER', '25'),
('MODULE_SHIPPING_FLAT_STATUS', '1'),
('MODULE_SHIPPING_FLAT_TITLE', 'Flat Shipping'),
('MODULE_SHIPPING_FLAT_COST', '5.00'),
('MODULE_SHIPPING_FLAT_SORT_ORDER', '20'),
('MODULE_PHREEHELP_STATUS', '3.7'),
('PHREEHELP_FORCE_RELOAD', '1'),
('MODULE_PAYMENT_STATUS', '3.7'),
('MODULE_PAYMENT_COD_STATUS', '1'),
('MODULE_PAYMENT_COD_OPEN_POS_DRAWER', ''),
('MODULE_PAYMENT_COD_SORT_ORDER', '40'),
('MODULE_PAYMENT_COD_POS_GL_ACCT', ''),
('MODULE_PAYMENT_COD_SHOW_IN_POS', '1'),
('MODULE_PAYMENT_MONEYORDER_STATUS', '1'),
('MODULE_PAYMENT_MONEYORDER_OPEN_POS_DRAWER', ''),
('MODULE_PAYMENT_MONEYORDER_SORT_ORDER', '30'),
('MODULE_PAYMENT_MONEYORDER_POS_GL_ACCT', ''),
('MODULE_PAYMENT_MONEYORDER_SHOW_IN_POS', '1'),
('MODULE_PAYMENT_MONEYORDER_PAYTO', 'My Company'),
('MODULE_PHREEPOS_STATUS', '3.9'),
('PHREEPOS_REQUIRE_ADDRESS', '0'),
('PHREEPOS_RECEIPT_PRINTER_NAME', ''),
('PHREEPOS_RECEIPT_PRINTER_STARTING_LINE', ''),
('PHREEPOS_RECEIPT_PRINTER_CLOSING_LINE', ''),
('PHREEPOS_RECEIPT_PRINTER_OPEN_DRAWER', ''),
('PHREEPOS_DISPLAY_WITH_TAX', '1'),
('PHREEPOS_DISCOUNT_OF', '0'),
('PHREEPOS_ROUNDING', '0'),
('PHREEPOS_ENABLE_DIRECT_PRINTING', '0'),
('CURRENT_ACCOUNTING_PERIOD', '13'),
('CURRENT_ACCOUNTING_PERIOD_START', '2026-01-01'),
('CURRENT_ACCOUNTING_PERIOD_END', '2026-01-31');


-- Table structure for table contacts
DROP TABLE IF EXISTS contacts;

CREATE TABLE `contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'c',
  `contacts_level` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'r',
  `short_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `contact_first` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_middle` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_last` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `gl_type_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `gov_id_number` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dept_rep_id` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_number` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `special_terms` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `price_sheet` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT '-1',
  `attachments` text COLLATE utf8_unicode_ci,
  `first_date` date NOT NULL DEFAULT '0000-00-00',
  `last_update` date DEFAULT NULL,
  `last_date_1` date DEFAULT NULL,
  `last_date_2` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `short_name` (`short_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table contacts_log
DROP TABLE IF EXISTS contacts_log;

CREATE TABLE `contacts_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL DEFAULT '0',
  `entered_by` int(11) NOT NULL DEFAULT '0',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `action` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table currencies
DROP TABLE IF EXISTS currencies;

CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `symbol_left` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `symbol_right` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimal_point` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `thousands_point` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimal_places` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimal_precise` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '2',
  `value` double NOT NULL DEFAULT '0',
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO currencies (`currencies_id`,`title`,`code`,`symbol_left`,`symbol_right`,`decimal_point`,`thousands_point`,`decimal_places`,`decimal_precise`,`value`,`last_updated`) VALUES 
('1', 'US Dollar', 'USD', '$', '', '.', ',', '2', '2', '0.0006666667', '2026-01-02 16:51:58'),
('2', 'Euro', 'EUR', '', 'EUR', '.', ',', '2', '2', '0.0005780347', '2026-01-02 16:51:58'),
('3', 'Naira', 'NGN', 'N', '', '.', ',', '2', '2', '1', '');


-- Table structure for table current_status
DROP TABLE IF EXISTS current_status;

CREATE TABLE `current_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `next_po_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '5000',
  `next_so_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '10000',
  `next_inv_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '20000',
  `next_check_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '100',
  `next_deposit_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `next_cm_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'CM1000',
  `next_vcm_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'VCM1000',
  `next_ap_quote_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'RFQ1000',
  `next_ar_quote_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'QU1000',
  `next_cust_id_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'C10000',
  `next_vend_id_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'V10000',
  `next_crm_id_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '10000',
  `next_shipment_num` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO current_status (`id`,`next_po_num`,`next_so_num`,`next_inv_num`,`next_check_num`,`next_deposit_num`,`next_cm_num`,`next_vcm_num`,`next_ap_quote_num`,`next_ar_quote_num`,`next_cust_id_num`,`next_vend_id_num`,`next_crm_id_num`,`next_shipment_num`) VALUES 
('1', 'TTNL/PO/10100', 'TTNL/SO/10100', 'TTNL/INV/10100', 'TTNL/CHQ/10100', 'TTNL/R/10100', 'TTNL/CM/10100', 'TTNL/VCM/10100', 'TTNL/RFQ/10100', 'TTNL/QU/10100', 'C10000', 'V10000', '10000', '1');


-- Table structure for table data_security
DROP TABLE IF EXISTS data_security;

CREATE TABLE `data_security` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref_1` int(11) NOT NULL DEFAULT '0',
  `ref_2` int(11) NOT NULL DEFAULT '0',
  `hint` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `enc_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exp_date` date NOT NULL DEFAULT '2049-12-31',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table departments
DROP TABLE IF EXISTS departments;

CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description_short` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subdepartment` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `primary_dept_id` int(11) NOT NULL DEFAULT '0',
  `department_type` tinyint(4) NOT NULL DEFAULT '0',
  `department_inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`department_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table departments_types
DROP TABLE IF EXISTS departments_types;

CREATE TABLE `departments_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory
DROP TABLE IF EXISTS inventory;

CREATE TABLE `inventory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inventory_type` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'si',
  `description_short` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description_purchase` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description_sales` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_with_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_sales_income` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_inventory_wage` varchar(15) COLLATE utf8_unicode_ci DEFAULT '',
  `account_cost_of_sales` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_taxable` int(11) NOT NULL DEFAULT '0',
  `purch_taxable` int(11) NOT NULL DEFAULT '0',
  `item_cost` double NOT NULL DEFAULT '0',
  `cost_method` enum('a','f','l') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'f',
  `price_sheet` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price_sheet_v` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `full_price` double NOT NULL DEFAULT '0',
  `full_price_with_tax` double NOT NULL DEFAULT '0',
  `product_margin` double NOT NULL DEFAULT '0',
  `product_markup` double NOT NULL DEFAULT '0',
  `item_weight` double NOT NULL DEFAULT '0',
  `quantity_on_hand` double NOT NULL DEFAULT '0',
  `quantity_on_order` double NOT NULL DEFAULT '0',
  `quantity_on_sales_order` double NOT NULL DEFAULT '0',
  `quantity_on_allocation` double NOT NULL DEFAULT '0',
  `minimum_stock_level` double NOT NULL DEFAULT '0',
  `reorder_quantity` double NOT NULL DEFAULT '0',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `lead_time` int(3) NOT NULL DEFAULT '1',
  `upc_code` varchar(13) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `serialize` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_journal_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attachments` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `sku` (`sku`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_assy_list
DROP TABLE IF EXISTS inventory_assy_list;

CREATE TABLE `inventory_assy_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref_id` (`ref_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_cogs_owed
DROP TABLE IF EXISTS inventory_cogs_owed;

CREATE TABLE `inventory_cogs_owed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_main_id` int(11) NOT NULL DEFAULT '0',
  `store_id` int(11) NOT NULL DEFAULT '0',
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '0',
  `post_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `sku` (`sku`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_cogs_usage
DROP TABLE IF EXISTS inventory_cogs_usage;

CREATE TABLE `inventory_cogs_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_main_id` int(11) NOT NULL DEFAULT '0',
  `qty` double NOT NULL DEFAULT '0',
  `inventory_history_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `journal_main_id` (`journal_main_id`,`inventory_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_history
DROP TABLE IF EXISTS inventory_history;

CREATE TABLE `inventory_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `store_id` int(11) NOT NULL DEFAULT '0',
  `journal_id` int(2) NOT NULL DEFAULT '6',
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '0',
  `serialize_number` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remaining` double NOT NULL DEFAULT '0',
  `unit_cost` double NOT NULL DEFAULT '0',
  `avg_cost` double NOT NULL DEFAULT '0',
  `post_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sku` (`sku`),
  KEY `ref_id` (`ref_id`),
  KEY `remaining` (`remaining`),
  KEY `store_id` (`store_id`),
  KEY `journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_ms_list
DROP TABLE IF EXISTS inventory_ms_list;

CREATE TABLE `inventory_ms_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `attr_name_0` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attr_name_1` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attr_0` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attr_1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_purchase_details
DROP TABLE IF EXISTS inventory_purchase_details;

CREATE TABLE `inventory_purchase_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sku` varchar(24) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vendor_id` int(11) NOT NULL DEFAULT '0',
  `description_purchase` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purch_package_quantity` double NOT NULL DEFAULT '1',
  `purch_taxable` int(11) NOT NULL DEFAULT '0',
  `item_cost` double NOT NULL DEFAULT '0',
  `price_sheet_v` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sku` (`sku`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table inventory_special_prices
DROP TABLE IF EXISTS inventory_special_prices;

CREATE TABLE `inventory_special_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inventory_id` int(11) NOT NULL DEFAULT '0',
  `price_sheet_id` int(11) NOT NULL DEFAULT '0',
  `price_levels` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table journal_item
DROP TABLE IF EXISTS journal_item;

CREATE TABLE `journal_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_id` int(11) NOT NULL DEFAULT '0',
  `item_cnt` int(11) NOT NULL DEFAULT '0',
  `so_po_item_ref_id` int(11) DEFAULT NULL,
  `gl_type` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reconciled` int(2) NOT NULL DEFAULT '0',
  `sku` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` double NOT NULL DEFAULT '0',
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `debit_amount` double DEFAULT '0',
  `credit_amount` double DEFAULT '0',
  `gl_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `taxable` int(11) NOT NULL DEFAULT '0',
  `full_price` double NOT NULL DEFAULT '0',
  `serialize` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `serialize_number` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `project_id` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purch_package_quantity` double DEFAULT NULL,
  `post_date` date NOT NULL DEFAULT '0000-00-00',
  `date_1` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `ref_id` (`ref_id`),
  KEY `so_po_item_ref_id` (`so_po_item_ref_id`),
  KEY `reconciled` (`reconciled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table journal_main
DROP TABLE IF EXISTS journal_main;

CREATE TABLE `journal_main` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period` int(2) NOT NULL DEFAULT '0',
  `journal_id` int(2) NOT NULL DEFAULT '0',
  `post_date` date NOT NULL DEFAULT '0000-00-00',
  `store_id` int(11) DEFAULT '0',
  `description` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `closed` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `closed_date` date NOT NULL DEFAULT '0000-00-00',
  `printed` int(11) NOT NULL DEFAULT '0',
  `freight` double DEFAULT '0',
  `discount` double NOT NULL DEFAULT '0',
  `shipper_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `terms` varchar(32) COLLATE utf8_unicode_ci DEFAULT '0',
  `sales_tax` double NOT NULL DEFAULT '0',
  `tax_auths` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `total_amount` double NOT NULL DEFAULT '0',
  `currencies_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'NGN',
  `currencies_value` double NOT NULL DEFAULT '1',
  `so_po_ref_id` int(11) NOT NULL DEFAULT '0',
  `purchase_invoice_id` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purch_order_id` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recur_id` int(11) DEFAULT NULL,
  `admin_id` int(11) NOT NULL DEFAULT '0',
  `rep_id` int(11) NOT NULL DEFAULT '0',
  `waiting` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `gl_acct_id` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_acct_id` int(11) NOT NULL DEFAULT '0',
  `bill_address_id` int(11) NOT NULL DEFAULT '0',
  `bill_primary_name` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_contact` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_address1` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_address2` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_city_town` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_state_province` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_postal_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_country_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_telephone1` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bill_email` varchar(48) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_acct_id` int(11) NOT NULL DEFAULT '0',
  `ship_address_id` int(11) NOT NULL DEFAULT '0',
  `ship_primary_name` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_contact` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_address1` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_address2` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_city_town` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_state_province` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_postal_code` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_country_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_telephone1` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_email` varchar(48) COLLATE utf8_unicode_ci DEFAULT NULL,
  `terminal_date` date DEFAULT NULL,
  `drop_ship` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `period` (`period`),
  KEY `journal_id` (`journal_id`),
  KEY `post_date` (`post_date`),
  KEY `closed` (`closed`),
  KEY `bill_acct_id` (`bill_acct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table phreeform
DROP TABLE IF EXISTS phreeform;

CREATE TABLE `phreeform` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `doc_type` enum('0','c','s') COLLATE utf8_unicode_ci NOT NULL DEFAULT 's',
  `doc_title` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `doc_group` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_ext` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `security` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'u:0;g:0',
  `create_date` date DEFAULT NULL,
  `last_update` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO phreeform (`id`,`parent_id`,`doc_type`,`doc_title`,`doc_group`,`doc_ext`,`security`,`create_date`,`last_update`) VALUES 
('1', '0', '0', 'Miscellaneous', 'misc', '0', 'u:0;g:0', '2026-01-02', ''),
('2', '1', '0', 'Reports', 'misc', 'fr', 'u:0;g:0', '2026-01-02', ''),
('3', '1', '0', 'Forms', 'misc:misc', 'ff', 'u:0;g:0', '2026-01-02', ''),
('4', '0', '0', 'Customers', 'cust', '0', 'u:0;g:0', '2026-01-02', ''),
('5', '4', '0', 'Reports', 'cust', 'fr', 'u:0;g:0', '2026-01-02', ''),
('6', '4', '0', 'Customer Quotes', 'cust:quot', 'ff', 'u:0;g:0', '2026-01-02', ''),
('7', '4', '0', 'Sales Orders', 'cust:so', 'ff', 'u:0;g:0', '2026-01-02', ''),
('8', '4', '0', 'Invoices/Packing Slips', 'cust:inv', 'ff', 'u:0;g:0', '2026-01-02', ''),
('9', '4', '0', 'Credit Memos - Customer', 'cust:cm', 'ff', 'u:0;g:0', '2026-01-02', ''),
('10', '4', '0', 'Customer Statements', 'cust:stmt', 'ff', 'u:0;g:0', '2026-01-02', ''),
('11', '4', '0', 'Collection Letters', 'cust:col', 'ff', 'u:0;g:0', '2026-01-02', ''),
('12', '4', '0', 'Labels - Customer', 'cust:lblc', 'ff', 'u:0;g:0', '2026-01-02', ''),
('13', '0', '0', 'Vendors', 'vend', '0', 'u:0;g:0', '2026-01-02', ''),
('14', '13', '0', 'Reports', 'vend', 'fr', 'u:0;g:0', '2026-01-02', ''),
('15', '13', '0', 'Vendor Quotes', 'vend:quot', 'ff', 'u:0;g:0', '2026-01-02', ''),
('16', '13', '0', 'Purchase Orders', 'vend:po', 'ff', 'u:0;g:0', '2026-01-02', ''),
('17', '13', '0', 'Credit Memos - Vendor', 'vend:cm', 'ff', 'u:0;g:0', '2026-01-02', ''),
('18', '13', '0', 'Labels - Vendor', 'vend:lblv', 'ff', 'u:0;g:0', '2026-01-02', ''),
('19', '13', '0', 'Vendor Statements', 'vend:stmt', 'ff', 'u:0;g:0', '2026-01-02', ''),
('20', '0', '0', 'Banking', 'bnk', '0', 'u:0;g:0', '2026-01-02', ''),
('21', '20', '0', 'Reports', 'bnk', 'fr', 'u:0;g:0', '2026-01-02', ''),
('22', '20', '0', 'Deposit Slips', 'bnk:deps', 'ff', 'u:0;g:0', '2026-01-02', ''),
('23', '20', '0', 'Bank Checks', 'bnk:chk', 'ff', 'u:0;g:0', '2026-01-02', ''),
('24', '20', '0', 'Sales Receipts', 'bnk:rcpt', 'ff', 'u:0;g:0', '2026-01-02', ''),
('25', '0', '0', 'General Ledger', 'gl', '0', 'u:0;g:0', '2026-01-02', ''),
('26', '25', '0', 'Reports', 'gl', 'fr', 'u:0;g:0', '2026-01-02', ''),
('27', '0', '0', 'Employees', 'hr', '0', 'u:0;g:0', '2026-01-02', ''),
('28', '27', '0', 'Reports', 'hr', 'fr', 'u:0;g:0', '2026-01-02', ''),
('29', '0', '0', 'Inventory', 'inv', '0', 'u:0;g:0', '2026-01-02', ''),
('30', '29', '0', 'Reports', 'inv', 'fr', 'u:0;g:0', '2026-01-02', ''),
('31', '0', '0', 'Point of Sale', 'pos', '0', 'u:0;g:0', '2026-01-02', ''),
('32', '31', '0', 'Reports', 'pos', 'fr', 'u:0;g:0', '2026-01-02', ''),
('33', '31', '0', 'Receipts', 'pos:rcpt', 'ff', 'u:0;g:0', '2026-01-02', ''),
('34', '5', 's', 'Customer List', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('35', '28', 's', 'Employee List', 'hr', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('36', '14', 's', 'Vendor List', 'vend', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('37', '30', 's', 'Inventory Aging - Average Cost', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('38', '30', 's', 'Inventory Aging', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('39', '30', 's', 'Inventory List', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('40', '30', 's', 'Inventory Re-order Worksheet', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('41', '30', 's', 'Inventory Transfer Report', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('42', '30', 's', 'Inventory Valuation - Average', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('43', '30', 's', 'Inventory Valuation - Branch', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('44', '30', 's', 'Inventory Valuation', 'inv', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('45', '21', 's', 'Account Reconciliation', 'bnk', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('46', '14', 's', 'Aged Payables', 'vend', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('47', '14', 's', 'Aged Payables Summary', 'vend', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('48', '5', 's', 'Aged Receivables', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('49', '5', 's', 'Aged Receivables Summary', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('50', '26', 's', 'Balance Sheet', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('51', '23', 's', 'Bank Check- Three Part', 'bnk:chk', 'frm', 'u:0;g:0', '2026-01-02', ''),
('52', '26', 's', 'Chart of Accounts', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('53', '9', 's', 'Credit Memo', 'cust:cm', 'frm', 'u:0;g:0', '2026-01-02', ''),
('54', '5', 's', 'Customer Invoice History', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('55', '5', 's', 'Customer Ledger', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('56', '21', 's', 'Customer Payments', 'bnk', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('57', '6', 's', 'Customer Quotes', 'cust:quot', 'frm', 'u:0;g:0', '2026-01-02', ''),
('58', '10', 's', 'Customer Statement', 'cust:stmt', 'frm', 'u:0;g:0', '2026-01-02', ''),
('59', '26', 's', 'Daily Cash Report', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('60', '9', 's', 'Deposit Receipt', 'cust:cm', 'frm', 'u:0;g:0', '2026-01-02', ''),
('61', '22', 's', 'Deposit Slip', 'bnk:deps', 'frm', 'u:0;g:0', '2026-01-02', ''),
('62', '26', 's', 'General Ledger', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('63', '26', 's', 'General Ledger Trial Balance', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('64', '26', 's', 'Income Statement', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('65', '26', 's', 'Income Statement w/Budget', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('66', '26', 's', 'Income Stmt - 2 Years', 'gl', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('67', '8', 's', 'Invoice-VAT', 'cust:inv', 'frm', 'u:0;g:0', '2026-01-02', ''),
('68', '8', 's', 'Invoice', 'cust:inv', 'frm', 'u:0;g:0', '2026-01-02', ''),
('69', '8', 's', 'Invoice/Packing Slip', 'cust:inv', 'frm', 'u:0;g:0', '2026-01-02', ''),
('70', '14', 's', 'Open Purchase Orders', 'vend', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('71', '5', 's', 'Open Sales Orders', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('72', '8', 's', 'Packing Slip', 'cust:inv', 'frm', 'u:0;g:0', '2026-01-02', ''),
('73', '16', 's', 'Purchase Order', 'vend:po', 'frm', 'u:0;g:0', '2026-01-02', ''),
('74', '15', 's', 'Request for Quote', 'vend:quot', 'frm', 'u:0;g:0', '2026-01-02', ''),
('75', '5', 's', 'Sales By Rep', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('76', '5', 's', 'Sales By SKU', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('77', '7', 's', 'Sales Order', 'cust:so', 'frm', 'u:0;g:0', '2026-01-02', ''),
('78', '5', 's', 'Sales Order Report', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('79', '5', 's', 'Sales Report', 'cust', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('80', '17', 's', 'Vendor Credit Memo', 'vend:cm', 'frm', 'u:0;g:0', '2026-01-02', ''),
('81', '14', 's', 'Vendor Ledger', 'vend', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('82', '21', 's', 'Vendor Payments', 'bnk', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('83', '19', 's', 'Vendor Statement', 'vend:stmt', 'frm', 'u:0;g:0', '2026-01-02', ''),
('84', '2', 's', 'Audit Log', 'misc', 'rpt', 'u:0;g:0', '2026-01-02', ''),
('85', '33', 's', 'POS Receipt Slip', 'pos:rcpt', 'frm', 'u:0;g:0', '2026-01-02', '');


-- Table structure for table phreehelp
DROP TABLE IF EXISTS phreehelp;

CREATE TABLE `phreehelp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `doc_type` enum('0','d') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'd',
  `doc_lang` char(5) COLLATE utf8_unicode_ci DEFAULT 'en_us',
  `doc_pos` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_index` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_text` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `doc_title` (`doc_title`,`doc_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table phreepos_other_trans
DROP TABLE IF EXISTS phreepos_other_trans;

CREATE TABLE `phreepos_other_trans` (
  `ot_id` int(11) NOT NULL AUTO_INCREMENT,
  `till_id` int(11) DEFAULT '0',
  `description` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `gl_acct_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `use_tax` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `taxable` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ot_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table phreepos_tills
DROP TABLE IF EXISTS phreepos_tills;

CREATE TABLE `phreepos_tills` (
  `till_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT '0',
  `description` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `gl_acct_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rounding_gl_acct_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dif_gl_acct_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `currencies_code` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `restrict_currency` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `printer_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `printer_starting_line` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `printer_closing_line` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `printer_open_drawer` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `balance` double DEFAULT '0',
  `max_discount` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_id` int(11) DEFAULT '-1',
  PRIMARY KEY (`till_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table price_sheets
DROP TABLE IF EXISTS price_sheets;

CREATE TABLE `price_sheets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sheet_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'c',
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `revision` float NOT NULL DEFAULT '0',
  `effective_date` date NOT NULL DEFAULT '0000-00-00',
  `expiration_date` date DEFAULT NULL,
  `default_sheet` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `default_levels` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table projects_costs
DROP TABLE IF EXISTS projects_costs;

CREATE TABLE `projects_costs` (
  `cost_id` int(8) NOT NULL AUTO_INCREMENT,
  `description_short` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description_long` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cost_type` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`cost_id`),
  KEY `description_short` (`description_short`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table projects_phases
DROP TABLE IF EXISTS projects_phases;

CREATE TABLE `projects_phases` (
  `phase_id` int(8) NOT NULL AUTO_INCREMENT,
  `description_short` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description_long` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cost_type` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost_breakdown` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`phase_id`),
  KEY `description_short` (`description_short`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table reconciliation
DROP TABLE IF EXISTS reconciliation;

CREATE TABLE `reconciliation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period` int(11) NOT NULL DEFAULT '0',
  `gl_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `statement_balance` double NOT NULL DEFAULT '0',
  `cleared_items` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `period` (`period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table shipping_log
DROP TABLE IF EXISTS shipping_log;

CREATE TABLE `shipping_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipment_id` int(11) NOT NULL DEFAULT '0',
  `ref_id` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `reconciled` smallint(4) NOT NULL DEFAULT '0',
  `carrier` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ship_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deliver_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `actual_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deliver_late` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `tracking_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cost` double NOT NULL DEFAULT '0',
  `notes` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ref_id` (`ref_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



-- Table structure for table tax_authorities
DROP TABLE IF EXISTS tax_authorities;

CREATE TABLE `tax_authorities` (
  `tax_auth_id` int(3) NOT NULL AUTO_INCREMENT,
  `type` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'c',
  `description_short` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description_long` char(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vendor_id` int(5) NOT NULL DEFAULT '0',
  `tax_rate` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_auth_id`),
  KEY `description_short` (`description_short`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO tax_authorities (`tax_auth_id`,`type`,`description_short`,`description_long`,`account_id`,`vendor_id`,`tax_rate`) VALUES 
('1', 'c', 'FIRS', 'Federal Inland Revenue Service', '2310', '0', '7.5'),
('2', 'v', 'FIRS', 'Federal Inland Revenue Service', '2310', '0', '7.5'),
('3', 'c', 'FIRS', 'Federal Inland Revenue Service', '2315', '0', '-5');


-- Table structure for table tax_rates
DROP TABLE IF EXISTS tax_rates;

CREATE TABLE `tax_rates` (
  `tax_rate_id` int(3) NOT NULL AUTO_INCREMENT,
  `type` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'c',
  `description_short` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description_long` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_accounts` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `freight_taxable` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_rate_id`),
  KEY `description_short` (`description_short`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO tax_rates (`tax_rate_id`,`type`,`description_short`,`description_long`,`rate_accounts`,`freight_taxable`) VALUES 
('1', 'c', 'VAT', 'Value Added Tax', '1', '0'),
('2', 'v', 'VAT', 'Value Added Tax', '2', '0'),
('3', 'c', 'WHT', 'Withholding Tax', '3', '0');


-- Table structure for table users
DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `is_role` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `admin_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `display_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `admin_email` varchar(96) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `admin_pass` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_id` int(11) NOT NULL DEFAULT '0',
  `admin_store_id` int(11) NOT NULL DEFAULT '0',
  `admin_prefs` text COLLATE utf8_unicode_ci,
  `admin_security` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`admin_id`),
  KEY `idx_admin_name_zen` (`admin_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO users (`admin_id`,`is_role`,`admin_name`,`inactive`,`display_name`,`admin_email`,`admin_pass`,`account_id`,`admin_store_id`,`admin_prefs`,`admin_security`) VALUES 
('1', '0', 'admin', '0', '', 'abiemeralds@gmail.com', 'e1725f5ba8e45556b2094a1dfbb9f9e7:ef', '0', '0', 'a:7:{s:4:\"role\";s:1:\"0\";s:12:\"def_store_id\";s:1:\"0\";s:13:\"def_cash_acct\";s:4:\"1045\";s:11:\"def_ar_acct\";s:4:\"1100\";s:11:\"def_ap_acct\";s:4:\"2000\";s:14:\"restrict_store\";s:1:\"0\";s:15:\"restrict_period\";s:1:\"0\";}', '26:4,49:4,16:4,88:4,29:4,35:4,28:4,32:4,30:4,34:4,31:4,40:4,38:4,51:4,89:4,54:4,59:4,53:4,58:4,55:4,61:4,57:4,60:4,151:4,152:4,153:4,102:4,111:4,107:4,109:4,103:4,101:4,112:4,108:4,110:4,105:4,104:4,39:4,113:4,126:4,130:4,4:4,129:4,19:4,76:4,2:4,18:4,3:4,13:4,7:4,11:4,1:4,5:4,6:4');


-- Table structure for table users_profiles
DROP TABLE IF EXISTS users_profiles;

CREATE TABLE `users_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `menu_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dashboard_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `column_id` int(3) NOT NULL DEFAULT '0',
  `row_id` int(3) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO users_profiles (`id`,`user_id`,`menu_id`,`module_id`,`dashboard_id`,`column_id`,`row_id`,`params`) VALUES 
('2', '1', 'index', 'phreebooks', 'mini_financial', '1', '2', 'a:0:{}'),
('3', '1', 'index', 'phreebooks', 'open_inv', '1', '3', 'a:1:{s:8:\"num_rows\";i:0;}'),
('4', '1', 'index', 'phreebooks', 'todays_sales', '1', '4', 'a:1:{s:8:\"num_rows\";i:0;}');


-- Table structure for table xtra_fields
DROP TABLE IF EXISTS xtra_fields;

CREATE TABLE `xtra_fields` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tab_id` int(11) NOT NULL DEFAULT '0',
  `entry_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group_by` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `use_in_inventory_filter` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `params` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO xtra_fields (`id`,`module_id`,`tab_id`,`entry_type`,`field_name`,`description`,`sort_order`,`group_by`,`use_in_inventory_filter`,`params`) VALUES 
('1', 'contacts', '0', 'text', 'account_number', 'account_number', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"16\";}'),
('2', 'contacts', '0', 'text', 'attachments', 'attachments', '', '', '0', 'a:3:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:6:\"65,535\";}'),
('3', 'contacts', '0', 'text', 'contact_first', 'contact_first', '', '', '0', 'a:3:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('4', 'contacts', '0', 'text', 'contact_last', 'contact_last', '', '', '0', 'a:3:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('5', 'contacts', '0', 'text', 'contact_middle', 'contact_middle', '', '', '0', 'a:3:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('6', 'contacts', '0', 'text', 'contacts_level', 'contacts_level', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"r\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:1:\"1\";}'),
('7', 'contacts', '0', 'text', 'dept_rep_id', 'dept_rep_id', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"16\";}'),
('8', 'contacts', '0', 'date', 'first_date', 'first_date', '', '', '0', 'a:2:{s:7:\"default\";s:10:\"0000-00-00\";s:4:\"type\";s:4:\"date\";}'),
('9', 'contacts', '0', 'text', 'gl_type_account', 'gl_type_account', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"15\";}'),
('10', 'contacts', '0', 'text', 'gov_id_number', 'gov_id_number', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"16\";}'),
('11', 'contacts', '0', 'integer', 'id', 'id', '', '', '0', 'a:2:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";}'),
('12', 'contacts', '0', 'check_box', 'inactive', 'inactive', '', '', '0', 'a:2:{s:7:\"default\";s:11:\"0:0:1,1:1:0\";s:4:\"type\";s:9:\"drop_down\";}'),
('13', 'contacts', '0', 'date', 'last_date_1', 'last_date_1', '', '', '0', 'a:2:{s:7:\"default\";N;s:4:\"type\";s:4:\"date\";}'),
('14', 'contacts', '0', 'date', 'last_date_2', 'last_date_2', '', '', '0', 'a:2:{s:7:\"default\";N;s:4:\"type\";s:4:\"date\";}'),
('15', 'contacts', '0', 'date', 'last_update', 'last_update', '', '', '0', 'a:2:{s:7:\"default\";N;s:4:\"type\";s:4:\"date\";}'),
('16', 'contacts', '0', 'text', 'price_sheet', 'price_sheet', '', '', '0', 'a:3:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('17', 'contacts', '0', 'text', 'short_name', 'short_name', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('18', 'contacts', '0', 'text', 'special_terms', 'special_terms', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"0\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";}'),
('19', 'contacts', '0', 'text', 'store_id', 'store_id', '', '', '0', 'a:3:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"15\";}'),
('20', 'contacts', '0', 'integer', 'tax_id', 'tax_id', '', '', '0', 'a:2:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";}'),
('21', 'contacts', '0', 'text', 'type', 'type', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"c\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:1:\"1\";}'),
('22', 'inventory', '0', 'text', 'account_cost_of_sales', 'account_cost_of_sales', '', '', '0', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"15\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('23', 'inventory', '0', 'text', 'account_inventory_wage', 'account_inventory_wage', '', '', '0', 'a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"15\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('24', 'inventory', '0', 'text', 'account_sales_income', 'account_sales_income', '', '', '0', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"15\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('25', 'inventory', '0', 'text', 'attachments', 'attachments', '', '', '0', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:6:\"65,535\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('26', 'inventory', '0', 'drop_down', 'cost_method', 'cost_method', '', '', '0', 'a:3:{s:7:\"default\";s:17:\"a:a:0,f:f:1,l:l:0\";s:4:\"type\";s:9:\"drop_down\";s:14:\"inventory_type\";s:20:\"ia:ma:mb:mi:ms:ns:si\";}'),
('27', 'inventory', '0', 'date_time', 'creation_date', 'creation_date', '', '', '1', 'a:3:{s:7:\"default\";s:19:\"0000-00-00 00:00:00\";s:4:\"type\";s:9:\"date_time\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('28', 'inventory', '0', 'text', 'description_purchase', 'description_purchase', '', '', '1', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:3:\"255\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('29', 'inventory', '0', 'text', 'description_sales', 'description_sales', '', '', '1', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:3:\"255\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('30', 'inventory', '0', 'text', 'description_short', 'description_short', '', '', '1', 'a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('31', 'inventory', '0', 'decimal', 'full_price', 'full_price', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('32', 'inventory', '0', 'decimal', 'full_price_with_tax', 'full_price_with_tax', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('33', 'inventory', '0', 'integer', 'id', 'id', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('34', 'inventory', '0', 'text', 'image_with_path', 'image_with_path', '', '', '0', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:3:\"255\";s:14:\"inventory_type\";s:26:\"ia:ma:mb:mi:ms:ns:sa:si:sr\";}'),
('35', 'inventory', '0', 'check_box', 'inactive', 'inactive', '', '', '1', 'a:3:{s:7:\"default\";s:11:\"0:0:1,1:1:0\";s:4:\"type\";s:9:\"drop_down\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('36', 'inventory', '0', 'text', 'inventory_type', 'inventory_type', '', '', '1', 'a:4:{s:7:\"default\";s:2:\"si\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:1:\"2\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('37', 'inventory', '0', 'decimal', 'item_cost', 'item_cost', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('38', 'inventory', '0', 'integer', 'item_taxable', 'item_taxable', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('39', 'inventory', '0', 'decimal', 'item_weight', 'item_weight', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:26:\"ia:ma:mb:mi:ms:ns:sa:si:sr\";}'),
('40', 'inventory', '0', 'date_time', 'last_journal_date', 'last_journal_date', '', '', '1', 'a:3:{s:7:\"default\";s:19:\"0000-00-00 00:00:00\";s:4:\"type\";s:9:\"date_time\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('41', 'inventory', '0', 'date_time', 'last_update', 'last_update', '', '', '1', 'a:3:{s:7:\"default\";s:19:\"0000-00-00 00:00:00\";s:4:\"type\";s:9:\"date_time\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('42', 'inventory', '0', 'integer', 'lead_time', 'lead_time', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";s:14:\"inventory_type\";s:38:\"ai:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('43', 'inventory', '0', 'decimal', 'minimum_stock_level', 'minimum_stock_level', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:20:\"ia:ma:mi:ns:sa:si:sr\";}'),
('44', 'inventory', '0', 'text', 'price_sheet', 'price_sheet', '', '', '1', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('45', 'inventory', '0', 'text', 'price_sheet_v', 'price_sheet_v', '', '', '1', 'a:4:{s:7:\"default\";N;s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"32\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('46', 'inventory', '0', 'decimal', 'product_margin', 'product_margin', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('47', 'inventory', '0', 'decimal', 'product_markup', 'product_markup', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('48', 'inventory', '0', 'integer', 'purch_taxable', 'purch_taxable', '', '', '0', 'a:3:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";s:14:\"inventory_type\";s:38:\"ci:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('49', 'inventory', '0', 'decimal', 'quantity_on_allocation', 'quantity_on_allocation', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:14:\"ia:mi:sa:si:sr\";}'),
('50', 'inventory', '0', 'decimal', 'quantity_on_hand', 'quantity_on_hand', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:20:\"ia:ma:mi:ns:sa:si:sr\";}'),
('51', 'inventory', '0', 'decimal', 'quantity_on_order', 'quantity_on_order', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:14:\"ia:mi:sa:si:sr\";}'),
('52', 'inventory', '0', 'decimal', 'quantity_on_sales_order', 'quantity_on_sales_order', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:17:\"ia:ma:mi:sa:si:sr\";}'),
('53', 'inventory', '0', 'decimal', 'reorder_quantity', 'reorder_quantity', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"1\";s:4:\"type\";s:7:\"decimal\";s:14:\"inventory_type\";s:20:\"ia:ma:mi:ns:sa:si:sr\";}'),
('54', 'inventory', '0', 'drop_down', 'serialize', 'serialize', '', '', '1', 'a:3:{s:7:\"default\";s:11:\"0:0:1,1:1:0\";s:4:\"type\";s:9:\"drop_down\";s:14:\"inventory_type\";s:5:\"sa:sr\";}'),
('55', 'inventory', '0', 'text', 'sku', 'sku', '', '', '1', 'a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"24\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}'),
('56', 'inventory', '0', 'text', 'upc_code', 'upc_code', '', '', '1', 'a:4:{s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:6:\"length\";s:2:\"13\";s:14:\"inventory_type\";s:20:\"ia:ma:mi:ns:sa:si:sr\";}'),
('57', 'inventory', '0', 'integer', 'vendor_id', 'vendor_id', '', '', '1', 'a:3:{s:7:\"default\";s:1:\"3\";s:4:\"type\";s:7:\"integer\";s:14:\"inventory_type\";s:44:\"ai:ci:ds:ia:lb:ma:mb:mi:ms:ns:sa:sf:si:sr:sv\";}');


-- Table structure for table xtra_tabs
DROP TABLE IF EXISTS xtra_tabs;

CREATE TABLE `xtra_tabs` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tab_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



